/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.engine.io.ChunkState;
import org.restlet.engine.io.ReadableBufferedChannel;
import org.restlet.engine.io.WrapperChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadableChunkedChannel
extends WrapperChannel<ReadableBufferedChannel>
implements ReadableByteChannel {
    private volatile long remainingChunkSize = 0L;
    private volatile ChunkState chunkState = ChunkState.SIZE;

    public ReadableChunkedChannel(ReadableBufferedChannel source) {
        super(source);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        result = 0;
        tryAgain = true;
        while (tryAgain) {
            switch (1.$SwitchMap$org$restlet$engine$io$ChunkState[this.chunkState.ordinal()]) {
                case 1: {
                    if (!((ReadableBufferedChannel)this.getWrappedChannel()).fillLineBuilder()) ** GOTO lbl27
                    length = ((ReadableBufferedChannel)this.getWrappedChannel()).getLineBuilder().length();
                    if (length == 0) {
                        throw new IOException("An empty chunk size line was detected");
                    }
                    index = ((ReadableBufferedChannel)this.getWrappedChannel()).getLineBuilder().indexOf(";");
                    index = index == -1 ? ((ReadableBufferedChannel)this.getWrappedChannel()).getLineBuilder().length() : index;
                    try {
                        this.remainingChunkSize = Long.parseLong(((ReadableBufferedChannel)this.getWrappedChannel()).getLineBuilder().substring(0, index).trim(), 16);
                        if (Context.getCurrentLogger().isLoggable(Level.FINE)) {
                            Context.getCurrentLogger().fine("New chunk detected. Size: " + this.remainingChunkSize);
                        }
                    }
                    catch (NumberFormatException ex) {
                        throw new IOException("\"" + ((ReadableBufferedChannel)this.getWrappedChannel()).getLineBuilder() + "\" has an invalid chunk size");
                    }
                    finally {
                        ((ReadableBufferedChannel)this.getWrappedChannel()).clearLineBuilder();
                    }
                    if (this.remainingChunkSize == 0L) {
                        this.chunkState = ChunkState.TRAILER;
                        break;
                    }
                    this.chunkState = ChunkState.DATA;
                    break;
lbl27:
                    // 1 sources

                    tryAgain = false;
                    break;
                }
                case 2: {
                    if (this.remainingChunkSize > 0L) {
                        if (this.remainingChunkSize < (long)dst.remaining()) {
                            dst.limit((int)(this.remainingChunkSize + (long)dst.position()));
                        }
                        result = ((ReadableBufferedChannel)this.getWrappedChannel()).read(dst);
                        tryAgain = false;
                        if (result > 0) {
                            this.remainingChunkSize -= (long)result;
                            break;
                        }
                        if (!Context.getCurrentLogger().isLoggable(Level.FINE)) break;
                        Context.getCurrentLogger().fine("No chunk data read");
                        break;
                    }
                    if (this.remainingChunkSize != 0L) break;
                    if (((ReadableBufferedChannel)this.getWrappedChannel()).fillLineBuilder()) {
                        ((ReadableBufferedChannel)this.getWrappedChannel()).clearLineBuilder();
                        this.chunkState = ChunkState.SIZE;
                        break;
                    }
                    tryAgain = false;
                    break;
                }
                case 3: {
                    this.chunkState = ChunkState.END;
                    break;
                }
                case 4: {
                    if (!((ReadableBufferedChannel)this.getWrappedChannel()).fillLineBuilder() || ((ReadableBufferedChannel)this.getWrappedChannel()).getLineBuilder().length() != 0) break;
                    result = -1;
                    tryAgain = false;
                }
            }
        }
        if (this.getWrappedChannel() instanceof ReadableBufferedChannel) {
            ((ReadableBufferedChannel)this.getWrappedChannel()).postRead(result);
        }
        return result;
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$restlet$engine$io$ChunkState;

        static {
            $SwitchMap$org$restlet$engine$io$ChunkState = new int[ChunkState.values().length];
            try {
                1.$SwitchMap$org$restlet$engine$io$ChunkState[ChunkState.SIZE.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$restlet$engine$io$ChunkState[ChunkState.DATA.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$restlet$engine$io$ChunkState[ChunkState.TRAILER.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$restlet$engine$io$ChunkState[ChunkState.END.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

