/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.connector;

import java.io.IOException;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.engine.connector.Connection;
import org.restlet.engine.connector.OutboundWay;
import org.restlet.engine.header.Header;
import org.restlet.engine.header.HeaderUtils;
import org.restlet.engine.util.ReferenceUtils;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClientOutboundWay
extends OutboundWay {
    public ClientOutboundWay(Connection<?> connection, int bufferSize) {
        super(connection, bufferSize);
    }

    @Override
    protected void addHeaders(Series<Header> headers) {
        Request request = this.getMessage().getRequest();
        this.addGeneralHeaders(headers);
        this.addEntityHeaders(request.getEntity(), headers);
        this.addRequestHeaders(headers);
    }

    protected void addRequestHeaders(Series<Header> headers) {
        HeaderUtils.addRequestHeaders(this.getMessage().getRequest(), headers);
    }

    @Override
    public Request getActualMessage() {
        return this.getMessage() == null ? null : this.getMessage().getRequest();
    }

    public Connection<Client> getConnection() {
        return super.getConnection();
    }

    @Override
    public void onCompleted(boolean endDetected) throws IOException {
        Request request;
        Response message = this.getMessage();
        if (message != null && (request = message.getRequest()).getOnSent() != null) {
            request.getOnSent().handle(request, message);
        }
        super.onCompleted(endDetected);
    }

    @Override
    protected void writeStartLine() throws IOException {
        Request request = this.getMessage().getRequest();
        this.getLineBuilder().append(request.getMethod().getName());
        this.getLineBuilder().append(' ');
        this.getLineBuilder().append(ReferenceUtils.format(request.getResourceRef(), this.getHelper().isProxying(), request));
        this.getLineBuilder().append(' ');
        this.getLineBuilder().append(ClientOutboundWay.getVersion(request));
        this.getLineBuilder().append("\r\n");
    }
}

