/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.application;

import java.util.Set;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.engine.application.CorsResponseHelper;
import org.restlet.engine.util.SetUtils;
import org.restlet.routing.Filter;

public class CorsFilter
extends Filter {
    public boolean allowAllRequestedHeaders = true;
    public boolean allowedCredentials = false;
    public Set<String> allowedHeaders = null;
    public Set<String> allowedOrigins = SetUtils.newHashSet("*");
    private CorsResponseHelper corsResponseHelper;
    public Set<String> exposedHeaders = null;

    public CorsFilter() {
        this(null);
    }

    public CorsFilter(Context context) {
        super(context, null);
    }

    public CorsFilter(Context context, Restlet next) {
        super(context, next);
    }

    @Override
    protected void afterHandle(Request request, Response response) {
        CorsResponseHelper corsResponseHelper = this.getCorsResponseHelper();
        corsResponseHelper.addCorsResponseHeaders(request, response);
    }

    public Set<String> getAllowedHeaders() {
        return this.allowedHeaders;
    }

    public Set<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    protected CorsResponseHelper getCorsResponseHelper() {
        if (this.corsResponseHelper == null) {
            this.corsResponseHelper = new CorsResponseHelper();
            this.corsResponseHelper.setAllowedCredentials(this.allowedCredentials);
            this.corsResponseHelper.setAllowedOrigins(this.allowedOrigins);
            this.corsResponseHelper.setAllowAllRequestedHeaders(this.allowAllRequestedHeaders);
            this.corsResponseHelper.setAllowedHeaders(this.allowedHeaders);
            this.corsResponseHelper.setExposedHeaders(this.exposedHeaders);
        }
        return this.corsResponseHelper;
    }

    public Set<String> getExposedHeaders() {
        return this.exposedHeaders;
    }

    public boolean isAllowAllRequestedHeaders() {
        return this.allowAllRequestedHeaders;
    }

    public boolean isAllowedCredentials() {
        return this.allowedCredentials;
    }

    public CorsFilter setAllowingAllRequestedHeaders(boolean allowingAllRequestedHeaders) {
        this.allowAllRequestedHeaders = allowingAllRequestedHeaders;
        return this;
    }

    public CorsFilter setAllowedCredentials(boolean allowedCredentials) {
        this.allowedCredentials = allowedCredentials;
        return this;
    }

    public CorsFilter setAllowedHeaders(Set<String> allowedHeaders) {
        this.allowedHeaders = allowedHeaders;
        return this;
    }

    public CorsFilter setAllowedOrigins(Set<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
        return this;
    }

    public CorsFilter setExposedHeaders(Set<String> exposedHeaders) {
        this.exposedHeaders = exposedHeaders;
        return this;
    }
}

