/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.data.CharacterSet;
import org.restlet.engine.Edition;
import org.restlet.engine.Engine;
import org.restlet.engine.io.InputStreamChannel;
import org.restlet.engine.io.NbChannelInputStream;
import org.restlet.engine.io.NbChannelOutputStream;
import org.restlet.engine.io.PipeStream;
import org.restlet.engine.io.ReaderInputStream;
import org.restlet.engine.io.SelectorFactory;
import org.restlet.engine.io.WriterOutputStream;
import org.restlet.engine.util.ContextualRunnable;
import org.restlet.representation.Representation;
import org.restlet.representation.WriterRepresentation;

public class IoUtils {
    public static final int BUFFER_SIZE = IoUtils.getProperty("org.restlet.engine.io.bufferSize", 8192);
    private static final char[] HEXDIGITS = "0123456789ABCDEF".toCharArray();
    public static final int TIMEOUT_MS = IoUtils.getProperty("org.restlet.engine.io.timeoutMs", 60000);

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        if (inputStream != null) {
            if (outputStream != null) {
                int bytesRead;
                byte[] buffer = new byte[2048];
                while ((bytesRead = inputStream.read(buffer)) > 0) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                outputStream.flush();
                inputStream.close();
            } else {
                Context.getCurrentLogger().log(Level.FINE, "Unable to copy input to output stream. Output stream is null.");
            }
        } else {
            Context.getCurrentLogger().log(Level.FINE, "Unable to copy input to output stream. Input stream is null.");
        }
    }

    public static void copy(InputStream inputStream, RandomAccessFile randomAccessFile) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[2048];
        while ((bytesRead = inputStream.read(buffer)) > 0) {
            randomAccessFile.write(buffer, 0, bytesRead);
        }
        inputStream.close();
    }

    public static void copy(ReadableByteChannel readableChannel, WritableByteChannel writableChannel) throws IOException {
        if (readableChannel != null && writableChannel != null) {
            IoUtils.copy(IoUtils.getStream(readableChannel), IoUtils.getStream(writableChannel));
        }
    }

    public static void copy(Reader reader, Writer writer) throws IOException {
        int charsRead;
        char[] buffer = new char[2048];
        while ((charsRead = reader.read(buffer)) > 0) {
            writer.write(buffer, 0, charsRead);
        }
        writer.flush();
        reader.close();
    }

    public static boolean delete(File file) {
        return IoUtils.delete(file, false);
    }

    public static boolean delete(File file, boolean recursive) {
        String osName = System.getProperty("os.name").toLowerCase();
        return IoUtils.delete(file, recursive, osName.startsWith("windows"));
    }

    public static boolean delete(File file, boolean recursive, boolean garbageCollect) {
        boolean result = true;
        boolean runGC = garbageCollect;
        if (file.exists()) {
            File[] entries;
            if (file.isDirectory() && (entries = file.listFiles()).length > 0) {
                if (recursive) {
                    for (int i = 0; result && i < entries.length; ++i) {
                        if (runGC) {
                            System.gc();
                            runGC = false;
                        }
                        result = IoUtils.delete(entries[i], true, false);
                    }
                } else {
                    result = false;
                }
            }
            if (runGC) {
                System.gc();
                runGC = false;
            }
            result = result && file.delete();
        }
        return result;
    }

    public static long exhaust(InputStream input) throws IOException {
        long result = -1L;
        if (input != null) {
            byte[] buf = new byte[2048];
            int read = input.read(buf);
            long l = result = read == -1 ? -1L : 0L;
            while (read != -1) {
                result += (long)read;
                read = input.read(buf);
            }
        }
        return result;
    }

    public static long getAvailableSize(Representation representation) {
        if (representation.getRange() == null) {
            return representation.getSize();
        }
        if (representation.getRange().getSize() != -1L) {
            if (representation.hasKnownSize()) {
                return Math.min(representation.getRange().getIndex() + representation.getRange().getSize(), representation.getSize()) - representation.getRange().getIndex();
            }
            return -1L;
        }
        if (representation.hasKnownSize()) {
            if (representation.getRange().getIndex() != -1L) {
                return representation.getSize() - representation.getRange().getIndex();
            }
            return representation.getSize();
        }
        return -1L;
    }

    public static ReadableByteChannel getChannel(InputStream inputStream) throws IOException {
        ReadableByteChannel result = null;
        if (inputStream instanceof FileInputStream) {
            result = ((FileInputStream)inputStream).getChannel();
        } else if (inputStream != null) {
            result = new InputStreamChannel(inputStream);
        }
        return result;
    }

    public static WritableByteChannel getChannel(OutputStream outputStream) {
        return outputStream != null ? Channels.newChannel(outputStream) : null;
    }

    public static ReadableByteChannel getChannel(final Representation representation) throws IOException {
        Pipe.SourceChannel result = null;
        if (Edition.CURRENT != Edition.GAE) {
            final Pipe pipe = Pipe.open();
            Runnable task = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Pipe.SinkChannel wbc = null;
                    try {
                        wbc = pipe.sink();
                        representation.write(wbc);
                    }
                    catch (IOException ioe) {
                        Context.getCurrentLogger().log(Level.WARNING, "Error while writing to the piped channel.", ioe);
                    }
                    finally {
                        if (wbc != null) {
                            try {
                                wbc.close();
                            }
                            catch (IOException e) {
                                Context.getCurrentLogger().log(Level.WARNING, "Error while closing to the piped channel.", e);
                            }
                        }
                    }
                }
            };
            Context context = Context.getCurrent();
            if (context != null && context.getExecutorService() != null) {
                context.getExecutorService().execute(task);
            } else {
                Engine.createThreadWithLocalVariables(task, "Restlet-IoUtils").start();
            }
            result = pipe.source();
        } else {
            Context.getCurrentLogger().log(Level.WARNING, "The GAE edition is unable to return a channel for a representation given its write(WritableByteChannel) method.");
        }
        return result;
    }

    private static int getProperty(String name, int defaultValue) {
        int result = defaultValue;
        try {
            result = Integer.parseInt(System.getProperty(name));
        }
        catch (NumberFormatException nfe) {
            result = defaultValue;
        }
        return result;
    }

    public static Reader getReader(InputStream stream, CharacterSet characterSet) throws UnsupportedEncodingException {
        if (characterSet != null) {
            return new InputStreamReader(stream, characterSet.getName());
        }
        return new InputStreamReader(stream);
    }

    public static Reader getReader(final WriterRepresentation representation) throws IOException {
        PipedReader result = null;
        final PipedWriter pipedWriter = new PipedWriter();
        PipedReader pipedReader = new PipedReader(pipedWriter);
        ContextualRunnable task = new ContextualRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    representation.write(pipedWriter);
                    pipedWriter.flush();
                }
                catch (IOException ioe) {
                    Context.getCurrentLogger().log(Level.WARNING, "Error while writing to the piped reader.", ioe);
                }
                finally {
                    try {
                        pipedWriter.close();
                    }
                    catch (IOException ioe2) {
                        Context.getCurrentLogger().log(Level.WARNING, "Error while closing the pipe.", ioe2);
                    }
                }
            }
        };
        Context context = Context.getCurrent();
        if (context != null && context.getExecutorService() != null) {
            context.getExecutorService().execute(task);
        } else {
            Engine.createThreadWithLocalVariables(task, "Restlet-IoUtils").start();
        }
        result = pipedReader;
        return result;
    }

    public static OutputStream getStream(Writer writer, CharacterSet characterSet) {
        return new WriterOutputStream(writer, characterSet);
    }

    public static InputStream getStream(ReadableByteChannel readableChannel) {
        InputStream result = null;
        if (readableChannel != null) {
            result = IoUtils.isBlocking(readableChannel) ? Channels.newInputStream(readableChannel) : new NbChannelInputStream(readableChannel);
        }
        return result;
    }

    public static InputStream getStream(Reader reader, CharacterSet characterSet) {
        ReaderInputStream result = null;
        try {
            result = new ReaderInputStream(reader, characterSet);
        }
        catch (IOException e) {
            Context.getCurrentLogger().log(Level.WARNING, "Unable to create the reader input stream", e);
        }
        return result;
    }

    public static InputStream getStream(final Representation representation) {
        InputStream result = null;
        if (representation == null) {
            return null;
        }
        PipeStream pipe = new PipeStream();
        final OutputStream os = pipe.getOutputStream();
        ContextualRunnable task = new ContextualRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    representation.write(os);
                    os.flush();
                }
                catch (IOException ioe) {
                    Context.getCurrentLogger().log(Level.WARNING, "Error while writing to the piped input stream.", ioe);
                }
                finally {
                    try {
                        os.close();
                    }
                    catch (IOException ioe2) {
                        Context.getCurrentLogger().log(Level.WARNING, "Error while closing the pipe.", ioe2);
                    }
                }
            }
        };
        Context context = Context.getCurrent();
        if (context != null && context.getExecutorService() != null) {
            context.getExecutorService().execute(task);
        } else {
            Engine.createThreadWithLocalVariables(task, "Restlet-IoUtils").start();
        }
        result = pipe.getInputStream();
        return result;
    }

    public static OutputStream getStream(WritableByteChannel writableChannel) {
        OutputStream result = null;
        if (writableChannel != null) {
            result = IoUtils.isBlocking(writableChannel) ? Channels.newOutputStream(writableChannel) : new NbChannelOutputStream(writableChannel);
        }
        return result;
    }

    public static String getText(Representation representation) throws IOException {
        String result = null;
        if (representation.isAvailable()) {
            if (representation.getSize() == 0L) {
                result = "";
            } else {
                StringWriter sw = new StringWriter();
                representation.write(sw);
                sw.flush();
                result = sw.toString();
            }
        }
        return result;
    }

    public static Writer getWriter(OutputStream outputStream, CharacterSet characterSet) {
        OutputStreamWriter result = null;
        result = characterSet != null ? new OutputStreamWriter(outputStream, characterSet.toCharset()) : new OutputStreamWriter(outputStream, CharacterSet.ISO_8859_1.toCharset());
        return result;
    }

    public static boolean isBlocking(Channel channel) {
        boolean result = true;
        if (channel instanceof SelectableChannel) {
            SelectableChannel selectableChannel = (SelectableChannel)channel;
            result = selectableChannel.isBlocking();
        }
        return result;
    }

    public static void release(Selector selector, SelectionKey selectionKey) throws IOException {
        if (selectionKey != null) {
            selectionKey.cancel();
            if (selector != null) {
                selector.selectNow();
                SelectorFactory.returnSelector(selector);
            }
        }
    }

    public static byte[] toByteArray(char[] chars) {
        return IoUtils.toByteArray(chars, Charset.defaultCharset().name());
    }

    public static byte[] toByteArray(char[] chars, String charsetName) {
        CharBuffer cb = CharBuffer.wrap(chars);
        ByteBuffer bb = Charset.forName(charsetName).encode(cb);
        byte[] r = new byte[bb.remaining()];
        bb.get(r);
        return r;
    }

    public static char[] toCharArray(byte[] bytes) {
        return IoUtils.toCharArray(bytes, Charset.defaultCharset().name());
    }

    public static char[] toCharArray(byte[] bytes, String charsetName) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        CharBuffer cb = Charset.forName(charsetName).decode(bb);
        char[] r = new char[cb.remaining()];
        cb.get(r);
        return r;
    }

    public static String toHexString(byte[] byteArray) {
        char[] hexChars = new char[2 * byteArray.length];
        int i = 0;
        for (byte b : byteArray) {
            hexChars[i++] = HEXDIGITS[b >> 4 & 0xF];
            hexChars[i++] = HEXDIGITS[b & 0xF];
        }
        return new String(hexChars);
    }

    public static String toString(InputStream inputStream) {
        return IoUtils.toString(inputStream, null);
    }

    public static String toString(InputStream inputStream, CharacterSet characterSet) {
        String result = null;
        if (inputStream != null) {
            try {
                result = characterSet != null ? IoUtils.toString(new InputStreamReader(inputStream, characterSet.getName())) : IoUtils.toString(new InputStreamReader(inputStream));
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static String toString(Reader reader) {
        String result = null;
        if (reader != null) {
            try {
                StringBuilder sb = new StringBuilder();
                BufferedReader br = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, BUFFER_SIZE);
                char[] buffer = new char[2048];
                int charsRead = br.read(buffer);
                while (charsRead != -1) {
                    sb.append(buffer, 0, charsRead);
                    charsRead = br.read(buffer);
                }
                br.close();
                result = sb.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private IoUtils() {
    }
}

