/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.atom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.ext.atom.Workspace;
import org.restlet.ext.atom.internal.ServiceContentReader;
import org.restlet.ext.xml.SaxRepresentation;
import org.restlet.ext.xml.XmlWriter;
import org.restlet.representation.Representation;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Service
extends SaxRepresentation {
    public static final String APP_NAMESPACE = "http://www.w3.org/2007/app";
    private volatile Reference baseReference;
    private volatile Client clientDispatcher;
    private volatile Reference reference;
    private volatile List<Workspace> workspaces;

    public Service(Client clientDispatcher) {
        super(new MediaType("***"));
        this.setNamespaceAware(true);
        this.clientDispatcher = clientDispatcher;
    }

    public Service(Client clientDispatcher, String serviceUri) throws IOException {
        this(clientDispatcher, serviceUri, clientDispatcher.handle(new Request(Method.GET, serviceUri)).getEntity());
    }

    public Service(Client clientDispatcher, String serviceUri, Representation xmlService) throws IOException {
        super(xmlService);
        this.setNamespaceAware(true);
        this.clientDispatcher = clientDispatcher;
        this.reference = serviceUri == null ? null : new Reference(serviceUri);
        this.parse(new ServiceContentReader(this));
    }

    public Service(Context context, String serviceUri) throws IOException {
        this(context.getClientDispatcher(), serviceUri, context.getClientDispatcher().handle(new Request(Method.GET, serviceUri)).getEntity());
    }

    public Service(Representation xmlService) throws IOException {
        this(null, null, xmlService);
    }

    public Service(String serviceUri) throws IOException {
        this(new Client(new Reference(serviceUri).getSchemeProtocol()), serviceUri);
    }

    public Service(String serviceUri, Representation xmlService) throws IOException {
        this(new Client(new Reference(serviceUri).getSchemeProtocol()), serviceUri, xmlService);
    }

    public Status deleteResource(String uri) {
        return this.getClientDispatcher().handle(new Request(Method.DELETE, uri)).getStatus();
    }

    public Reference getBaseReference() {
        return this.baseReference;
    }

    public Client getClientDispatcher() {
        return this.clientDispatcher;
    }

    public Reference getReference() {
        return this.reference;
    }

    public Representation getResource(String uri) {
        return this.getClientDispatcher().handle(new Request(Method.GET, uri)).getEntity();
    }

    public List<Workspace> getWorkspaces() {
        if (this.workspaces == null) {
            this.workspaces = new ArrayList<Workspace>();
        }
        return this.workspaces;
    }

    public void setBaseReference(Reference baseReference) {
        this.baseReference = baseReference;
    }

    public void setClientDispatcher(Client clientDispatcher) {
        this.clientDispatcher = clientDispatcher;
    }

    public void setReference(Reference ref) {
        this.reference = ref;
    }

    public Status updateResource(String uri, Representation updatedRepresentation) {
        return this.getClientDispatcher().handle(new Request(Method.PUT, uri, updatedRepresentation)).getStatus();
    }

    public void write(XmlWriter writer) throws IOException {
        try {
            writer.forceNSDecl(APP_NAMESPACE, "");
            writer.forceNSDecl("http://www.w3.org/2005/Atom", "atom");
            writer.setDataFormat(true);
            writer.setIndentStep(3);
            writer.startDocument();
            writer.startElement(APP_NAMESPACE, "service");
            for (Workspace workspace : this.getWorkspaces()) {
                workspace.writeElement(writer);
            }
            writer.endElement(APP_NAMESPACE, "service");
            writer.endDocument();
        }
        catch (SAXException se) {
            throw new IOException("Couldn't write the service representation: " + se.getMessage());
        }
    }
}

