/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.crypto;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.Context;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Reference;
import org.restlet.ext.crypto.DigestUtils;
import org.restlet.ext.crypto.DigestVerifier;
import org.restlet.ext.crypto.internal.CryptoUtils;
import org.restlet.security.ChallengeAuthenticator;
import org.restlet.security.LocalVerifier;
import org.restlet.security.Verifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DigestAuthenticator
extends ChallengeAuthenticator {
    private static final long DEFAULT_MAX_SERVER_NONCE_AGE = 300000L;
    private volatile List<Reference> domainRefs;
    private volatile long maxServerNonceAge;
    private volatile String serverKey;

    public DigestAuthenticator(Context context, boolean optional, String realm, List<Reference> domainRefs, String serverKey) {
        super(context, optional, ChallengeScheme.HTTP_DIGEST, realm);
        this.domainRefs = domainRefs;
        this.maxServerNonceAge = 300000L;
        this.serverKey = serverKey;
        this.setVerifier((Verifier)new org.restlet.ext.crypto.internal.DigestVerifier(this, null, null));
    }

    public DigestAuthenticator(Context context, String realm, String serverKey) {
        this(context, false, realm, null, serverKey);
    }

    protected ChallengeRequest createChallengeRequest(boolean stale) {
        ChallengeRequest result = super.createChallengeRequest(stale);
        result.setDomainRefs(this.getDomainRefs());
        result.setStale(stale);
        result.setServerNonce(this.generateServerNonce());
        return result;
    }

    public String generateServerNonce() {
        return CryptoUtils.makeNonce(this.getServerKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Reference> getDomainRefs() {
        List<Reference> r = this.domainRefs;
        if (r == null) {
            DigestAuthenticator digestAuthenticator = this;
            synchronized (digestAuthenticator) {
                r = this.domainRefs;
                if (r == null) {
                    this.domainRefs = r = new CopyOnWriteArrayList<Reference>();
                    this.domainRefs.add(new Reference("/"));
                }
            }
        }
        return r;
    }

    public String getHashedSecret(String identifier, char[] secret) {
        if (ChallengeScheme.HTTP_DIGEST.equals((Object)this.getScheme())) {
            return DigestUtils.toHttpDigest(identifier, secret, this.getRealm());
        }
        return null;
    }

    public long getMaxServerNonceAge() {
        return this.maxServerNonceAge;
    }

    public String getServerKey() {
        return this.serverKey;
    }

    public DigestVerifier<LocalVerifier> getVerifier() {
        return (DigestVerifier)super.getVerifier();
    }

    public void setDomainRefs(List<Reference> domainRefs) {
        this.domainRefs = domainRefs;
    }

    public void setMaxServerNonceAge(long maxServerNonceAge) {
        this.maxServerNonceAge = maxServerNonceAge;
    }

    public void setServerKey(String serverKey) {
        this.serverKey = serverKey;
    }

    public void setVerifier(Verifier verifier) {
        if (ChallengeScheme.HTTP_DIGEST.equals((Object)this.getScheme())) {
            if (!(verifier instanceof DigestVerifier)) {
                throw new IllegalArgumentException("Only subclasses on HttpDigestVerifier are allowed. You might want to set the \"wrappedVerifier\" property instead.");
            }
            super.setVerifier(verifier);
        } else {
            if (!(verifier instanceof DigestVerifier)) {
                throw new IllegalArgumentException("Only subclasses on DigestVerifier are allowed. You might want to set the \"wrappedVerifier\" property instead.");
            }
            super.setVerifier(verifier);
        }
    }

    public void setWrappedAlgorithm(String wrappedAlgorithm) {
        this.getVerifier().setWrappedAlgorithm(wrappedAlgorithm);
    }

    public void setWrappedVerifier(LocalVerifier localVerifier) {
        this.getVerifier().setWrappedVerifier(localVerifier);
    }
}

