/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.freemarker;

import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Date;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.representation.Representation;

public class ContextTemplateLoader
implements TemplateLoader {
    private final String baseUri;
    private final Context context;

    public ContextTemplateLoader(Context context, Reference baseRef) {
        this(context, baseRef.toString());
    }

    public ContextTemplateLoader(Context context, String baseUri) {
        this.context = context;
        this.baseUri = baseUri;
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
        if (templateSource instanceof Representation) {
            ((Representation)templateSource).release();
        }
    }

    public Object findTemplateSource(String name) throws IOException {
        String fullUri = this.getBaseUri().endsWith("/") ? this.getBaseUri() + name : this.getBaseUri() + "/" + name;
        return this.getContext() == null ? null : this.getContext().getClientDispatcher().handle(new Request(Method.GET, fullUri)).getEntity();
    }

    private String getBaseUri() {
        return this.baseUri;
    }

    private Context getContext() {
        return this.context;
    }

    public long getLastModified(Object templateSource) {
        Date lastModified = ((Representation)templateSource).getModificationDate();
        return lastModified == null ? -1L : lastModified.getTime();
    }

    public Reader getReader(Object templateSource, String characterSet) throws IOException {
        Representation r = (Representation)templateSource;
        return new InputStreamReader(r.getStream(), characterSet);
    }
}

