/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.guice;

import javax.inject.Inject;
import org.restlet.Application;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.ext.guice.SelfInjectingServerResource;
import org.restlet.resource.Finder;
import org.restlet.resource.ServerResource;
import org.restlet.routing.Router;

public abstract class ResourceInjectingApplication
extends Application {
    @Inject
    private volatile SelfInjectingServerResource.MembersInjector membersInjector;

    public static Finder wrapFinderWithMemberInjection(final Finder finder, final SelfInjectingServerResource.MembersInjector membersInjector) {
        return new Finder(finder.getContext(), finder.getTargetClass()){

            public ServerResource find(Request request, Response response) {
                ServerResource res = finder.find(request, response);
                if (res instanceof SelfInjectingServerResource) {
                    SelfInjectingServerResource tmp = (SelfInjectingServerResource)res;
                    tmp.ensureInjected(membersInjector);
                } else {
                    membersInjector.injectMembers(res);
                }
                return res;
            }
        };
    }

    public Finder createFinder(Class<? extends ServerResource> targetClass) {
        Finder finder = super.createFinder(targetClass);
        return ResourceInjectingApplication.wrapFinderWithMemberInjection(finder, this.membersInjector);
    }

    public Router newRouter() {
        final ResourceInjectingApplication app = this;
        return new Router(this.getContext()){

            public Application getApplication() {
                return app;
            }
        };
    }
}

