/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.Stage;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.ext.guice.FinderFactory;
import org.restlet.resource.Finder;
import org.restlet.resource.ServerResource;

public class RestletGuice {
    public static Injector createInjector(com.google.inject.Module ... modules) {
        return RestletGuice.injectorFor(null, new Module(modules));
    }

    public static Injector createInjector(Iterable<com.google.inject.Module> modules) {
        return RestletGuice.injectorFor(null, new Module(modules));
    }

    public static Injector createInjector(Stage stage, com.google.inject.Module ... modules) {
        return RestletGuice.injectorFor(stage, new Module(modules));
    }

    public static Injector createInjector(Stage stage, Iterable<com.google.inject.Module> modules) {
        return RestletGuice.injectorFor(stage, new Module(modules));
    }

    private static Injector injectorFor(Stage stage, Module rootModule) {
        if (stage == null) {
            return Guice.createInjector((com.google.inject.Module[])new com.google.inject.Module[]{rootModule});
        }
        return Guice.createInjector((Stage)stage, (com.google.inject.Module[])new com.google.inject.Module[]{rootModule});
    }

    public static class Module
    extends AbstractModule
    implements FinderFactory {
        private static ThreadLocal<Boolean> alreadyBound = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }
        };
        @Inject
        private volatile Injector injector;
        private final Iterable<? extends com.google.inject.Module> modules;

        public Module(com.google.inject.Module ... modules) {
            this.modules = Arrays.asList(modules);
        }

        public Module(Iterable<? extends com.google.inject.Module> modules) {
            this.modules = modules;
        }

        @Inject
        private void clearAlreadyBound() {
            alreadyBound.set(false);
        }

        protected final void configure() {
            if (this.injector != null) {
                throw new IllegalStateException("can't reconfigure with existing Injector");
            }
            if (!alreadyBound.get().booleanValue()) {
                alreadyBound.set(true);
                this.bind(FinderFactory.class).toInstance((Object)this);
                this.bind(Application.class).toProvider(this.newApplicationProvider());
                this.bind(Context.class).toProvider(this.newContextProvider());
                this.bind(Request.class).toProvider(this.newRequestProvider());
                this.bind(Response.class).toProvider(this.newResponseProvider());
            }
            for (com.google.inject.Module module : this.modules) {
                this.install(module);
            }
        }

        @Override
        public Finder finder(Class<?> cls) {
            return new ServerResourceKeyFinder(Key.get(cls));
        }

        @Override
        public Finder finder(Class<?> cls, Class<? extends Annotation> qualifier) {
            return new ServerResourceKeyFinder(Key.get(cls, qualifier));
        }

        protected Provider<Application> newApplicationProvider() {
            return new Provider<Application>(){

                public Application get() {
                    return Application.getCurrent();
                }
            };
        }

        protected Provider<Context> newContextProvider() {
            return new Provider<Context>(){

                public Context get() {
                    return Context.getCurrent();
                }
            };
        }

        protected Provider<Request> newRequestProvider() {
            return new Provider<Request>(){

                public Request get() {
                    return Request.getCurrent();
                }
            };
        }

        protected Provider<Response> newResponseProvider() {
            return new Provider<Response>(){

                public Response get() {
                    return Response.getCurrent();
                }
            };
        }

        class ServerResourceKeyFinder
        extends KeyFinder {
            private final Key<?> serverResourceKey;

            ServerResourceKeyFinder(Key<?> serverResourceKey) {
                super(serverResourceKey.getTypeLiteral().getType());
                this.serverResourceKey = serverResourceKey;
            }

            public ServerResource create(Request request, Response response) {
                try {
                    return (ServerResource)ServerResource.class.cast(this.getInjector().getInstance(this.serverResourceKey));
                }
                catch (ClassCastException ex) {
                    String msg = String.format("Must bind %s to ServerResource (or subclass)", this.serverResourceKey);
                    throw new ProvisionException(msg, (Throwable)ex);
                }
            }
        }

        class KeyFinder
        extends Finder {
            private final Class<?> targetClass;

            KeyFinder(Type type) {
                this.targetClass = (Class)type;
            }

            public final Context getContext() {
                return (Context)this.getInjector().getInstance(Context.class);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected final Injector getInjector() {
                Injector inj = Module.this.injector;
                if (inj == null) {
                    Module module = Module.this;
                    synchronized (module) {
                        inj = Module.this.injector;
                        if (inj == null) {
                            inj = Guice.createInjector((com.google.inject.Module[])new com.google.inject.Module[]{Module.this});
                            Module.this.injector = inj;
                        }
                    }
                }
                return inj;
            }

            public final Class<? extends ServerResource> getTargetClass() {
                Class<ServerResource> src = ServerResource.class;
                if (src != null && this.targetClass != null && src.isAssignableFrom(this.targetClass)) {
                    Class<?> result = this.targetClass;
                    return result;
                }
                return super.getTargetClass();
            }
        }
    }
}

