/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.html;

import java.io.IOException;
import java.io.OutputStream;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.data.Parameter;
import org.restlet.engine.header.ContentType;
import org.restlet.engine.header.HeaderUtils;
import org.restlet.ext.html.FormData;
import org.restlet.ext.html.internal.FormUtils;
import org.restlet.representation.OutputRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.util.Series;

public class FormDataSet
extends OutputRepresentation {
    private static final String DEFAULT_BOUNDARY = "---Aa1Bb2Cc3---";
    private final Series<FormData> entries = new Series(FormData.class);
    private volatile boolean multipart;
    private volatile String multipartBoundary;

    private static MediaType createMultipartMediaType(String boundary) {
        Series params = new Series(Parameter.class);
        params.add("boundary", boundary);
        MediaType result = new MediaType(MediaType.MULTIPART_FORM_DATA.getName(), params);
        return result;
    }

    public FormDataSet() {
        this(null, false, DEFAULT_BOUNDARY);
    }

    private FormDataSet(MediaType mediaType, boolean multipart, String multipartBoundary) {
        super(mediaType);
        this.multipartBoundary = multipartBoundary;
        this.multipart = multipart;
    }

    public FormDataSet(Representation formRepresentation) {
        this();
        if (formRepresentation != null && MediaType.APPLICATION_WWW_FORM.equals((Object)formRepresentation.getMediaType())) {
            FormUtils.parse(this.entries, formRepresentation);
        }
    }

    public FormDataSet(String multipartBoundary) {
        this(FormDataSet.createMultipartMediaType(multipartBoundary), true, multipartBoundary);
    }

    public FormData add(String name, String value) {
        FormData result = (FormData)this.getEntries().createEntry(name, value);
        this.getEntries().add((Object)result);
        return result;
    }

    public String encode() throws IOException {
        return this.encode(false);
    }

    public String encode(boolean queryString) throws IOException {
        return this.encode('&', queryString);
    }

    public String encode(char separator, boolean queryString) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.getEntries().size(); ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            ((FormData)this.getEntries().get(i)).encode(sb, queryString);
        }
        return sb.toString();
    }

    public Series<FormData> getEntries() {
        return this.entries;
    }

    public String getMatrixString() {
        try {
            return this.encode(';', true);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public String getMultipartBoundary() {
        return this.multipartBoundary;
    }

    public String getQueryString() {
        try {
            return this.encode(true);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public boolean isMultipart() {
        return this.multipart;
    }

    public void setMultipart(boolean multipart) {
        this.multipart = multipart;
        this.setMediaType(FormDataSet.createMultipartMediaType(this.getMultipartBoundary()));
    }

    public void setMultipartBoundary(String boundary) {
        this.multipartBoundary = boundary;
    }

    public void write(OutputStream outputStream) throws IOException {
        if (this.isMultipart()) {
            for (FormData data : this.getEntries()) {
                String line;
                outputStream.write(("--" + this.getMultipartBoundary()).getBytes());
                HeaderUtils.writeCRLF((OutputStream)outputStream);
                if (MediaType.TEXT_PLAIN.equals((Object)data.getMediaType())) {
                    line = "Content-Disposition: form-data; name=\"" + data.getName() + "\"";
                    outputStream.write(line.getBytes());
                    HeaderUtils.writeCRLF((OutputStream)outputStream);
                } else {
                    line = "Content-Disposition: form-data; name=\"" + data.getName() + "\"; filename=\"" + data.getFilename() + "\"";
                    outputStream.write(line.getBytes());
                    HeaderUtils.writeCRLF((OutputStream)outputStream);
                    line = "Content-Type: " + ContentType.writeHeader((Representation)data.getValueRepresentation());
                    outputStream.write(line.getBytes());
                    HeaderUtils.writeCRLF((OutputStream)outputStream);
                }
                HeaderUtils.writeCRLF((OutputStream)outputStream);
                data.getValueRepresentation().write(outputStream);
                HeaderUtils.writeCRLF((OutputStream)outputStream);
            }
            outputStream.write(("--" + this.getMultipartBoundary() + "--").getBytes());
            HeaderUtils.writeCRLF((OutputStream)outputStream);
        } else {
            StringRepresentation formRep = new StringRepresentation((CharSequence)this.getQueryString(), MediaType.APPLICATION_WWW_FORM, null, CharacterSet.UTF_8);
            formRep.write(outputStream);
        }
    }
}

