/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.util.List;
import org.restlet.data.MediaType;
import org.restlet.data.Preference;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.ext.jackson.JacksonRepresentation;
import org.restlet.ext.jackson.JacksonSmileRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.Resource;

public class JacksonConverter
extends ConverterHelper {
    private static final VariantInfo VARIANT_APPLICATION_XML = new VariantInfo(MediaType.APPLICATION_XML);
    private static final VariantInfo VARIANT_APPLICATION_YAML = new VariantInfo(MediaType.APPLICATION_YAML);
    private static final VariantInfo VARIANT_JSON = new VariantInfo(MediaType.APPLICATION_JSON);
    private static final VariantInfo VARIANT_JSON_SMILE = new VariantInfo(MediaType.APPLICATION_JSON_SMILE);
    private static final VariantInfo VARIANT_TEXT_CSV = new VariantInfo(MediaType.TEXT_CSV);
    private static final VariantInfo VARIANT_TEXT_XML = new VariantInfo(MediaType.TEXT_XML);
    private static final VariantInfo VARIANT_TEXT_YAML = new VariantInfo(MediaType.TEXT_YAML);
    private ObjectMapper binaryObjectMapper;
    private ObjectMapper csvMapper;
    private ObjectMapper objectMapper;
    private ObjectMapper xmlMapper;
    private ObjectMapper yamlMapper;

    protected <T> JacksonRepresentation<T> create(MediaType mediaType, T source) {
        JacksonRepresentation<T> result = new JacksonRepresentation<T>(mediaType, source);
        result.setObjectMapper(this.getObjectMapper());
        return result;
    }

    protected <T> JacksonRepresentation<T> create(Representation source, Class<T> objectClass) {
        JacksonRepresentation<T> result = new JacksonRepresentation<T>(source, objectClass);
        result.setObjectMapper(this.getObjectMapper());
        return result;
    }

    protected <T> JacksonSmileRepresentation<T> createBinary(MediaType mediaType, T source) {
        JacksonSmileRepresentation<T> result = new JacksonSmileRepresentation<T>(mediaType, source);
        result.setObjectMapper(this.getBinaryObjectMapper());
        return result;
    }

    protected <T> JacksonSmileRepresentation<T> createBinary(Representation source, Class<T> objectClass) {
        JacksonSmileRepresentation<T> result = new JacksonSmileRepresentation<T>(source, objectClass);
        result.setObjectMapper(this.getBinaryObjectMapper());
        return result;
    }

    protected ObjectMapper createBinaryObjectMapper() {
        SmileFactory jsonFactory = new SmileFactory();
        jsonFactory.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        return new ObjectMapper((JsonFactory)jsonFactory);
    }

    protected <T> JacksonRepresentation<T> createCsv(MediaType mediaType, T source) {
        JacksonRepresentation<T> result = new JacksonRepresentation<T>(mediaType, source);
        result.setObjectMapper(this.getCsvMapper());
        return result;
    }

    protected <T> JacksonRepresentation<T> createCsv(Representation source, Class<T> objectClass) {
        JacksonRepresentation<T> result = new JacksonRepresentation<T>(source, objectClass);
        result.setObjectMapper(this.getCsvMapper());
        return result;
    }

    protected ObjectMapper createCsvMapper() {
        return new CsvMapper();
    }

    protected ObjectMapper createObjectMapper() {
        JsonFactory jsonFactory = new JsonFactory();
        jsonFactory.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        return new ObjectMapper(jsonFactory);
    }

    protected <T> JacksonRepresentation<T> createXml(MediaType mediaType, T source) {
        JacksonRepresentation<T> result = new JacksonRepresentation<T>(mediaType, source);
        result.setObjectMapper(this.getXmlMapper());
        return result;
    }

    protected <T> JacksonRepresentation<T> createXml(Representation source, Class<T> objectClass) {
        JacksonRepresentation<T> result = new JacksonRepresentation<T>(source, objectClass);
        result.setObjectMapper(this.getXmlMapper());
        return result;
    }

    protected ObjectMapper createXmlMapper() {
        XmlFactory xmlFactory = new XmlFactory();
        xmlFactory.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        return new XmlMapper(xmlFactory);
    }

    protected <T> JacksonRepresentation<T> createYaml(MediaType mediaType, T source) {
        JacksonRepresentation<T> result = new JacksonRepresentation<T>(mediaType, source);
        result.setObjectMapper(this.getYamlMapper());
        return result;
    }

    protected <T> JacksonRepresentation<T> createYaml(Representation source, Class<T> objectClass) {
        JacksonRepresentation<T> result = new JacksonRepresentation<T>(source, objectClass);
        result.setObjectMapper(this.getYamlMapper());
        return result;
    }

    protected ObjectMapper createYamlMapper() {
        YAMLFactory yamlFactory = new YAMLFactory();
        yamlFactory.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        return new ObjectMapper((JsonFactory)yamlFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectMapper getBinaryObjectMapper() {
        if (this.binaryObjectMapper == null) {
            JacksonConverter jacksonConverter = this;
            synchronized (jacksonConverter) {
                if (this.binaryObjectMapper == null) {
                    this.binaryObjectMapper = this.createBinaryObjectMapper();
                }
            }
        }
        return this.binaryObjectMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectMapper getCsvMapper() {
        if (this.csvMapper == null) {
            JacksonConverter jacksonConverter = this;
            synchronized (jacksonConverter) {
                if (this.csvMapper == null) {
                    this.csvMapper = this.createCsvMapper();
                }
            }
        }
        return this.csvMapper;
    }

    public List<Class<?>> getObjectClasses(Variant source) {
        List result = null;
        if (VARIANT_JSON.isCompatible(source) || VARIANT_JSON_SMILE.isCompatible(source) || VARIANT_APPLICATION_XML.isCompatible(source) || VARIANT_TEXT_XML.isCompatible(source) || VARIANT_APPLICATION_YAML.isCompatible(source) || VARIANT_TEXT_YAML.isCompatible(source) || VARIANT_TEXT_CSV.isCompatible(source)) {
            result = this.addObjectClass(result, Object.class);
            result = this.addObjectClass(result, JacksonRepresentation.class);
            result = this.addObjectClass(result, JacksonSmileRepresentation.class);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            JacksonConverter jacksonConverter = this;
            synchronized (jacksonConverter) {
                if (this.objectMapper == null) {
                    this.objectMapper = this.createObjectMapper();
                }
            }
        }
        return this.objectMapper;
    }

    public List<VariantInfo> getVariants(Class<?> source) {
        List result = null;
        if (source != null) {
            result = this.addVariant(result, VARIANT_JSON);
            result = this.addVariant(result, VARIANT_JSON_SMILE);
            result = this.addVariant(result, VARIANT_APPLICATION_XML);
            result = this.addVariant(result, VARIANT_TEXT_XML);
            result = this.addVariant(result, VARIANT_APPLICATION_YAML);
            result = this.addVariant(result, VARIANT_TEXT_YAML);
            result = this.addVariant(result, VARIANT_TEXT_CSV);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectMapper getXmlMapper() {
        if (this.xmlMapper == null) {
            JacksonConverter jacksonConverter = this;
            synchronized (jacksonConverter) {
                if (this.xmlMapper == null) {
                    this.xmlMapper = this.createXmlMapper();
                }
            }
        }
        return this.xmlMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectMapper getYamlMapper() {
        if (this.yamlMapper == null) {
            JacksonConverter jacksonConverter = this;
            synchronized (jacksonConverter) {
                if (this.yamlMapper == null) {
                    this.yamlMapper = this.createYamlMapper();
                }
            }
        }
        return this.yamlMapper;
    }

    public float score(Object source, Variant target, Resource resource) {
        float result = -1.0f;
        result = source instanceof JacksonRepresentation ? 1.0f : (source instanceof JacksonSmileRepresentation ? 1.0f : (target == null ? 0.5f : (VARIANT_JSON.isCompatible(target) ? 0.8f : (VARIANT_JSON_SMILE.isCompatible(target) ? 0.8f : (VARIANT_APPLICATION_XML.isCompatible(target) ? 0.8f : (VARIANT_TEXT_XML.isCompatible(target) ? 0.8f : (VARIANT_APPLICATION_YAML.isCompatible(target) ? 0.8f : (VARIANT_TEXT_YAML.isCompatible(target) ? 0.8f : (VARIANT_TEXT_CSV.isCompatible(target) ? 0.8f : 0.5f)))))))));
        return result;
    }

    public <T> float score(Representation source, Class<T> target, Resource resource) {
        float result = -1.0f;
        if (source instanceof JacksonRepresentation) {
            result = 1.0f;
        } else if (source instanceof JacksonSmileRepresentation) {
            result = 1.0f;
        } else if (target != null && JacksonRepresentation.class.isAssignableFrom(target)) {
            result = 1.0f;
        } else if (target != null && JacksonSmileRepresentation.class.isAssignableFrom(target)) {
            result = 1.0f;
        } else if (VARIANT_JSON.isCompatible((Variant)source)) {
            result = 0.8f;
        } else if (VARIANT_JSON_SMILE.isCompatible((Variant)source)) {
            result = 0.8f;
        } else if (VARIANT_APPLICATION_XML.isCompatible((Variant)source)) {
            result = 0.8f;
        } else if (VARIANT_TEXT_XML.isCompatible((Variant)source)) {
            result = 0.8f;
        } else if (VARIANT_APPLICATION_YAML.isCompatible((Variant)source)) {
            result = 0.8f;
        } else if (VARIANT_TEXT_YAML.isCompatible((Variant)source)) {
            result = 0.8f;
        } else if (VARIANT_TEXT_CSV.isCompatible((Variant)source)) {
            result = 0.8f;
        }
        return result;
    }

    public void setBinaryObjectMapper(ObjectMapper objectMapper) {
        this.binaryObjectMapper = objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setXmlMapper(ObjectMapper xmlMapper) {
        this.xmlMapper = xmlMapper;
    }

    public <T> T toObject(Representation source, Class<T> target, Resource resource) throws IOException {
        Object result = null;
        JacksonSmileRepresentation<T> bSource = null;
        if (source instanceof JacksonSmileRepresentation) {
            bSource = (JacksonSmileRepresentation<T>)source;
        } else if (VARIANT_JSON_SMILE.isCompatible((Variant)source)) {
            bSource = this.createBinary(source, target);
        }
        if (bSource != null) {
            result = target != null && JacksonSmileRepresentation.class.isAssignableFrom(target) ? bSource : (Object)bSource.getObject();
        } else {
            JacksonRepresentation<T> jacksonSource = null;
            if (source instanceof JacksonRepresentation) {
                jacksonSource = (JacksonRepresentation<T>)source;
            } else if (VARIANT_JSON.isCompatible((Variant)source)) {
                jacksonSource = this.create(source, target);
            } else if (VARIANT_APPLICATION_XML.isCompatible((Variant)source) || VARIANT_TEXT_XML.isCompatible((Variant)source)) {
                jacksonSource = this.createXml(source, target);
            } else if (VARIANT_APPLICATION_YAML.isCompatible((Variant)source) || VARIANT_TEXT_YAML.isCompatible((Variant)source)) {
                jacksonSource = this.createYaml(source, target);
            } else if (VARIANT_TEXT_CSV.isCompatible((Variant)source)) {
                jacksonSource = this.createCsv(source, target);
            }
            if (jacksonSource != null) {
                result = target != null && JacksonRepresentation.class.isAssignableFrom(target) ? jacksonSource : jacksonSource.getObject();
            }
        }
        return (T)result;
    }

    public Representation toRepresentation(Object source, Variant target, Resource resource) {
        JacksonRepresentation<Object> result = null;
        if (source instanceof JacksonRepresentation) {
            result = (JacksonRepresentation)((Object)source);
        } else if (source instanceof JacksonSmileRepresentation) {
            result = (JacksonSmileRepresentation)((Object)source);
        } else {
            if (target.getMediaType() == null) {
                target.setMediaType(MediaType.APPLICATION_JSON);
            }
            if (VARIANT_JSON_SMILE.isCompatible(target)) {
                result = this.createBinary(target.getMediaType(), source);
            } else if (VARIANT_JSON.isCompatible(target)) {
                result = this.create(target.getMediaType(), source);
            } else if (VARIANT_APPLICATION_XML.isCompatible(target) || VARIANT_TEXT_XML.isCompatible(target)) {
                result = this.createXml(target.getMediaType(), source);
            } else if (VARIANT_APPLICATION_YAML.isCompatible(target) || VARIANT_TEXT_YAML.isCompatible(target)) {
                result = this.createYaml(target.getMediaType(), source);
            } else if (VARIANT_TEXT_CSV.isCompatible(target)) {
                result = this.createCsv(target.getMediaType(), source);
            }
        }
        return result;
    }

    public <T> void updatePreferences(List<Preference<MediaType>> preferences, Class<T> entity) {
        this.updatePreferences(preferences, MediaType.APPLICATION_JSON, 1.0f);
        this.updatePreferences(preferences, MediaType.APPLICATION_JSON_SMILE, 1.0f);
        this.updatePreferences(preferences, MediaType.APPLICATION_XML, 1.0f);
        this.updatePreferences(preferences, MediaType.TEXT_XML, 1.0f);
        this.updatePreferences(preferences, MediaType.APPLICATION_YAML, 1.0f);
        this.updatePreferences(preferences, MediaType.TEXT_YAML, 1.0f);
        this.updatePreferences(preferences, MediaType.TEXT_CSV, 1.0f);
    }
}

