/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jackson;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.dataformat.csv.CsvFactory;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.OutputStream;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.representation.OutputRepresentation;
import org.restlet.representation.Representation;

public class JacksonRepresentation<T>
extends OutputRepresentation {
    private T object;
    private Class<T> objectClass;
    private Representation representation;
    private ObjectMapper objectMapper;
    private ObjectWriter objectWriter;
    private ObjectReader objectReader;
    private CsvSchema csvSchema;

    public JacksonRepresentation(MediaType mediaType, T object) {
        super(mediaType);
        this.object = object;
        this.objectClass = object == null ? null : object.getClass();
        this.representation = null;
        this.objectMapper = null;
        this.objectReader = null;
        this.objectWriter = null;
        this.csvSchema = null;
    }

    public JacksonRepresentation(Representation representation, Class<T> objectClass) {
        super(representation.getMediaType());
        this.object = null;
        this.objectClass = objectClass;
        this.representation = representation;
        this.objectMapper = null;
        this.objectReader = null;
        this.objectWriter = null;
        this.csvSchema = null;
    }

    public JacksonRepresentation(T object) {
        this(MediaType.APPLICATION_JSON, object);
    }

    protected CsvSchema createCsvSchema(CsvMapper csvMapper) {
        return csvMapper.schemaFor(this.getObjectClass());
    }

    protected ObjectMapper createObjectMapper() {
        ObjectMapper result = null;
        if (MediaType.APPLICATION_JSON.isCompatible((Metadata)this.getMediaType())) {
            JsonFactory jsonFactory = new JsonFactory();
            jsonFactory.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
            result = new ObjectMapper(jsonFactory);
        } else if (MediaType.APPLICATION_JSON_SMILE.isCompatible((Metadata)this.getMediaType())) {
            SmileFactory smileFactory = new SmileFactory();
            smileFactory.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
            result = new ObjectMapper((JsonFactory)smileFactory);
        } else if (MediaType.APPLICATION_XML.isCompatible((Metadata)this.getMediaType()) || MediaType.TEXT_XML.isCompatible((Metadata)this.getMediaType())) {
            XmlFactory xmlFactory = new XmlFactory();
            xmlFactory.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
            result = new XmlMapper(xmlFactory);
        } else if (MediaType.APPLICATION_YAML.isCompatible((Metadata)this.getMediaType())) {
            YAMLFactory yamlFactory = new YAMLFactory();
            yamlFactory.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
            result = new ObjectMapper((JsonFactory)yamlFactory);
        } else if (MediaType.TEXT_CSV.isCompatible((Metadata)this.getMediaType())) {
            CsvFactory csvFactory = new CsvFactory();
            csvFactory.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
            result = new CsvMapper(csvFactory);
        } else {
            JsonFactory jsonFactory = new JsonFactory();
            jsonFactory.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
            result = new ObjectMapper(jsonFactory);
        }
        return result;
    }

    protected ObjectReader createObjectReader() {
        ObjectReader result = null;
        if (MediaType.TEXT_CSV.isCompatible((Metadata)this.getMediaType())) {
            CsvMapper csvMapper = (CsvMapper)this.getObjectMapper();
            CsvSchema csvSchema = this.createCsvSchema(csvMapper);
            result = csvMapper.reader(this.getObjectClass()).with((FormatSchema)csvSchema);
        } else {
            result = this.getObjectMapper().reader(this.getObjectClass());
        }
        return result;
    }

    protected ObjectWriter createObjectWriter() {
        ObjectWriter result = null;
        if (MediaType.TEXT_CSV.isCompatible((Metadata)this.getMediaType())) {
            CsvMapper csvMapper = (CsvMapper)this.getObjectMapper();
            CsvSchema csvSchema = this.createCsvSchema(csvMapper);
            result = csvMapper.writer((FormatSchema)csvSchema);
        } else {
            result = this.getObjectMapper().writerWithType(this.getObjectClass());
        }
        return result;
    }

    public CsvSchema getCsvSchema() {
        if (this.csvSchema == null) {
            this.csvSchema = this.createCsvSchema((CsvMapper)this.getObjectMapper());
        }
        return this.csvSchema;
    }

    public T getObject() throws IOException {
        Object result = null;
        if (this.object != null) {
            result = this.object;
        } else if (this.representation != null) {
            result = this.getObjectReader().readValue(this.representation.getStream());
        }
        return (T)result;
    }

    public Class<T> getObjectClass() {
        return this.objectClass;
    }

    public ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = this.createObjectMapper();
        }
        return this.objectMapper;
    }

    public ObjectReader getObjectReader() {
        if (this.objectReader == null) {
            this.objectReader = this.createObjectReader();
        }
        return this.objectReader;
    }

    public ObjectWriter getObjectWriter() {
        if (this.objectWriter == null) {
            this.objectWriter = this.createObjectWriter();
        }
        return this.objectWriter;
    }

    public void setCsvSchema(CsvSchema csvSchema) {
        this.csvSchema = csvSchema;
    }

    public void setObject(T object) {
        this.object = object;
    }

    public void setObjectClass(Class<T> objectClass) {
        this.objectClass = objectClass;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setObjectReader(ObjectReader objectReader) {
        this.objectReader = objectReader;
    }

    public void setObjectWriter(ObjectWriter objectWriter) {
        this.objectWriter = objectWriter;
    }

    public void write(OutputStream outputStream) throws IOException {
        if (this.representation != null) {
            this.representation.write(outputStream);
        } else if (this.object != null) {
            this.getObjectWriter().writeValue(outputStream, this.object);
        }
    }
}

