/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.javamail;

import java.io.IOException;
import java.util.Date;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.Representation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RepresentationMessage
extends MimeMessage {
    public RepresentationMessage(Representation xmlMessage, Session session) throws IOException, AddressException, MessagingException {
        super(session);
        DomRepresentation dom = new DomRepresentation(xmlMessage);
        Document email = dom.getDocument();
        Element root = (Element)email.getElementsByTagName("email").item(0);
        Element header = (Element)root.getElementsByTagName("head").item(0);
        String subject = header.getElementsByTagName("subject").item(0).getTextContent();
        String from = header.getElementsByTagName("from").item(0).getTextContent();
        NodeList toList = header.getElementsByTagName("to");
        String[] to = new String[toList.getLength()];
        for (int i = 0; i < toList.getLength(); ++i) {
            to[i] = toList.item(i).getTextContent();
        }
        NodeList ccList = header.getElementsByTagName("cc");
        String[] cc = new String[ccList.getLength()];
        for (int i = 0; i < ccList.getLength(); ++i) {
            cc[i] = ccList.item(i).getTextContent();
        }
        NodeList bccList = header.getElementsByTagName("bcc");
        String[] bcc = new String[bccList.getLength()];
        for (int i = 0; i < bccList.getLength(); ++i) {
            bcc[i] = bccList.item(i).getTextContent();
        }
        String text = root.getElementsByTagName("body").item(0).getTextContent();
        this.setFrom((Address)new InternetAddress(from));
        for (String element : to) {
            this.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(element));
        }
        for (String element : cc) {
            this.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(element));
        }
        for (String element : bcc) {
            this.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(element));
        }
        this.setSubject(subject);
        this.setText(text);
        this.setSentDate(new Date());
        this.saveChanges();
    }

    public RepresentationMessage(Session session) {
        super(session);
    }
}

