/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxb.internal;

import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;
import javax.xml.bind.ValidationEventHandler;
import org.restlet.Context;
import org.restlet.ext.jaxb.JaxbRepresentation;
import org.restlet.representation.StringRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Marshaller<T> {
    private final JaxbRepresentation<T> jaxbRepresentation;
    private final ThreadLocal<javax.xml.bind.Marshaller> marshaller = new ThreadLocal<javax.xml.bind.Marshaller>(){

        @Override
        protected synchronized javax.xml.bind.Marshaller initialValue() {
            javax.xml.bind.Marshaller m = null;
            try {
                m = JaxbRepresentation.getContext(Marshaller.this.getContextPath(), Marshaller.this.getClassLoader()).createMarshaller();
                m.setProperty("jaxb.formatted.output", (Object)Marshaller.this.getJaxbRepresentation().isFormattedOutput());
                if (Marshaller.this.getJaxbRepresentation().getSchemaLocation() != null) {
                    m.setProperty("jaxb.schemaLocation", (Object)Marshaller.this.getJaxbRepresentation().getSchemaLocation());
                }
                if (Marshaller.this.getJaxbRepresentation().getNoNamespaceSchemaLocation() != null) {
                    m.setProperty("jaxb.noNamespaceSchemaLocation", (Object)Marshaller.this.getJaxbRepresentation().getNoNamespaceSchemaLocation());
                }
                if (Marshaller.this.jaxbRepresentation.getCharacterSet() != null) {
                    m.setProperty("jaxb.encoding", (Object)Marshaller.this.jaxbRepresentation.getCharacterSet().getName());
                }
                m.setProperty("jaxb.fragment", (Object)Marshaller.this.getJaxbRepresentation().isFragment());
            }
            catch (Exception e) {
                Context.getCurrentLogger().log(Level.WARNING, "Problem creating Marshaller", e);
                return null;
            }
            return m;
        }
    };
    private final String contextPath;
    private final ClassLoader classLoader;

    public Marshaller(JaxbRepresentation<T> jaxbRepresentation) {
        this(jaxbRepresentation, null, null);
    }

    public Marshaller(JaxbRepresentation<T> jaxbRepresentation, String contextPath, ClassLoader classLoader) {
        this.jaxbRepresentation = jaxbRepresentation;
        this.contextPath = contextPath;
        this.classLoader = classLoader;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public JaxbRepresentation<T> getJaxbRepresentation() {
        return this.jaxbRepresentation;
    }

    private javax.xml.bind.Marshaller getMarshaller() throws JAXBException {
        javax.xml.bind.Marshaller m = this.marshaller.get();
        if (m == null) {
            Context.getCurrentLogger().warning("Unable to locate marshaller.");
            throw new JAXBException("Unable to locate marshaller.");
        }
        return m;
    }

    public void marshal(Object jaxbElement, OutputStream stream) throws JAXBException {
        this.getMarshaller().marshal(jaxbElement, stream);
    }

    public void marshal(Object jaxbElement, StringRepresentation rep) throws JAXBException {
        StringWriter writer = new StringWriter();
        this.marshal(jaxbElement, writer);
        rep.setText(writer.toString());
    }

    public void marshal(Object jaxbElement, Writer writer) throws JAXBException {
        this.getMarshaller().marshal(jaxbElement, writer);
    }

    public void setEventHandler(ValidationEventHandler handler) throws JAXBException {
        this.getMarshaller().setEventHandler(handler);
    }
}

