/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import org.restlet.data.CacheDirective;
import org.restlet.data.CharacterSet;
import org.restlet.data.Cookie;
import org.restlet.data.CookieSetting;
import org.restlet.data.Encoding;
import org.restlet.data.Form;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Parameter;
import org.restlet.data.Tag;
import org.restlet.engine.util.FormUtils;
import org.restlet.ext.jaxrs.internal.util.Util;
import org.restlet.representation.Variant;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Converter {
    private static final String CHARSET_PARAM = "charset";

    public static String getCharset(javax.ws.rs.core.MediaType mediaType) {
        Map parameters = mediaType.getParameters();
        if (parameters == null) {
            return null;
        }
        return (String)parameters.get(CHARSET_PARAM);
    }

    public static javax.ws.rs.core.MediaType getMediaTypeWithoutParams(javax.ws.rs.core.MediaType mediaType) {
        if (mediaType == null) {
            return null;
        }
        Map parameters = mediaType.getParameters();
        if (parameters == null || parameters.isEmpty()) {
            return mediaType;
        }
        return new javax.ws.rs.core.MediaType(mediaType.getType(), mediaType.getSubtype());
    }

    public static MediaType getMediaTypeWithoutParams(MediaType mediaType) {
        if (mediaType == null) {
            return null;
        }
        Series parameters = mediaType.getParameters();
        if (parameters == null || parameters.isEmpty()) {
            return mediaType;
        }
        return new MediaType(mediaType.getName());
    }

    public static CharacterSet getRestletCharacterSet(javax.ws.rs.core.MediaType mediaType) {
        String charset = Converter.getCharset(mediaType);
        if (charset == null) {
            return null;
        }
        return CharacterSet.valueOf((String)charset);
    }

    public static Form toForm(MultivaluedMap<String, String> mmap) {
        if (mmap == null) {
            return null;
        }
        Form form = new Form();
        for (Map.Entry entry : mmap.entrySet()) {
            String name = (String)entry.getKey();
            for (String value : (List)entry.getValue()) {
                form.add(name, value);
            }
        }
        return form;
    }

    public static Form toFormEncoded(String queryString) {
        Form form = new Form();
        FormUtils.parse((Form)form, (String)queryString, null, (boolean)false, (char)'&');
        return form;
    }

    public static javax.ws.rs.core.Cookie toJaxRsCookie(Cookie restletCookie) {
        if (restletCookie == null) {
            return null;
        }
        return new javax.ws.rs.core.Cookie(restletCookie.getName(), restletCookie.getValue(), restletCookie.getPath(), restletCookie.getDomain(), restletCookie.getVersion());
    }

    public static EntityTag toJaxRsEntityTag(Tag restletEntityTag) {
        if (restletEntityTag == null) {
            return null;
        }
        return new EntityTag(restletEntityTag.getName(), restletEntityTag.isWeak());
    }

    public static javax.ws.rs.core.MediaType toJaxRsMediaType(MediaType restletMediaType) {
        return Converter.toJaxRsMediaType(restletMediaType, null);
    }

    public static javax.ws.rs.core.MediaType toJaxRsMediaType(MediaType restletMediaType, CharacterSet restletCharacterSet) {
        if (restletMediaType == null) {
            return null;
        }
        Map<String, String> parameters = Converter.toMap((Series<Parameter>)restletMediaType.getParameters());
        if (restletCharacterSet != null) {
            parameters.put(CHARSET_PARAM, restletCharacterSet.getName());
        }
        return new javax.ws.rs.core.MediaType(restletMediaType.getMainType(), restletMediaType.getSubType(), parameters);
    }

    public static NewCookie toJaxRsNewCookie(CookieSetting cookieSetting) throws IllegalArgumentException {
        if (cookieSetting == null) {
            return null;
        }
        return new NewCookie(cookieSetting.getName(), cookieSetting.getValue(), cookieSetting.getPath(), cookieSetting.getDomain(), cookieSetting.getVersion(), cookieSetting.getComment(), cookieSetting.getMaxAge(), cookieSetting.isSecure());
    }

    public static javax.ws.rs.core.Variant toJaxRsVariant(Variant restletVariant) throws IllegalArgumentException {
        javax.ws.rs.core.MediaType mediaType = Converter.toJaxRsMediaType(restletVariant.getMediaType(), restletVariant.getCharacterSet());
        Locale language = Converter.toLocale(Util.getOnlyMetadataName(restletVariant.getLanguages()));
        String encoding = Util.getOnlyMetadataName(restletVariant.getEncodings());
        return new javax.ws.rs.core.Variant(mediaType, language, encoding);
    }

    public static Language toLanguage(Locale locale) {
        return new Language(locale.toString());
    }

    public static Language toLanguage(String locale) {
        return new Language(locale);
    }

    public static String toLanguageString(Locale locale) {
        return locale.toString();
    }

    public static Locale toLocale(Language language) {
        return Converter.toLocale(language.getName());
    }

    public static Locale toLocale(String language) {
        if (language == null || language.length() == 0) {
            return null;
        }
        StringTokenizer stt = new StringTokenizer(language, "_", true);
        String lang = stt.nextToken();
        if (stt.hasMoreTokens()) {
            stt.nextToken();
        }
        if (!stt.hasMoreTokens()) {
            return new Locale(lang);
        }
        String country = stt.nextToken();
        if (country.equals("_")) {
            country = "";
        } else if (stt.hasMoreTokens()) {
            stt.nextToken();
        }
        if (!stt.hasMoreTokens()) {
            return new Locale(lang, country);
        }
        String variant = stt.nextToken();
        return new Locale(lang, country, variant);
    }

    public static Map<String, String> toMap(Series<Parameter> parameters) {
        if (parameters == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Parameter parameter : parameters) {
            map.put(parameter.getName(), parameter.getValue());
        }
        return map;
    }

    public static Cookie toRestletCookie(javax.ws.rs.core.Cookie jaxRsCookie) {
        if (jaxRsCookie == null) {
            return null;
        }
        return new Cookie(jaxRsCookie.getVersion(), jaxRsCookie.getName(), jaxRsCookie.getValue(), jaxRsCookie.getPath(), jaxRsCookie.getDomain());
    }

    public static CookieSetting toRestletCookieSetting(NewCookie newCookie) throws IllegalArgumentException {
        if (newCookie == null) {
            return null;
        }
        return new CookieSetting(newCookie.getVersion(), newCookie.getName(), newCookie.getValue(), newCookie.getPath(), newCookie.getDomain(), newCookie.getComment(), newCookie.getMaxAge(), newCookie.isSecure());
    }

    public static MediaType toRestletMediaType(javax.ws.rs.core.MediaType jaxRsMediaType) {
        if (jaxRsMediaType == null) {
            return null;
        }
        Form parameters = Converter.toRestletSeries(jaxRsMediaType.getParameters());
        String name = jaxRsMediaType.getType() + "/" + jaxRsMediaType.getSubtype();
        return new MediaType(name, (Series)parameters);
    }

    public static Form toRestletSeries(Map<String, String> parameters) {
        Form form = new Form();
        if (parameters == null) {
            return form;
        }
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            form.add(parameter.getKey(), parameter.getValue());
        }
        return form;
    }

    public static Tag toRestletTag(EntityTag jaxRsEntityTag) {
        if (jaxRsEntityTag == null) {
            return null;
        }
        return new Tag(jaxRsEntityTag.getValue(), jaxRsEntityTag.isWeak());
    }

    public static List<Variant> toRestletVariants(Collection<javax.ws.rs.core.Variant> jaxRsVariants) {
        ArrayList<Variant> restletVariants = new ArrayList<Variant>(jaxRsVariants.size());
        for (javax.ws.rs.core.Variant jaxRsVariant : jaxRsVariants) {
            Variant restletVariant = new Variant();
            restletVariant.setCharacterSet(Converter.getRestletCharacterSet(jaxRsVariant.getMediaType()));
            restletVariant.setEncodings(Util.createList(Encoding.valueOf((String)jaxRsVariant.getEncoding())));
            restletVariant.setLanguages(Util.createList(Converter.toLanguage(jaxRsVariant.getLanguage())));
            restletVariant.setMediaType(Converter.toRestletMediaType(jaxRsVariant.getMediaType()));
            restletVariants.add(restletVariant);
        }
        return restletVariants;
    }

    public static CacheControl toJaxRsCacheControl(List<CacheDirective> cacheDirectives) {
        CacheControl jaxRsCacheControl = new CacheControl();
        for (CacheDirective cacheDirective : cacheDirectives) {
            if (cacheDirective.getName() == "max-age") {
                jaxRsCacheControl.setMaxAge(Integer.valueOf(cacheDirective.getValue()).intValue());
                continue;
            }
            if (cacheDirective.getName() == "must-revalidate") {
                jaxRsCacheControl.setMustRevalidate(true);
                continue;
            }
            if (cacheDirective.getName() == "no-cache") {
                jaxRsCacheControl.setNoCache(true);
                continue;
            }
            if (cacheDirective.getName() == "no-store") {
                jaxRsCacheControl.setNoStore(true);
                continue;
            }
            if (cacheDirective.getName() == "no-transform") {
                jaxRsCacheControl.setNoTransform(true);
                continue;
            }
            if (cacheDirective.getName() == "proxy-revalidate") {
                jaxRsCacheControl.setProxyRevalidate(true);
                continue;
            }
            if (cacheDirective.getName() == "public") {
                jaxRsCacheControl.setPrivate(false);
                continue;
            }
            jaxRsCacheControl.getCacheExtension().put(cacheDirective.getName(), cacheDirective.getValue());
        }
        return jaxRsCacheControl;
    }

    public static List<CacheDirective> toRestletCacheDirective(CacheControl cacheControl) {
        ArrayList<CacheDirective> directives = new ArrayList<CacheDirective>();
        if (cacheControl.getMaxAge() >= 0) {
            directives.add(CacheDirective.maxAge((int)cacheControl.getMaxAge()));
        }
        if (cacheControl.getSMaxAge() >= 0) {
            directives.add(CacheDirective.sharedMaxAge((int)cacheControl.getSMaxAge()));
        }
        if (!cacheControl.getNoCacheFields().isEmpty()) {
            directives.add(CacheDirective.noCache((List)cacheControl.getNoCacheFields()));
        }
        if (!cacheControl.getPrivateFields().isEmpty()) {
            directives.add(CacheDirective.privateInfo((List)cacheControl.getPrivateFields()));
        }
        if (cacheControl.isMustRevalidate()) {
            directives.add(CacheDirective.mustRevalidate());
        }
        if (cacheControl.isNoCache()) {
            directives.add(CacheDirective.noCache());
        }
        if (cacheControl.isNoStore()) {
            directives.add(CacheDirective.noStore());
        }
        if (cacheControl.isNoTransform()) {
            directives.add(CacheDirective.noTransform());
        }
        if (cacheControl.isPrivate()) {
            directives.add(CacheDirective.privateInfo());
        }
        if (cacheControl.isProxyRevalidate()) {
            directives.add(CacheDirective.proxyMustRevalidate());
        }
        for (Map.Entry c : cacheControl.getCacheExtension().entrySet()) {
            directives.add(new CacheDirective((String)c.getKey(), (String)c.getValue()));
        }
        return directives;
    }

    private Converter() {
    }
}

