/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalPathException;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalPathOnClassException;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalPathOnMethodException;
import org.restlet.ext.jaxrs.internal.exceptions.MissingAnnotationException;
import org.restlet.ext.jaxrs.internal.todo.NotYetImplementedException;
import org.restlet.ext.jaxrs.internal.util.EncodeOrCheck;
import org.restlet.ext.jaxrs.internal.util.Util;
import org.restlet.routing.Template;
import org.restlet.util.Resolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUriBuilder
extends UriBuilder {
    private CharSequence fragment;
    private String host;
    private CharSequence path;
    private String port = null;
    private CharSequence query;
    private String scheme;
    private CharSequence userInfo;

    protected AbstractUriBuilder() {
    }

    private void addValidPathSegment(CharSequence newPathSegment) {
        StringBuilder path = this.getPath();
        if (this.host != null && Util.notEndsWith(path, '/') && Util.notStartsWith(newPathSegment, '/')) {
            path.append('/');
        }
        path.append(newPathSegment);
    }

    private void addValidPathSegments(List<CharSequence> newPathSegments) {
        for (CharSequence newPathSegment : newPathSegments) {
            this.addValidPathSegment(newPathSegment);
        }
    }

    public URI build(Object ... values) throws IllegalArgumentException, UriBuilderException {
        Template template = new Template(this.toStringWithCheck(false));
        return this.buildUri(template.format((Resolver)new ArrayVariableResolver(values, true)));
    }

    public URI buildFromEncoded(Object ... values) throws IllegalArgumentException, UriBuilderException {
        Template template = new Template(this.toStringWithCheck(false));
        return this.buildUri(template.format((Resolver)new ArrayVariableResolver(values, false)));
    }

    public URI buildFromEncodedMap(Map<String, ? extends Object> values) throws IllegalArgumentException, UriBuilderException {
        return this.buildFromMap(values, false);
    }

    public URI buildFromMap(Map<String, ? extends Object> values) throws IllegalArgumentException, UriBuilderException {
        return this.buildFromMap(values, true);
    }

    private URI buildFromMap(final Map<String, ? extends Object> values, final boolean encode) throws IllegalArgumentException, UriBuilderException {
        Template template = new Template(this.toStringWithCheck(false));
        return this.buildUri(template.format((Resolver)new Resolver<String>(){

            public String resolve(String variableName) {
                Object varValue = values.get(variableName);
                if (varValue == null) {
                    throw new IllegalArgumentException("The value Map must contain a value for all given Templet variables. The value for variable " + variableName + " is missing");
                }
                return EncodeOrCheck.all(varValue.toString(), encode);
            }
        }));
    }

    private URI buildUri(String refAsString) throws UriBuilderException {
        try {
            return new URI(refAsString);
        }
        catch (URISyntaxException e) {
            throw new UriBuilderException("Could not build the URI from String " + refAsString, (Throwable)e);
        }
    }

    protected void copyInto(AbstractUriBuilder uriBuilder) {
        if (this.fragment != null) {
            uriBuilder.fragment = this.fragment;
            this.fragment = ((Object)this.fragment).toString();
        }
        uriBuilder.host = this.host;
        uriBuilder.port = this.port;
        uriBuilder.scheme = this.scheme;
        if (this.userInfo != null) {
            uriBuilder.userInfo = this.userInfo;
            this.userInfo = ((Object)this.userInfo).toString();
        }
        if (this.path != null) {
            uriBuilder.path = this.path;
            this.path = ((Object)this.path).toString();
        }
        if (this.query != null) {
            uriBuilder.query = this.query;
            this.query = ((Object)this.query).toString();
        }
    }

    public UriBuilder fragment(String fragment) throws IllegalArgumentException {
        this.fragment = fragment == null ? null : EncodeOrCheck.fragment(fragment);
        return this;
    }

    protected String getExtension() {
        return null;
    }

    private StringBuilder getPath() {
        StringBuilder path;
        if (this.path instanceof StringBuilder) {
            return (StringBuilder)this.path;
        }
        if (this.path == null) {
            path = new StringBuilder();
            this.path = path;
        } else {
            path = new StringBuilder(this.path);
            this.path = path;
        }
        return path;
    }

    public UriBuilder host(String host) throws IllegalArgumentException {
        this.host = host == null ? null : EncodeOrCheck.host(host);
        return this;
    }

    public UriBuilder matrixParam(String name, Object ... values) throws IllegalArgumentException {
        if (values == null) {
            throw new IllegalArgumentException("The values must not be null");
        }
        String ncs = EncodeOrCheck.nameOrValue(name, true, "matrix parameter name");
        ArrayList<String> valuesStr = new ArrayList<String>();
        for (Object value : values) {
            String vcs = EncodeOrCheck.nameOrValue(value, true, "matrix parameter value");
            valuesStr.add(vcs);
        }
        StringBuilder path = this.getPath();
        for (String vcs : valuesStr) {
            path.append(';');
            path.append((CharSequence)ncs);
            path.append('=');
            path.append(vcs);
        }
        return this;
    }

    protected UriBuilder path(CharSequence pathToAppend) throws IllegalArgumentException {
        if (pathToAppend == null) {
            throw new IllegalArgumentException("the path to append must not be null");
        }
        CharSequence validPathSegment = EncodeOrCheck.pathSegmentsWithMatrix(pathToAppend, true);
        this.addValidPathSegment(validPathSegment);
        return this;
    }

    public UriBuilder path(Class rootResource) throws IllegalArgumentException {
        String newPathSegment;
        if (rootResource == null) {
            throw new IllegalArgumentException("The root resource class must not be null");
        }
        try {
            newPathSegment = Util.getPathTemplateWithoutRegExps(rootResource);
        }
        catch (IllegalPathOnClassException e) {
            throw e.getCause();
        }
        catch (MissingAnnotationException e) {
            throw new IllegalArgumentException("The class " + rootResource.getName() + " is not a valid root resource class. " + "A root resource class must be annotated with @Path");
        }
        this.addValidPathSegment(newPathSegment);
        return this;
    }

    public UriBuilder path(Class rootResource, String methodName) throws IllegalArgumentException {
        if (methodName == null) {
            throw new IllegalArgumentException("The method name must not be null");
        }
        String resMethodPath = null;
        for (Method method : rootResource.getMethods()) {
            String path;
            if (!method.getName().equals(methodName)) continue;
            try {
                path = Util.getPathTemplateWithoutRegExps(method);
            }
            catch (IllegalPathOnMethodException e) {
                throw e.getCause();
            }
            catch (MissingAnnotationException e) {
                throw new IllegalArgumentException(e);
            }
            if (path == null) continue;
            if (resMethodPath != null && !resMethodPath.equals(path)) {
                throw new IllegalArgumentException("The class " + rootResource + " has more than one methods with the name " + methodName + " annotated with @Path");
            }
            resMethodPath = path;
        }
        if (resMethodPath == null) {
            throw new IllegalArgumentException("The class " + rootResource + " has no method with the name " + methodName + " annotated with @Path");
        }
        this.addValidPathSegment(resMethodPath);
        return this;
    }

    public UriBuilder path(Method method) throws IllegalArgumentException {
        String validSegment;
        if (method == null) {
            return this;
        }
        try {
            validSegment = Util.getPathTemplateWithoutRegExps(method);
        }
        catch (MissingAnnotationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalPathException e) {
            throw e.getCause();
        }
        this.addValidPathSegment(validSegment);
        return this;
    }

    public UriBuilder path(String pathToAppend) throws IllegalArgumentException {
        this.path((CharSequence)pathToAppend);
        return this;
    }

    private List<CharSequence> pathSegmentsWithMatrix(String[] segments) {
        if (segments == null) {
            return new ArrayList<CharSequence>(0);
        }
        int length = segments.length;
        ArrayList<CharSequence> r = new ArrayList<CharSequence>(length);
        if (length == 0) {
            return r;
        }
        String s = segments[0];
        if (s == null || s.length() == 0) {
            return r;
        }
        r.add(EncodeOrCheck.pathSegmentWithMatrix(s, true));
        for (int i = 1; i < length; ++i) {
            r.add(EncodeOrCheck.pathSegmentWithMatrix(segments[i], true));
        }
        return r;
    }

    public UriBuilder port(int port) throws IllegalArgumentException {
        if (port == -1) {
            this.port = null;
        } else {
            if (port > 65535 || port < -1) {
                throw new IllegalArgumentException("The port must between zero and 65535 or -1 to unset the explizit port");
            }
            this.port = String.valueOf(port);
        }
        return this;
    }

    public UriBuilder port(String port) throws IllegalArgumentException {
        if (port == null) {
            this.port = null;
        } else if (port.startsWith("{") && port.endsWith("}")) {
            this.port = port;
        } else {
            this.port(Integer.parseInt(port));
        }
        return this;
    }

    public UriBuilder queryParam(String name, Object ... values) throws IllegalArgumentException {
        StringBuilder query;
        if (values == null) {
            throw new IllegalArgumentException("The values must not be null");
        }
        String ncs = EncodeOrCheck.nameOrValue(name, true, "query parameter name");
        ArrayList<String> valuesStr = new ArrayList<String>();
        for (Object value : values) {
            String vcs = EncodeOrCheck.nameOrValue(value, true, "query parameter value");
            valuesStr.add(vcs);
        }
        Iterator valueIter = valuesStr.iterator();
        if (this.query == null) {
            query = new StringBuilder();
            this.query = query;
        } else if (this.query instanceof StringBuilder) {
            query = (StringBuilder)this.query;
            query.append('&');
        } else {
            query = new StringBuilder(((Object)this.query).toString());
            query.append('&');
        }
        query.append((CharSequence)ncs);
        query.append('=');
        query.append((String)valueIter.next());
        while (valueIter.hasNext()) {
            query.append('&');
            query.append((CharSequence)ncs);
            query.append('=');
            query.append((String)valueIter.next());
        }
        return this;
    }

    public UriBuilder replaceMatrix(String matrix) throws IllegalArgumentException {
        int beginMp;
        StringBuilder path;
        int beginLastPs;
        CharSequence mpcs = null;
        if (matrix != null) {
            mpcs = EncodeOrCheck.fullMatrix(matrix);
        }
        if ((beginLastPs = (path = this.getPath()).lastIndexOf("/")) >= 0 && (beginMp = path.indexOf(";", beginLastPs)) >= 0) {
            path.delete(beginMp, path.length());
        }
        if (mpcs == null) {
            return this;
        }
        if (mpcs.length() == 0 || mpcs.charAt(0) != ';') {
            path.append(";");
        }
        path.append(mpcs);
        return this;
    }

    public UriBuilder replaceMatrixParam(String name, Object ... values) throws IllegalArgumentException {
        throw new NotYetImplementedException("Sorry, the relacement of matrix parameters is not supported yet");
    }

    protected UriBuilder replacePath(CharSequence newPath) throws IllegalArgumentException {
        if (newPath == null || newPath.length() > 0 && newPath.charAt(0) == '/') {
            this.path = newPath;
        } else {
            this.path = null;
            this.path(newPath);
        }
        return this;
    }

    public UriBuilder replacePath(String newPath) throws IllegalArgumentException {
        return this.replacePath((CharSequence)newPath);
    }

    public UriBuilder replaceQuery(String query) throws IllegalArgumentException {
        this.query = query == null || query.length() == 0 ? null : EncodeOrCheck.fullQuery(query, true);
        return this;
    }

    public UriBuilder replaceQueryParam(String name, Object ... values) throws IllegalArgumentException {
        throw new NotYetImplementedException("Sorry, the relacement of query parameters is not supported yet");
    }

    public UriBuilder scheme(String scheme) throws IllegalArgumentException {
        this.scheme = EncodeOrCheck.scheme(scheme);
        return this;
    }

    public UriBuilder schemeSpecificPart(String ssp) throws IllegalArgumentException {
        String port;
        String host;
        CharSequence userInfo;
        CharSequence query;
        CharSequence path;
        CharSequence fragment;
        String authority;
        int firstSlashPos;
        if (ssp == null) {
            throw new IllegalArgumentException("The scheme specific part must not be null");
        }
        if (ssp.startsWith("//")) {
            ssp = ssp.substring(2);
        }
        if ((firstSlashPos = ssp.indexOf(47)) >= 0) {
            String pathQuery;
            authority = ssp.substring(0, firstSlashPos);
            String pathQueryFragment = ssp.substring(firstSlashPos);
            int firstCrosshatchPos = pathQueryFragment.indexOf(35);
            if (firstCrosshatchPos >= 0) {
                pathQuery = pathQueryFragment.substring(0, firstCrosshatchPos);
                fragment = pathQueryFragment.substring(firstCrosshatchPos + 1);
            } else {
                pathQuery = pathQueryFragment;
                fragment = null;
            }
            int firstQmPos = pathQuery.indexOf(63);
            if (firstQmPos >= 0) {
                path = pathQuery.substring(0, firstQmPos);
                query = pathQuery.substring(firstQmPos + 1);
            } else {
                path = pathQuery;
                query = null;
            }
        } else {
            authority = ssp;
            path = null;
            query = null;
            fragment = null;
        }
        int atSignPos = authority.lastIndexOf(64);
        if (atSignPos >= 0) {
            userInfo = authority.substring(0, atSignPos);
            authority = authority.substring(atSignPos + 1);
        } else {
            userInfo = null;
        }
        int colonPos = authority.lastIndexOf(58);
        if (colonPos >= 0) {
            host = authority.substring(0, colonPos);
            port = authority.substring(colonPos + 1);
        } else {
            host = authority;
            port = null;
        }
        if (userInfo != null) {
            userInfo = EncodeOrCheck.userInfo(userInfo, true);
        }
        if (host != null) {
            host = EncodeOrCheck.host(host);
        }
        if (path != null) {
            path = EncodeOrCheck.pathSegmentsWithMatrix(path, true);
        }
        if (query != null) {
            query = EncodeOrCheck.fullQuery(query, true);
        }
        if (fragment != null) {
            fragment = EncodeOrCheck.fragment(fragment);
        }
        this.port(port);
        this.userInfo = userInfo;
        this.host = host;
        this.replacePath(path);
        this.query = query;
        this.fragment = fragment;
        return this;
    }

    public UriBuilder segment(String ... segments) throws IllegalArgumentException {
        if (segments == null) {
            throw new IllegalArgumentException("The segments must not be null");
        }
        List<CharSequence> newPathSegments = this.pathSegmentsWithMatrix(segments);
        this.addValidPathSegments(newPathSegments);
        return this;
    }

    public String toString() {
        return this.toString(false);
    }

    private String toString(boolean convertBraces) {
        try {
            StringBuilder stb = new StringBuilder();
            if (this.scheme != null) {
                Util.append(stb, this.scheme, convertBraces);
                stb.append("://");
            }
            if (this.userInfo != null) {
                Util.append(stb, this.userInfo, convertBraces);
                stb.append('@');
            }
            if (this.host != null) {
                Util.append(stb, this.host, convertBraces);
            }
            if (this.port != null) {
                stb.append(':');
                stb.append(this.port);
            }
            String extension = this.getExtension();
            CharSequence thisPath = this.path;
            if (thisPath != null || extension != null) {
                if (stb.length() > 0 && (Util.notStartsWith(thisPath, '/') || thisPath == null && extension != null)) {
                    stb.append('/');
                }
                if (extension == null) {
                    Util.append(stb, thisPath, convertBraces);
                } else {
                    int begLastMatrix = Util.indexBeginMatrixOfLastSegment(thisPath);
                    if (begLastMatrix >= 0) {
                        Util.append(stb, thisPath, convertBraces, 0, begLastMatrix);
                        Util.append(stb, extension, convertBraces);
                        Util.append(stb, thisPath, convertBraces, begLastMatrix);
                    } else {
                        Util.append(stb, thisPath, convertBraces);
                        Util.append(stb, extension, convertBraces);
                    }
                }
            }
            if (this.query != null) {
                stb.append('?');
                Util.append(stb, this.query, convertBraces);
            }
            if (this.fragment != null) {
                stb.append('#');
                Util.append(stb, this.fragment, convertBraces);
            }
            return stb.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write the UriBuilder to a String; but this Exception could not occur normally", e);
        }
    }

    private String toStringWithCheck(boolean convertBraces) {
        if (this.host == null) {
            if (this.port != null) {
                throw new UriBuilderException("You must set a host, if you set a port");
            }
            if (this.userInfo != null && this.userInfo.length() >= 0) {
                throw new UriBuilderException("You must set a host, if you set a userInfo");
            }
        }
        return this.toString(convertBraces);
    }

    public UriBuilder uri(URI uri) throws IllegalArgumentException {
        if (uri == null) {
            throw new IllegalArgumentException("The URI must not be null");
        }
        if (uri.getScheme() != null) {
            this.scheme = uri.getScheme();
        }
        if (uri.getHost() != null) {
            this.host = uri.getHost();
        }
        this.port(uri.getPort());
        if (uri.getRawUserInfo() != null) {
            this.userInfo = uri.getRawUserInfo();
        }
        if (uri.getRawPath() != null) {
            this.replacePath(uri.getRawPath());
        }
        if (uri.getRawQuery() != null) {
            this.query = uri.getRawQuery();
        }
        if (uri.getRawFragment() != null) {
            this.fragment = uri.getRawFragment();
        }
        return this;
    }

    public UriBuilder userInfo(String userInfo) throws IllegalArgumentException {
        this.userInfo = userInfo == null ? null : EncodeOrCheck.userInfo(userInfo, true);
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArrayVariableResolver
    extends Resolver<String> {
        private final boolean encoding;
        private int i = 0;
        private final Map<String, String> retrievedValues = new HashMap<String, String>();
        private final Object[] values;

        ArrayVariableResolver(Object[] values, boolean encoding) {
            this.values = values;
            this.encoding = encoding;
        }

        public String resolve(String variableName) {
            String varValue = this.retrievedValues.get(variableName);
            if (varValue == null) {
                if (this.i >= this.values.length) {
                    throw new IllegalArgumentException("The value given array contains not enough elements (contains " + this.values.length + ", but need at least " + (this.i + 1) + ")");
                }
                Object value = this.values[this.i];
                if (value == null) {
                    throw new IllegalArgumentException("The given array contains null value at position (" + this.i + ")");
                }
                varValue = value.toString();
                varValue = EncodeOrCheck.all(varValue, this.encoding);
                ++this.i;
                this.retrievedValues.put(variableName, varValue);
            }
            return varValue;
        }
    }
}

