/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.provider;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.restlet.ext.jaxrs.internal.provider.AbstractProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractJaxbProvider<T>
extends AbstractProvider<T> {
    private static final ConcurrentMap<Class<?>, JAXBContext> contexts = new ConcurrentHashMap();
    public ContextResolver<JAXBContext> contextResolver;

    AbstractJaxbProvider() {
    }

    public static synchronized JAXBContext getJaxbContext(Class<?> type, ContextResolver<JAXBContext> contextResolver) throws JAXBException {
        JAXBContext result = (JAXBContext)contexts.get(type);
        if (result == null) {
            if (contextResolver != null) {
                result = (JAXBContext)contextResolver.getContext(type);
            }
            if (result == null) {
                try {
                    result = JAXBContext.newInstance((Class[])new Class[]{type});
                }
                catch (NoClassDefFoundError e) {
                    throw new WebApplicationException(Response.serverError().entity((Object)e.getMessage()).build());
                }
            }
            contexts.put(type, result);
        }
        return result;
    }

    public JAXBContext getJaxbContext(Class<?> type) throws JAXBException {
        return AbstractJaxbProvider.getJaxbContext(type, this.contextResolver);
    }

    abstract Logger getLogger();

    @Override
    public final long getSize(T object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    void marshal(Object object, OutputStream entityStream) throws IOException {
        Class<?> type = object.getClass();
        try {
            JAXBContext jaxbContext = this.getJaxbContext(object.getClass());
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.marshal(object, entityStream);
        }
        catch (JAXBException e) {
            throw AbstractJaxbProvider.logAndIOExc(this.getLogger(), "Could not marshal the " + type.getName(), e);
        }
    }

    @Context
    void setContextResolver(Providers providers) {
        this.contextResolver = providers.getContextResolver(JAXBContext.class, MediaType.APPLICATION_XML_TYPE);
    }
}

