/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.restlet.Context;
import org.restlet.ext.jaxrs.internal.exceptions.ImplementationException;
import org.restlet.ext.jaxrs.internal.provider.AbstractJaxbProvider;
import org.restlet.ext.jaxrs.internal.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"application/xml", "text/xml", "application/*+xml"})
@Consumes(value={"application/xml", "text/xml", "application/*+xml"})
public class JaxbElementProvider
extends AbstractJaxbProvider<JAXBElement<?>> {
    private final Logger logger = Context.getCurrentLogger();

    @Override
    Logger getLogger() {
        return this.logger;
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (!JAXBElement.class.isAssignableFrom(type)) {
            return false;
        }
        return Util.getGenericClass(genericType) != null;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (!type.isAssignableFrom(JAXBElement.class)) {
            return false;
        }
        return Util.getGenericClass(genericType) != null;
    }

    @Override
    public JAXBElement<?> readFrom(Class<JAXBElement<?>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpResponseHeaders, InputStream entityStream) throws IOException {
        Class<?> clazz = Util.getGenericClass(genericType);
        if (clazz == null) {
            throw new ImplementationException("The JaxbElement provider has gotten a type it could not unmarshal. Perhaps is the JaxbElementProvider not consistent to itself.");
        }
        try {
            JAXBContext jaxbContext = this.getJaxbContext((Class)clazz);
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            JAXBElement je = unmarshaller.unmarshal((Source)new StreamSource(entityStream), type);
            return je;
        }
        catch (JAXBException e) {
            String message = "Could not unmarshal to " + type.getName();
            throw JaxbElementProvider.logAndIOExc(this.getLogger(), message, e);
        }
    }

    @Override
    public void writeTo(JAXBElement<?> jaxbElement, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpResponseHeaders, OutputStream entityStream) throws IOException {
        this.marshal(jaxbElement.getValue(), entityStream);
    }
}

