/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.CharacterSet;
import org.restlet.engine.io.BioUtils;
import org.restlet.ext.jaxrs.internal.provider.AbstractProvider;
import org.restlet.ext.jaxrs.internal.util.Util;
import org.restlet.representation.Representation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
public class ReaderProvider
extends AbstractProvider<Reader> {
    static Reader getReader(InputStream entityStream) {
        CharacterSet cs;
        Representation entity = Request.getCurrent().getEntity();
        if (entity != null) {
            cs = entity.getCharacterSet();
            if (cs == null) {
                cs = Util.JAX_RS_DEFAULT_CHARACTER_SET;
            }
        } else {
            cs = Util.JAX_RS_DEFAULT_CHARACTER_SET;
        }
        try {
            return BioUtils.getReader((InputStream)entityStream, (CharacterSet)cs);
        }
        catch (UnsupportedEncodingException e) {
            try {
                return BioUtils.getReader((InputStream)entityStream, null);
            }
            catch (UnsupportedEncodingException e2) {
                throw new WebApplicationException(500);
            }
        }
    }

    @Override
    public long getSize(Reader t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public Reader readFrom(Class<Reader> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        return ReaderProvider.getReader(entityStream);
    }

    @Override
    protected Class<?> supportedClass() {
        return Reader.class;
    }

    @Override
    public void writeTo(Reader reader, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        CharacterSet cs = Response.getCurrent().getEntity().getCharacterSet();
        BioUtils.copy((InputStream)BioUtils.getStream((Reader)reader, (CharacterSet)cs), (OutputStream)entityStream);
    }
}

