/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.wrappers.provider;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Providers;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.ext.jaxrs.InstantiateException;
import org.restlet.ext.jaxrs.ObjectFactory;
import org.restlet.ext.jaxrs.internal.core.ThreadLocalizedContext;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalConstrParamTypeException;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalParamTypeException;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalTypeException;
import org.restlet.ext.jaxrs.internal.exceptions.ImplementationException;
import org.restlet.ext.jaxrs.internal.exceptions.InjectException;
import org.restlet.ext.jaxrs.internal.exceptions.MissingAnnotationException;
import org.restlet.ext.jaxrs.internal.exceptions.MissingConstructorException;
import org.restlet.ext.jaxrs.internal.exceptions.ProviderNotInitializableException;
import org.restlet.ext.jaxrs.internal.util.Converter;
import org.restlet.ext.jaxrs.internal.wrappers.provider.ExtensionBackwardMapping;
import org.restlet.ext.jaxrs.internal.wrappers.provider.MessageBodyReader;
import org.restlet.ext.jaxrs.internal.wrappers.provider.MessageBodyReaderSet;
import org.restlet.ext.jaxrs.internal.wrappers.provider.MessageBodyWriter;
import org.restlet.ext.jaxrs.internal.wrappers.provider.MessageBodyWriterSubSet;
import org.restlet.ext.jaxrs.internal.wrappers.provider.PerRequestProviderWrapper;
import org.restlet.ext.jaxrs.internal.wrappers.provider.ProviderWrapper;
import org.restlet.ext.jaxrs.internal.wrappers.provider.SingletonProvider;

public class JaxRsProviders
implements Providers,
MessageBodyReaderSet {
    private static final Logger localLogger = Context.getCurrentLogger();
    private final Set<ProviderWrapper> all = new CopyOnWriteArraySet<ProviderWrapper>();
    private final Collection<ProviderWrapper> contextResolvers;
    private final Map<Class<? extends Throwable>, ProviderWrapper> excMappers;
    private final ExtensionBackwardMapping extensionBackwardMapping;
    private final Logger logger;
    private final List<ProviderWrapper> messageBodyReaderWrappers = new CopyOnWriteArrayList<ProviderWrapper>();
    private final List<ProviderWrapper> messageBodyWriterWrappers = new CopyOnWriteArrayList<ProviderWrapper>();
    private volatile ObjectFactory objectFactory;
    private final ThreadLocalizedContext tlContext;

    private static Class<?> getCtxResGenClass(Class<?> crClaz) {
        Type[] crIfTypes;
        for (Type crIfType : crIfTypes = crClaz.getGenericInterfaces()) {
            Type t;
            if (!(crIfType instanceof ParameterizedType) || !((t = ((ParameterizedType)crIfType).getActualTypeArguments()[0]) instanceof Class)) continue;
            return (Class)t;
        }
        return null;
    }

    public JaxRsProviders(ObjectFactory objectFactory, ThreadLocalizedContext tlContext, ExtensionBackwardMapping extensionBackwardMapping, Logger logger) {
        this.contextResolvers = new CopyOnWriteArraySet<ProviderWrapper>();
        this.excMappers = new ConcurrentHashMap<Class<? extends Throwable>, ProviderWrapper>();
        this.objectFactory = objectFactory;
        this.tlContext = tlContext;
        this.extensionBackwardMapping = extensionBackwardMapping;
        this.logger = logger;
    }

    private void add(ProviderWrapper provider, boolean defaultProvider) {
        if (provider.isWriter()) {
            if (defaultProvider) {
                this.messageBodyWriterWrappers.add(provider);
            } else {
                this.messageBodyWriterWrappers.add(0, provider);
            }
        }
        if (provider.isReader()) {
            if (defaultProvider) {
                this.messageBodyReaderWrappers.add(provider);
            } else {
                this.messageBodyReaderWrappers.add(0, provider);
            }
        }
        if (provider.isContextResolver()) {
            this.contextResolvers.add(provider);
        }
        if (provider.isExceptionMapper()) {
            this.addExcMapper(provider);
        }
        this.all.add(provider);
    }

    public boolean addClass(Class<?> jaxRsProviderClass) {
        PerRequestProviderWrapper provider;
        try {
            provider = new PerRequestProviderWrapper(jaxRsProviderClass, this.objectFactory, this.tlContext, this, this.extensionBackwardMapping, this.logger);
        }
        catch (IllegalParamTypeException e) {
            String msg = "Ignore provider " + jaxRsProviderClass.getName() + ": Could not instantiate class " + jaxRsProviderClass.getName();
            this.logger.log(Level.WARNING, msg, e);
            return false;
        }
        catch (InstantiateException e) {
            String msg = "Ignore provider " + jaxRsProviderClass.getName() + ": Could not instantiate class " + jaxRsProviderClass.getName();
            this.logger.log(Level.WARNING, msg, e);
            return false;
        }
        catch (MissingAnnotationException e) {
            String msg = "Ignore provider " + jaxRsProviderClass.getName() + ": Could not instantiate class " + jaxRsProviderClass.getName() + ", because " + e.getMessage();
            this.logger.log(Level.WARNING, msg);
            return false;
        }
        catch (InvocationTargetException ite) {
            String msg = "Ignore provider " + jaxRsProviderClass.getName() + ", because an exception occured while instantiating";
            this.logger.log(Level.WARNING, msg, ite);
            return false;
        }
        catch (IllegalArgumentException iae) {
            String msg = "Ignore provider " + jaxRsProviderClass.getName() + ", because it could not be instantiated";
            this.logger.log(Level.WARNING, msg, iae);
            return false;
        }
        catch (MissingConstructorException mce) {
            String msg = "Ignore provider " + jaxRsProviderClass.getName() + ", because no valid constructor was found: " + mce.getMessage();
            this.logger.warning(msg);
            return false;
        }
        catch (IllegalConstrParamTypeException e) {
            String msg = "Ignore provider " + jaxRsProviderClass.getName() + ", because no valid constructor was found: " + e.getMessage();
            this.logger.warning(msg);
            return false;
        }
        this.add(provider, false);
        return true;
    }

    private void addExcMapper(ProviderWrapper excMapperWrapper) {
        Class<?> excClass = excMapperWrapper.getExcMapperType();
        this.excMappers.put(excClass, excMapperWrapper);
    }

    public boolean addSingleton(Object jaxRsProviderObject, boolean defaultProvider) throws WebApplicationException {
        SingletonProvider provider;
        try {
            provider = new SingletonProvider(jaxRsProviderObject, this.logger);
        }
        catch (IllegalArgumentException iae) {
            String msg = "Ignore provider " + jaxRsProviderObject.getClass().getName() + ", because it could not be instantiated";
            this.logger.log(Level.WARNING, msg, iae);
            return false;
        }
        this.add(provider, defaultProvider);
        return true;
    }

    public Response convert(Throwable cause) {
        ExceptionMapper<?> mapper = this.getExceptionMapper(cause.getClass());
        if (mapper == null) {
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            String entity = "No ExceptionMapper was found, but must be found";
            return Response.serverError().entity((Object)entity).type(javax.ws.rs.core.MediaType.TEXT_PLAIN_TYPE).build();
        }
        Response response = mapper.toResponse(cause);
        if (response == null) {
            String message = "The ExceptionMapper returned null";
            localLogger.log(Level.WARNING, message);
            return Response.serverError().entity((Object)message).build();
        }
        return response;
    }

    @Override
    public MessageBodyReader getBestReader(Class<?> paramType, Type genericType, Annotation[] annotations, MediaType mediaType) {
        for (ProviderWrapper mbrw : this.messageBodyReaderWrappers) {
            MessageBodyReader mbr;
            if (!mbrw.supportsRead(mediaType)) continue;
            try {
                mbr = mbrw.getInitializedReader();
            }
            catch (ProviderNotInitializableException e) {
                continue;
            }
            catch (WebApplicationException e) {
                continue;
            }
            if (!mbr.isReadable(paramType, genericType, annotations, Converter.toJaxRsMediaType(mediaType))) continue;
            return mbr;
        }
        return null;
    }

    public <T> ContextResolver<T> getContextResolver(Class<T> contextType, javax.ws.rs.core.MediaType mediaType) {
        for (ProviderWrapper crWrapper : this.contextResolvers) {
            Class<?> crClaz;
            Class<?> genClass;
            ContextResolver<?> cr;
            try {
                cr = crWrapper.getInitializedCtxResolver().getContextResolver();
            }
            catch (ProviderNotInitializableException e1) {
                continue;
            }
            catch (WebApplicationException e1) {
                continue;
            }
            if (cr == null || (genClass = JaxRsProviders.getCtxResGenClass(crClaz = cr.getClass())) == null || !genClass.equals(contextType) || !crWrapper.supportsWrite(mediaType)) continue;
            try {
                Method getContext = crClaz.getMethod("getContext", Class.class);
                if (!getContext.getReturnType().equals(contextType)) continue;
                return cr;
            }
            catch (SecurityException e) {
                throw new RuntimeException("sorry, the method getContext(Class) of ContextResolver " + crClaz + " is not accessible");
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("The ContextResolver " + crClaz + " is not valid, because it has no method getContext(Class)");
            }
        }
        return null;
    }

    public <T extends Throwable> ExceptionMapper<T> getExceptionMapper(Class<T> causeClass) {
        if (causeClass == null) {
            throw new ImplementationException("The call of an exception mapper with null is not allowed");
        }
        while (true) {
            Class<T> superclass;
            ProviderWrapper mapperWrapper;
            if ((mapperWrapper = this.excMappers.get(causeClass)) != null) {
                try {
                    return mapperWrapper.getInitializedExcMapper();
                }
                catch (ProviderNotInitializableException e) {
                    localLogger.info("The exception mapper for " + causeClass + " could not be initialized, so it can#t be used. Will look for the next exception mapper in hierarchy.");
                }
                catch (WebApplicationException e) {
                    localLogger.log(Level.INFO, "The exception mapper for " + causeClass + " could not be initialized, so it can#t be used. Will look for the next exception mapper in hierarchy.", e);
                }
            }
            if ((superclass = causeClass.getSuperclass()) == null || superclass.equals(Object.class)) {
                return null;
            }
            causeClass = superclass;
        }
    }

    public <T> javax.ws.rs.ext.MessageBodyReader<T> getMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, javax.ws.rs.core.MediaType mediaType) {
        MediaType restletMediaType = Converter.toRestletMediaType(mediaType);
        MessageBodyReader mbr = this.getBestReader(type, genericType, annotations, restletMediaType);
        return mbr.getJaxRsReader();
    }

    public <T> javax.ws.rs.ext.MessageBodyWriter<T> getMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, javax.ws.rs.core.MediaType mediaType) {
        MediaType restletMediaType = Converter.toRestletMediaType(mediaType);
        for (ProviderWrapper mbww : this.messageBodyWriterWrappers) {
            MessageBodyWriter mbw;
            if (!mbww.supportsWrite(restletMediaType)) continue;
            try {
                mbw = mbww.getInitializedWriter();
            }
            catch (ProviderNotInitializableException e) {
                continue;
            }
            catch (WebApplicationException e) {
                continue;
            }
            if (!mbw.isWriteable(type, genericType, annotations, mediaType)) continue;
            return mbw.getJaxRsWriter();
        }
        return null;
    }

    public void initAll() {
        for (ProviderWrapper provider : new ArrayList<ProviderWrapper>(this.all)) {
            try {
                provider.initAtAppStartUp(this.tlContext, this, this.extensionBackwardMapping);
            }
            catch (InjectException e) {
                localLogger.log(Level.WARNING, "The provider " + provider.getClassName() + " could not be used", e);
                this.remove(provider);
            }
            catch (IllegalTypeException e) {
                localLogger.log(Level.WARNING, "The provider " + provider.getClassName() + " could not be used", e);
                this.remove(provider);
            }
            catch (InvocationTargetException e) {
                localLogger.log(Level.WARNING, "The provider " + provider.getClassName() + " could not be used", e.getCause());
                this.remove(provider);
            }
            catch (SecurityException e) {
                localLogger.log(Level.WARNING, "The provider " + provider.getClassName() + " could not be used", e.getCause());
                this.remove(provider);
            }
        }
    }

    private void remove(ProviderWrapper provider) {
        this.all.remove(provider);
        this.contextResolvers.remove(provider);
        this.messageBodyReaderWrappers.remove(provider);
        this.messageBodyWriterWrappers.remove(provider);
        Iterator<Map.Entry<Class<? extends Throwable>, ProviderWrapper>> excMapperEntryIter = this.excMappers.entrySet().iterator();
        while (excMapperEntryIter.hasNext()) {
            Map.Entry<Class<? extends Throwable>, ProviderWrapper> excMapperEntry = excMapperEntryIter.next();
            ProviderWrapper providerWrapper = excMapperEntry.getValue();
            if (!((Object)providerWrapper).equals(provider)) continue;
            excMapperEntryIter.remove();
        }
    }

    public MessageBodyWriterSubSet writerSubSet(Class<?> entityClass, Type genericType) {
        ArrayList<MessageBodyWriter> mbws = new ArrayList<MessageBodyWriter>();
        for (ProviderWrapper mbww : this.messageBodyWriterWrappers) {
            MessageBodyWriter mbw;
            try {
                mbw = mbww.getInitializedWriter();
            }
            catch (ProviderNotInitializableException e) {
                continue;
            }
            if (!mbw.supportsWrite(entityClass, genericType)) continue;
            mbws.add(mbw);
        }
        return new MessageBodyWriterSubSet(mbws, entityClass, genericType);
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }
}

