/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.wrappers.params;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import org.restlet.Request;
import org.restlet.ext.jaxrs.internal.exceptions.ConvertRepresentationException;
import org.restlet.ext.jaxrs.internal.wrappers.params.ParameterList;
import org.restlet.representation.Representation;

public abstract class ReprEntityGetter
implements ParameterList.ParamGetter {
    final Constructor<? extends Representation> constr;

    public static ParameterList.ParamGetter create(Class<?> representationType, Type convToGen, Logger logger) {
        if (representationType.equals(Representation.class)) {
            return new DirectReprEntityGetter();
        }
        try {
            return new ReprOnlyEntityGetter(representationType.getConstructor(Representation.class));
        }
        catch (SecurityException e) {
            logger.warning("The constructor " + representationType + "(Representation) is not accessable.");
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (!(convToGen instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType pType = (ParameterizedType)convToGen;
        Type[] typeArgs = pType.getActualTypeArguments();
        if (typeArgs.length != 1) {
            return null;
        }
        Type typeArg = typeArgs[0];
        if (!(typeArg instanceof Class)) {
            return null;
        }
        Class genClass = (Class)typeArg;
        try {
            return new ReprClassEntityGetter(representationType.getConstructor(Representation.class, Class.class), genClass);
        }
        catch (SecurityException e) {
            logger.warning("The constructor " + representationType + "(Representation) is not accessable.");
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        try {
            return new ClassReprEntityGetter(genClass, representationType.getConstructor(Class.class, Representation.class));
        }
        catch (SecurityException e) {
            logger.warning("The constructor " + representationType + "(Representation) is not accessable.");
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    ReprEntityGetter(Constructor<?> constr) {
        this.constr = constr;
    }

    abstract Representation createInstance(Representation var1) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException;

    private Class<? extends Representation> getReprClass() {
        return this.constr.getDeclaringClass();
    }

    @Override
    public Object getValue() throws InvocationTargetException, ConvertRepresentationException, WebApplicationException {
        try {
            Request request = Request.getCurrent();
            if (!request.isEntityAvailable() || request.getEntity().getSize() == 0L) {
                return null;
            }
            Representation entity = request.getEntity();
            if (entity == null) {
                return null;
            }
            return this.createInstance(entity);
        }
        catch (IllegalArgumentException e) {
            throw ConvertRepresentationException.object(this.getReprClass(), "the message body", e);
        }
        catch (InstantiationException e) {
            throw ConvertRepresentationException.object(this.getReprClass(), "the message body", e);
        }
        catch (IllegalAccessException e) {
            throw ConvertRepresentationException.object(this.getReprClass(), "the message body", e);
        }
    }

    static class ReprOnlyEntityGetter
    extends ReprEntityGetter {
        ReprOnlyEntityGetter(Constructor<?> constructor) {
            super(constructor);
        }

        @Override
        Representation createInstance(Representation entity) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
            return (Representation)this.constr.newInstance(entity);
        }
    }

    static class ReprClassEntityGetter
    extends ReprEntityGetter {
        private final Class<?> clazz;

        ReprClassEntityGetter(Constructor<?> constructor, Class<?> genClass) {
            super(constructor);
            this.clazz = genClass;
        }

        @Override
        Representation createInstance(Representation entity) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
            return (Representation)this.constr.newInstance(entity, this.clazz);
        }
    }

    static class DirectReprEntityGetter
    implements ParameterList.ParamGetter {
        DirectReprEntityGetter() {
        }

        @Override
        public Object getValue() throws InvocationTargetException, ConvertRepresentationException, WebApplicationException {
            return Request.getCurrent().getEntity();
        }
    }

    static class ClassReprEntityGetter
    extends ReprEntityGetter {
        private final Class<?> clazz;

        ClassReprEntityGetter(Class<?> genClass, Constructor<?> constructor) {
            super(constructor);
            this.clazz = genClass;
        }

        @Override
        Representation createInstance(Representation entity) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
            return (Representation)this.constr.newInstance(this.clazz, entity);
        }
    }
}

