/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Status;
import org.restlet.engine.ClientHelper;
import org.restlet.ext.jdbc.JdbcResult;
import org.restlet.ext.jdbc.RowSetRepresentation;
import org.restlet.ext.jdbc.internal.ConnectionSource;
import org.restlet.representation.Representation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcClientHelper
extends ClientHelper {
    private volatile List<ConnectionSource> connectionSources;

    public static Request create(String jdbcURI, Representation request) {
        Request result = new Request();
        result.getClientInfo().setAgent("Restlet-Framework/2.1m6");
        result.setMethod(Method.POST);
        result.setResourceRef(jdbcURI);
        result.setEntity(request);
        return result;
    }

    public static ObjectPool createConnectionPool(String uri, Properties properties) {
        GenericObjectPool result = new GenericObjectPool(null);
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(uri, properties);
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)result, null, null, false, false);
        poolableConnectionFactory.getPool();
        return result;
    }

    public static String sqlEncode(String query) {
        StringBuilder result = new StringBuilder(query.length() + 10);
        for (int i = 0; i < query.length(); ++i) {
            char currentChar = query.charAt(i);
            if (currentChar == '\'') {
                result.append("''");
                continue;
            }
            result.append(currentChar);
        }
        return result.toString();
    }

    public JdbcClientHelper(Client client) {
        super(client);
        this.getProtocols().add(Protocol.JDBC);
        this.connectionSources = new ArrayList<ConnectionSource>();
    }

    protected Connection getConnection(String uri, Properties properties, boolean usePooling) throws SQLException {
        Connection result = null;
        if (usePooling) {
            for (ConnectionSource c : this.connectionSources) {
                if (result != null || !c.getUri().equalsIgnoreCase(uri) || properties.size() != c.getProperties().size()) continue;
                boolean equal = true;
                for (Object key : c.getProperties().keySet()) {
                    if (equal && properties.containsKey(key)) {
                        equal = equal && properties.get(key).equals(c.getProperties().get(key));
                        continue;
                    }
                    equal = false;
                }
                if (!equal) continue;
                result = c.getConnection();
            }
            if (result == null) {
                ConnectionSource cs = new ConnectionSource(uri, properties);
                this.connectionSources.add(cs);
                result = cs.getConnection();
            }
        } else {
            result = DriverManager.getConnection(uri, properties);
        }
        return result;
    }

    public void handle(Request request, Response response) {
        Connection connection = null;
        if (request.getMethod().equals((Object)Method.POST)) {
            try {
                String connectionURI = request.getResourceRef().toString();
                DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document requestDoc = docBuilder.parse(new InputSource(request.getEntity().getReader()));
                Element rootElt = (Element)requestDoc.getElementsByTagName("request").item(0);
                Element headerElt = (Element)rootElt.getElementsByTagName("header").item(0);
                Element connectionElt = (Element)headerElt.getElementsByTagName("connection").item(0);
                Node usePoolingNode = connectionElt.getElementsByTagName("usePooling").item(0);
                boolean usePooling = usePoolingNode.getTextContent().equals("true");
                Node startNode = headerElt.getElementsByTagName("start").item(0);
                int start = startNode != null && startNode.getTextContent().trim().length() > 0 ? Integer.parseInt(startNode.getTextContent()) : 0;
                Node limitNode = headerElt.getElementsByTagName("limit").item(0);
                int limit = limitNode != null && limitNode.getTextContent().trim().length() > 0 ? Integer.parseInt(limitNode.getTextContent()) : -1;
                NodeList propertyNodes = connectionElt.getElementsByTagName("property");
                Node propertyNode = null;
                Properties properties = null;
                String name = null;
                String value = null;
                for (int i = 0; i < propertyNodes.getLength(); ++i) {
                    propertyNode = propertyNodes.item(i);
                    if (properties == null) {
                        properties = new Properties();
                    }
                    name = propertyNode.getAttributes().getNamedItem("name").getTextContent();
                    value = propertyNode.getTextContent();
                    properties.setProperty(name, value);
                }
                Node returnGeneratedKeysNode = headerElt.getElementsByTagName("returnGeneratedKeys").item(0);
                boolean returnGeneratedKeys = returnGeneratedKeysNode.getTextContent().equals("true");
                Element bodyElt = (Element)rootElt.getElementsByTagName("body").item(0);
                NodeList statementNodes = bodyElt.getElementsByTagName("statement");
                ArrayList<String> sqlRequests = new ArrayList<String>();
                for (int i = 0; i < statementNodes.getLength(); ++i) {
                    String sqlRequest = statementNodes.item(i).getTextContent();
                    sqlRequests.add(sqlRequest);
                }
                connection = this.getConnection(connectionURI, properties, usePooling);
                JdbcResult result = this.handleSqlRequests(connection, returnGeneratedKeys, sqlRequests);
                response.setEntity((Representation)new RowSetRepresentation(result, start, limit));
            }
            catch (SQLException se) {
                this.getLogger().log(Level.WARNING, "Error while processing the SQL request", se);
                response.setStatus(Status.SERVER_ERROR_INTERNAL, (Throwable)se);
            }
            catch (ParserConfigurationException pce) {
                this.getLogger().log(Level.WARNING, "Error with XML parser configuration", pce);
                response.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, (Throwable)pce);
            }
            catch (SAXException se) {
                this.getLogger().log(Level.WARNING, "Error while parsing the XML document", se);
                response.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, (Throwable)se);
            }
            catch (IOException ioe) {
                this.getLogger().log(Level.WARNING, "Input/Output exception", ioe);
                response.setStatus(Status.SERVER_ERROR_INTERNAL, (Throwable)ioe);
            }
        } else {
            throw new IllegalArgumentException("Only the POST method is supported");
        }
    }

    private JdbcResult handleSqlRequests(Connection connection, boolean returnGeneratedKeys, List<String> sqlRequests) {
        JdbcResult result = null;
        try {
            connection.setAutoCommit(true);
            Statement statement = connection.createStatement();
            for (String sqlRequest : sqlRequests) {
                statement.execute(sqlRequest, returnGeneratedKeys ? 1 : 2);
                result = new JdbcResult(statement);
            }
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException se) {
            this.getLogger().log(Level.WARNING, "Error while processing the SQL requests", se);
            try {
                if (!connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            catch (SQLException se2) {
                this.getLogger().log(Level.WARNING, "Error while rollbacking the transaction", se);
            }
        }
        return result;
    }
}

