/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.json;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;
import org.json.JSONTokener;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.WriterRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonRepresentation
extends WriterRepresentation {
    private boolean indenting;
    private int indentSize;
    private Object jsonObject;
    private Representation jsonRepresentation;

    public JsonRepresentation(JSONArray jsonArray) {
        super(MediaType.APPLICATION_JSON);
        this.init(jsonArray);
    }

    public JsonRepresentation(JSONObject jsonObject) {
        super(MediaType.APPLICATION_JSON);
        this.init(jsonObject);
    }

    public JsonRepresentation(JSONStringer jsonStringer) {
        super(MediaType.APPLICATION_JSON);
        this.init(jsonStringer);
    }

    public JsonRepresentation(JSONTokener jsonTokener) {
        super(MediaType.APPLICATION_JSON);
        this.init(jsonTokener);
    }

    public JsonRepresentation(Map<Object, Object> map) {
        this(new JSONObject(map));
    }

    public JsonRepresentation(Object bean) {
        this(new JSONObject(bean));
    }

    public JsonRepresentation(Representation jsonRepresentation) throws IOException {
        super(jsonRepresentation == null ? null : jsonRepresentation.getMediaType());
        this.jsonRepresentation = jsonRepresentation;
    }

    public JsonRepresentation(String jsonString) {
        super(MediaType.APPLICATION_JSON);
        this.setCharacterSet(CharacterSet.UTF_8);
        this.jsonRepresentation = new StringRepresentation((CharSequence)jsonString);
    }

    public int getIndentSize() {
        return this.indentSize;
    }

    public JSONArray getJsonArray() throws JSONException {
        if (this.jsonObject != null) {
            return (JSONArray)this.jsonObject;
        }
        return this.toJsonArray();
    }

    public JSONObject getJsonObject() throws JSONException {
        if (this.jsonObject != null) {
            return (JSONObject)this.jsonObject;
        }
        return this.toJsonObject();
    }

    private String getJsonText() throws JSONException {
        String result = null;
        if (this.jsonObject != null) {
            if (this.jsonObject instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)this.jsonObject;
                result = this.isIndenting() ? jsonArray.toString(this.getIndentSize()) : jsonArray.toString();
            } else if (this.jsonObject instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)this.jsonObject;
                result = this.isIndenting() ? jsonObject.toString(this.getIndentSize()) : jsonObject.toString();
            } else if (this.jsonObject instanceof JSONStringer) {
                JSONStringer jsonStringer = (JSONStringer)this.jsonObject;
                result = jsonStringer.toString();
            } else if (this.jsonObject instanceof JSONTokener) {
                JSONTokener jsonTokener = (JSONTokener)this.jsonObject;
                result = jsonTokener.toString();
            }
        } else if (this.jsonRepresentation != null) {
            try {
                result = this.jsonRepresentation.getText();
            }
            catch (IOException e) {
                throw new JSONException((Throwable)e);
            }
        }
        return result;
    }

    public JSONTokener getJsonTokener() throws JSONException {
        if (this.jsonObject != null) {
            return (JSONTokener)this.jsonObject;
        }
        return this.toJsonTokener();
    }

    public long getSize() {
        if (this.jsonRepresentation != null) {
            return this.jsonRepresentation.getSize();
        }
        return super.getSize();
    }

    private void init(Object jsonObject) {
        this.setCharacterSet(CharacterSet.UTF_8);
        this.jsonObject = jsonObject;
        this.indenting = false;
        this.indentSize = 3;
    }

    @Deprecated
    public boolean isIndent() {
        return this.indenting;
    }

    public boolean isIndenting() {
        return this.isIndent();
    }

    @Deprecated
    public void setIndent(boolean indenting) {
        this.indenting = indenting;
    }

    public void setIndenting(boolean indenting) {
        this.setIndent(indenting);
    }

    public void setIndentSize(int indentFactor) {
        this.indentSize = indentFactor;
    }

    public JSONArray toJsonArray() throws JSONException {
        return new JSONArray(this.getJsonText());
    }

    public JSONObject toJsonObject() throws JSONException {
        return new JSONObject(this.getJsonText());
    }

    public JSONTokener toJsonTokener() throws JSONException {
        return new JSONTokener(this.getJsonText());
    }

    public void write(Writer writer) throws IOException {
        try {
            writer.write(this.getJsonText());
        }
        catch (JSONException e) {
            IOException ioe = new IOException(e.getLocalizedMessage());
            ioe.initCause(e.getCause());
            throw ioe;
        }
    }
}

