/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth;

import java.util.List;
import java.util.logging.Level;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Form;
import org.restlet.data.Parameter;
import org.restlet.data.Status;
import org.restlet.engine.util.Base64;
import org.restlet.ext.oauth.AuthenticatedUser;
import org.restlet.ext.oauth.Client;
import org.restlet.ext.oauth.GrantType;
import org.restlet.ext.oauth.OAuthError;
import org.restlet.ext.oauth.OAuthServerResource;
import org.restlet.ext.oauth.internal.ExpireToken;
import org.restlet.ext.oauth.internal.JsonStringRepresentation;
import org.restlet.ext.oauth.internal.Scopes;
import org.restlet.ext.oauth.internal.Token;
import org.restlet.representation.Representation;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;
import org.restlet.security.Role;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessTokenServerResource
extends OAuthServerResource {
    private JSONObject createJsonToken(Token token, String scopes) throws ResourceException {
        JSONObject body = new JSONObject();
        try {
            body.put("access_token", (Object)token.getToken());
            if (token instanceof ExpireToken) {
                ExpireToken et = (ExpireToken)token;
                body.put("expires_in", et.getExpirePeriod());
                body.put("refresh_token", (Object)et.getRefreshToken());
            }
        }
        catch (JSONException e) {
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, "Failed to generate JSON", (Throwable)e);
        }
        return body;
    }

    private Representation doAuthCodeFlow(String clientId, String clientSecret, Series<Parameter> params) throws IllegalArgumentException {
        String redirUri = params.getFirstValue("redirect_uri");
        if (redirUri == null || redirUri.length() == 0) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return this.sendError(OAuthError.invalid_request, "Mandatory parameter redirect_uri is missing", null);
        }
        String code = params.getFirstValue("code");
        if (code == null || code.length() == 0) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return this.sendError(OAuthError.invalid_request, "Mandatory parameter code is missing", null);
        }
        Client client = this.validate(clientId, clientSecret);
        if (client == null) {
            this.setStatus(Status.CLIENT_ERROR_FORBIDDEN);
            return this.sendError(OAuthError.invalid_request, "Client id verification failed.", null);
        }
        if (!clientSecret.equals(client.getClientSecret())) {
            this.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
            return this.sendError(OAuthError.invalid_request, "Client secret did not match", null);
        }
        Token token = this.generator.exchangeForToken(code, this.tokenTimeSec);
        JSONObject body = this.createJsonToken(token, null);
        this.getResponse().setCacheDirectives(noStore);
        return new JsonStringRepresentation(body);
    }

    private Representation doNoneFlow(String clientId, String clientSecret, Series<Parameter> params) {
        Client client = this.validate(clientId, clientSecret);
        if (client == null) {
            this.setStatus(Status.CLIENT_ERROR_FORBIDDEN);
            return this.sendError(OAuthError.invalid_client, "Client id verification failed.", null);
        }
        if (!client.containsUser("__autonomous")) {
            client.createUser("__autonomous");
        }
        AuthenticatedUser user = client.findUser("__autonomous");
        List<Role> roles = Scopes.toRoles(params.getFirstValue("scope"));
        for (Role r : roles) {
            this.getLogger().fine("Requested scopes none flow = " + roles);
            user.addRole(r, "");
            this.getLogger().fine("Adding scope = " + r.getName() + " to auto user");
        }
        Token token = this.generator.generateToken(user, this.tokenTimeSec);
        JSONObject body = this.createJsonToken(token, null);
        this.getResponse().setCacheDirectives(noStore);
        return new JsonStringRepresentation(body);
    }

    private Representation doPasswordFlow(String clientId, String clientSecret, Series<Parameter> params) {
        Client client = this.validate(clientId, clientSecret);
        if (client == null) {
            this.setStatus(Status.CLIENT_ERROR_FORBIDDEN);
            return this.sendError(OAuthError.invalid_client, "Client id verification failed.", null);
        }
        String username = params.getFirstValue("username");
        AuthenticatedUser user = null;
        if (username == null || (user = client.findUser(username)) == null) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return this.sendError(OAuthError.invalid_request, "Mandatory parameter username missing.", null);
        }
        String password = params.getFirstValue("password");
        if (password == null) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return this.sendError(OAuthError.invalid_request, "Mandatory parameter password missing.", null);
        }
        if (!password.equals(user.getPassword())) {
            this.setStatus(Status.CLIENT_ERROR_FORBIDDEN);
            return this.sendError(OAuthError.invalid_grant, "Password not correct.", null);
        }
        Token token = this.generator.generateToken(user, this.tokenTimeSec);
        JSONObject body = this.createJsonToken(token, null);
        this.getResponse().setCacheDirectives(noStore);
        return new JsonStringRepresentation(body);
    }

    private Representation doRefreshFlow(String clientId, String clientSecret, Series<Parameter> params) {
        String rToken = params.getFirstValue("refresh_token");
        if (rToken == null || rToken.length() == 0) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return this.sendError(OAuthError.invalid_request, "Mandatory parameter refresh_token is missing", null);
        }
        Client client = this.validate(clientId, clientSecret);
        if (client == null) {
            this.setStatus(Status.CLIENT_ERROR_FORBIDDEN);
            return this.sendError(OAuthError.invalid_client, "Client id verification failed.", null);
        }
        Token token = this.generator.findToken(rToken);
        if (token != null && token instanceof ExpireToken) {
            AuthenticatedUser user = token.getUser();
            if (client.containsUser(user.getId())) {
                this.generator.refreshToken((ExpireToken)token);
                JSONObject body = this.createJsonToken(token, null);
                this.getResponse().setCacheDirectives(noStore);
                return new JsonStringRepresentation(body);
            }
            this.setStatus(Status.CLIENT_ERROR_FORBIDDEN);
            return this.sendError(OAuthError.unauthorized_client, "User does not match.", null);
        }
        this.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
        return this.sendError(OAuthError.invalid_grant, "Refresh token.", null);
    }

    @Post(value="form:json")
    public Representation represent(Representation input) {
        String basic;
        int colon;
        ChallengeResponse cr;
        this.getLogger().fine("Method = " + this.getMethod().getName());
        this.getLogger().fine("In request : " + this.getOriginalRef().toString());
        Form params = new Form(input);
        String typeString = params.getFirstValue("grant_type");
        this.getLogger().fine("Token Service - In service type = " + typeString);
        String clientId = params.getFirstValue("client_id");
        String clientSecret = params.getFirstValue("client_secret");
        if ((clientSecret == null || clientSecret.length() == 0) && ChallengeScheme.HTTP_BASIC.equals((Object)(cr = this.getChallengeResponse()).getScheme()) && (colon = (basic = new String(Base64.decode((String)cr.getRawValue()))).indexOf(58)) > -1) {
            clientSecret = basic.substring(colon + 1);
            this.getLogger().fine("Found secret in BASIC Authentication : " + clientSecret);
            if (colon > 0) {
                clientId = basic.substring(0, colon);
                this.getLogger().fine("Found id in BASIC Authentication : " + clientId);
            }
        }
        Representation toRet = null;
        if (clientId == null || clientId.length() == 0) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return this.sendError(OAuthError.invalid_request, "Mandatory parameter client_id is missing", null);
        }
        if (clientSecret == null || clientSecret.length() == 0) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return this.sendError(OAuthError.invalid_request, "Mandatory parameter client_secret is missing", null);
        }
        try {
            GrantType type = Enum.valueOf(GrantType.class, typeString);
            this.getLogger().fine("Found flow - " + (Object)((Object)type));
            try {
                switch (type) {
                    case authorization_code: {
                        toRet = this.doAuthCodeFlow(clientId, clientSecret, (Series<Parameter>)params);
                        break;
                    }
                    case password: {
                        toRet = this.doPasswordFlow(clientId, clientSecret, (Series<Parameter>)params);
                        break;
                    }
                    case assertion: {
                        this.sendError(OAuthError.unsupported_grant_type, "Assertion flow not supported", null);
                        this.setStatus(Status.SERVER_ERROR_NOT_IMPLEMENTED);
                        break;
                    }
                    case refresh_token: {
                        toRet = this.doRefreshFlow(clientId, clientSecret, (Series<Parameter>)params);
                        break;
                    }
                    case none: {
                        toRet = this.doNoneFlow(clientId, clientSecret, (Series<Parameter>)params);
                        break;
                    }
                    default: {
                        toRet = this.sendError(OAuthError.unsupported_grant_type, "Flow not supported", null);
                        this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
                        break;
                    }
                }
            }
            catch (IllegalArgumentException e) {
                toRet = this.sendError(OAuthError.invalid_grant, e.getMessage(), null);
                this.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
            }
        }
        catch (IllegalArgumentException iae) {
            toRet = this.sendError(OAuthError.unsupported_grant_type, "Flow not supported", null);
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
        }
        catch (NullPointerException npe) {
            toRet = this.sendError(OAuthError.unsupported_grant_type, "Flow not supported", null);
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
        }
        return toRet;
    }

    protected Representation sendError(OAuthError error, String description, String errorUri) {
        JSONObject result = new JSONObject();
        try {
            result.put("error", (Object)error.name());
            if (description != null && description.length() > 0) {
                result.put("error_description", (Object)description);
            }
            if (errorUri != null && errorUri.length() > 0) {
                result.put("error_uri", (Object)errorUri);
            }
            return new JsonStringRepresentation(result);
        }
        catch (JSONException e) {
            this.getLogger().log(Level.WARNING, "Error while sending OAuth error.", e);
            return null;
        }
    }

    private Client validate(String clientId, String clientSecret) {
        Client client = this.clients.findById(clientId);
        this.getLogger().fine("Client = " + client);
        if (client == null) {
            this.sendError(OAuthError.invalid_client, "Could not find the correct client with id : " + clientId, null);
            this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            return null;
        }
        if (clientSecret == null || !clientSecret.equals(client.getClientSecret())) {
            this.sendError(OAuthError.invalid_grant, "Client secret did not match", null);
            this.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
            this.getLogger().warning("Could not find or match client secret " + clientSecret + " : " + client.getClientSecret());
        }
        return client;
    }
}

