/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth;

import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.data.Protocol;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.ext.oauth.AuthenticatedUser;
import org.restlet.ext.oauth.OAuthError;
import org.restlet.ext.oauth.OAuthServerResource;
import org.restlet.ext.oauth.internal.ExpireToken;
import org.restlet.ext.oauth.internal.JsonStringRepresentation;
import org.restlet.ext.oauth.internal.Scopes;
import org.restlet.ext.oauth.internal.Token;
import org.restlet.representation.Representation;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class ValidationServerResource
extends OAuthServerResource {
    public static final String LOCAL_ACCESS_ONLY = "localOnly";

    @Post(value="json")
    public Representation validate(Representation input) throws ResourceException {
        boolean localOnly;
        this.getLogger().fine("In Validator resource");
        JSONObject response = new JSONObject();
        boolean authenticated = false;
        String lo = (String)this.getContext().getAttributes().get(LOCAL_ACCESS_ONLY);
        if (lo != null && lo.length() > 0 && (localOnly = Boolean.parseBoolean(lo))) {
            String scheme = this.getOriginalRef().getScheme();
            if (!Protocol.RIAP.getSchemeName().equals(scheme)) {
                this.setStatus(Status.CLIENT_ERROR_FORBIDDEN, "Auth server only allows local resource validation");
                return null;
            }
        }
        try {
            String error = null;
            JsonRepresentation rest = new JsonRepresentation(input);
            JSONObject call = rest.getJsonObject();
            String token = call.get("access_token").toString();
            String uri = call.get("uri").toString();
            JSONArray scopes = null;
            if (call.has("scope")) {
                scopes = call.getJSONArray("scope");
            }
            String owner = null;
            if (call.has("owner")) {
                owner = call.getString("owner");
            }
            this.getLogger().fine("In Validator resource - searching for token = " + token);
            Token t = this.generator.findToken(token);
            if (t == null) {
                response.put("authenticated", authenticated);
                error = OAuthError.invalid_token.name();
            } else {
                ExpireToken et;
                this.getLogger().fine("In Validator resource - got token = " + t);
                if (t instanceof ExpireToken && !token.equals((et = (ExpireToken)t).getToken())) {
                    error = OAuthError.invalid_token.name();
                    this.getLogger().warning("Should not use the refresh_token to sign!");
                }
                this.getLogger().fine("Received uri = " + uri);
                this.getLogger().fine("Received scope = " + scopes);
                this.getLogger().fine("Received owner = " + owner);
                AuthenticatedUser user = t.getUser();
                boolean bl = authenticated = user != null;
                if (!authenticated) {
                    error = OAuthError.invalid_request.name();
                }
                if (authenticated && scopes != null && scopes.length() > 0) {
                    for (int i = 0; i < scopes.length(); ++i) {
                        if (scopes.isNull(i)) continue;
                        String scope = scopes.getString(i);
                        boolean granted = user.isGrantedRole(Scopes.toRole(scope), owner);
                        this.getLogger().fine("Granted permission : " + scope + " = " + granted);
                        if (granted) continue;
                        error = OAuthError.insufficient_scope.name();
                        authenticated = false;
                        break;
                    }
                }
                if (authenticated) {
                    if (owner != null && owner.length() > 0 && !"__autonomous".equals(user.getId()) && !owner.equals(user.getId())) {
                        authenticated = false;
                        error = OAuthError.invalid_request.name();
                    } else {
                        response.put("tokenOwner", (Object)user.getId());
                    }
                }
                response.put("authenticated", authenticated);
                if (error != null) {
                    response.put("error", (Object)error);
                }
                this.getResponse().setCacheDirectives(noStore);
                this.getResponse().setCacheDirectives(noCache);
            }
        }
        catch (JSONException e) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Failed parse JSON", (Throwable)e);
        }
        catch (IOException e) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Failed parse JSON", (Throwable)e);
        }
        return new JsonStringRepresentation(response);
    }
}

