/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.restlet.ext.oauth.AuthenticatedUser;
import org.restlet.ext.oauth.Client;
import org.restlet.ext.oauth.internal.Token;
import org.restlet.security.Role;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticatedUserImpl
extends AuthenticatedUser {
    private final Client client;
    private final String id;
    private final Map<Role, String> grantedRoles;
    private volatile String code;
    private volatile Token token;
    private volatile String password;
    private long maxTokenLifeSec = 0L;

    public AuthenticatedUserImpl(String userId, Client client) {
        this.id = userId;
        this.client = client;
        this.grantedRoles = new ConcurrentHashMap<Role, String>();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public void clearCode() {
        this.code = null;
    }

    @Override
    public void addRole(Role role, String owner) {
        this.grantedRoles.put(role, owner);
    }

    @Override
    public boolean isGrantedRole(Role role, String owner) {
        return this.grantedRoles.containsKey(role);
    }

    @Override
    public void revokeRole(Role role, String owner) {
        this.grantedRoles.remove(role);
    }

    @Override
    public List<Role> getGrantedRoles() {
        return new ArrayList<Role>(this.grantedRoles.keySet());
    }

    @Override
    public long getTokenExpire() {
        return this.maxTokenLifeSec;
    }

    @Override
    public void setTokenExpire(long deltaTimeSec) {
        this.maxTokenLifeSec = deltaTimeSec;
    }

    @Override
    public void revokeRoles() {
        this.grantedRoles.clear();
    }

    @Override
    public Token getToken() {
        return this.token;
    }

    @Override
    public void setToken(Token token) {
        this.token = token;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public Client getClient() {
        return this.client;
    }

    public boolean equals(Object obj) {
        if (obj instanceof String) {
            return obj.equals(this.id);
        }
        if (obj instanceof AuthenticatedUserImpl) {
            AuthenticatedUserImpl aui = (AuthenticatedUserImpl)obj;
            return this.id.equals(aui.id);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

