/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth;

import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.logging.Level;
import org.restlet.data.CookieSetting;
import org.restlet.data.Form;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.ext.oauth.AuthenticatedUser;
import org.restlet.ext.oauth.Client;
import org.restlet.ext.oauth.HttpOAuthHelper;
import org.restlet.ext.oauth.OAuthError;
import org.restlet.ext.oauth.OAuthServerResource;
import org.restlet.ext.oauth.ResponseType;
import org.restlet.ext.oauth.internal.AuthSession;
import org.restlet.ext.oauth.internal.Scopes;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.routing.Redirector;
import org.restlet.security.Role;

public class AuthorizationServerResource
extends OAuthServerResource {
    @Get(value="html")
    @Post(value="html")
    public Representation represent() {
        Form params = this.getQuery();
        String sessionId = this.getCookies().getFirstValue("_cid");
        this.getLogger().fine("sessionId = " + sessionId);
        ConcurrentMap attribs = this.getContext().getAttributes();
        AuthSession session = sessionId == null ? null : (AuthSession)attribs.get(sessionId);
        String scopeOwner = null;
        if (this.getRequest().getClientInfo().getUser() != null) {
            scopeOwner = this.getRequest().getClientInfo().getUser().getIdentifier();
        }
        if (scopeOwner == null && session != null) {
            scopeOwner = session.getScopeOwner();
        }
        this.getLogger().fine("OWNER - " + scopeOwner);
        if (scopeOwner == null) {
            this.sendError(sessionId, OAuthError.invalid_request, params.getFirstValue("state"), "No Scope Owner", null);
            return this.getResponseEntity();
        }
        String clientId = params.getFirstValue("client_id");
        if (clientId == null || clientId.length() < 1) {
            this.sendError(sessionId, OAuthError.invalid_request, params.getFirstValue("state"), "No client_id parameter found.", null);
            this.getLogger().warning("Could not find client ID");
            return this.getResponseEntity();
        }
        Client client = this.clients.findById(clientId);
        this.getLogger().fine("Client = " + client);
        if (client == null) {
            this.sendError(sessionId, OAuthError.invalid_client, params.getFirstValue("state"), "Need to register the client : " + clientId, null);
            this.getLogger().warning("Need to register the client : " + clientId);
            return this.getResponseEntity();
        }
        this.getLogger().fine("CLIENT ID - " + clientId);
        String redirUri = params.getFirstValue("redirect_uri");
        if (redirUri == null || redirUri.length() == 0) {
            this.sendError(sessionId, OAuthError.invalid_request, params.getFirstValue("state"), "No redirect_uri parameter found.", null);
            this.getLogger().warning("No mandatory redirect URI provided");
            return this.getResponseEntity();
        }
        if (!redirUri.startsWith(client.getRedirectUri())) {
            this.sendError(sessionId, OAuthError.redirect_uri_mismatch, params.getFirstValue("state"), "Callback URI does not match.", null);
            this.getLogger().warning("Callback URI does not match.");
            return this.getResponseEntity();
        }
        this.getLogger().fine("CLIENT ID - " + clientId);
        String typeString = params.getFirstValue("response_type");
        ResponseType type = null;
        try {
            type = Enum.valueOf(ResponseType.class, typeString);
            this.getLogger().fine("Found flow - " + (Object)((Object)type));
            if (!Method.GET.equals((Object)this.getMethod())) {
                this.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
            }
        }
        catch (IllegalArgumentException iae) {
            this.sendError(sessionId, OAuthError.unsupported_response_type, params.getFirstValue("state"), "Unsupported flow", null);
            this.getLogger().log(Level.WARNING, "Error in execution.", iae);
        }
        catch (NullPointerException npe) {
            this.sendError(sessionId, OAuthError.invalid_request, params.getFirstValue("state"), "No response_type parameter found.", null);
        }
        this.getLogger().fine("RESPONSE TYPE - " + (Object)((Object)type));
        if (session != null) {
            this.getLogger().fine("client = " + session.getClient());
        } else {
            this.getCookieSettings().removeAll("_cid");
        }
        if (session == null) {
            this.getLogger().fine("Setting ClientCookieID");
            session = new AuthSession(this.getContext().getAttributes(), new ScheduledThreadPoolExecutor(5));
            CookieSetting cs = new CookieSetting("_cid", session.getId());
            this.getCookieSettings().add((Object)cs);
            this.getLogger().fine("Setting cookie - " + session.getId());
        }
        this.setupSession(session, client, type, redirUri, params);
        session.setScopeOwner(scopeOwner);
        return this.doPostAuthenticate(session, client);
    }

    protected void setupSession(AuthSession in, Client client, ResponseType flow, String redirUri, Form params) {
        String state;
        this.getLogger().fine("Base ref = " + this.getReference().getParentRef());
        this.getLogger().fine("OAuth2 session = " + in);
        AuthSession session = in;
        if (session == null) {
            session = new AuthSession(this.getContext().getAttributes(), new ScheduledThreadPoolExecutor(5));
            CookieSetting cs = new CookieSetting("_cid", session.getId());
            this.getCookieSettings().add((Object)cs);
            this.getLogger().fine("Setting cookie in SetupSession - " + session.getId());
        }
        session.setClient(client);
        session.setAuthFlow(flow);
        if (!redirUri.equals(client.getRedirectUri())) {
            session.setDynamicCallbackURI(redirUri);
            this.getLogger().fine("OAuth2 set dynamic callback = " + redirUri);
        }
        if ((state = this.getCookies().getFirstValue("state")) != null && state.length() > 0) {
            session.setState(state);
        }
        String[] scopes = this.parseScope(params.getFirstValue("scope"));
        session.setRequestedScope(scopes);
    }

    protected Representation doPostAuthenticate(AuthSession session, Client client) {
        List<Role> roles;
        AuthenticatedUser user;
        Reference ref = new Reference("riap://application" + HttpOAuthHelper.getAuthPage(this.getContext()));
        this.getLogger().fine("Name = " + this.getApplication().getInboundRoot());
        ref.addQueryParameter("client", client.getClientId());
        String[] scopes = session.getRequestedScope();
        if (scopes != null && scopes.length > 0) {
            for (String s : scopes) {
                ref.addQueryParameter("scope", s);
            }
        }
        if ((user = client.findUser(session.getScopeOwner())) != null && (roles = user.getGrantedRoles()) != null && roles.size() > 0) {
            for (Role r : roles) {
                ref.addQueryParameter("grantedScope", Scopes.toScope(r));
            }
        }
        this.getLogger().fine("Redir = " + ref);
        Redirector dispatcher = new Redirector(this.getContext(), ref.toString(), 6);
        this.getRequest().getAttributes().put("_cid", session.getId());
        dispatcher.handle(this.getRequest(), this.getResponse());
        return this.getResponseEntity();
    }

    public void sendError(String sessionId, OAuthError error, String state) {
        this.sendError(sessionId, error, state, null, null);
    }

    public void sendError(String sessionId, OAuthError error, String state, String description, String errorUri) {
        Form params = this.getQuery();
        String redirUri = params.getFirstValue("redirect_uri");
        if (redirUri == null || redirUri.length() == 0) {
            redirUri = "https://127.0.0.1/cb";
        }
        Reference cb = new Reference(redirUri);
        cb.addQueryParameter("error", error.name());
        if (state != null && state.length() > 0) {
            cb.addQueryParameter("state", state);
        }
        if (description != null && description.length() > 0) {
            cb.addQueryParameter("error_description", description);
        }
        if (errorUri != null && errorUri.length() > 0) {
            cb.addQueryParameter("error_uri", errorUri);
        }
        this.redirectTemporary(cb.toString());
        if (sessionId != null && sessionId.length() > 0) {
            ConcurrentMap attribs = this.getContext().getAttributes();
            attribs.remove(sessionId);
        }
    }
}

