/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Context;
import org.restlet.ext.oauth.ClientStore;
import org.restlet.ext.oauth.internal.MemClientStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClientStoreFactory {
    private static volatile Class<? extends ClientStore<?>> defaultImpl = MemClientStore.class;
    private static volatile Object[] params = new Object[0];
    private static volatile ClientStore<?> store;
    private static volatile Logger log;

    private ClientStoreFactory() {
    }

    public static synchronized ClientStore<?> getInstance() {
        if (log == null) {
            log = Context.getCurrentLogger();
        }
        if (store == null) {
            Class[] classTypes = new Class[params.length];
            int i = 0;
            for (Object o : params) {
                classTypes[i++] = o.getClass();
            }
            try {
                Constructor<ClientStore<?>> c = defaultImpl.getConstructor(classTypes);
                store = c.newInstance(params);
            }
            catch (SecurityException e) {
                log.log(Level.SEVERE, "Failed to initialize OAuth Data backend!", e);
            }
            catch (NoSuchMethodException e) {
                log.log(Level.SEVERE, "Failed to initialize OAuth Data backend!", e);
            }
            catch (IllegalArgumentException e) {
                log.log(Level.SEVERE, "Failed to initialize OAuth Data backend!", e);
            }
            catch (InstantiationException e) {
                log.log(Level.SEVERE, "Failed to initialize OAuth Data backend!", e);
            }
            catch (IllegalAccessException e) {
                log.log(Level.SEVERE, "Failed to initialize OAuth Data backend!", e);
            }
            catch (InvocationTargetException e) {
                log.log(Level.SEVERE, "Failed to initialize OAuth Data backend!", e);
            }
        }
        return store;
    }

    public static void setClientStoreImpl(Class<? extends ClientStore<?>> impl) {
        defaultImpl = impl;
        Object[] dummy = null;
        ClientStoreFactory.setClientStoreImpl(impl, dummy);
    }

    public static void setClientStoreImpl(Class<? extends ClientStore<?>> impl, Object ... constructorParams) {
        if (store != null && !store.getClass().equals(impl)) {
            throw new IllegalStateException("Can't change the type of store once it already initialized.");
        }
        defaultImpl = impl;
        params = constructorParams;
    }
}

