/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth;

import java.util.List;
import org.restlet.data.Reference;
import org.restlet.security.Role;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthParameters {
    private volatile String accessTokenPath = "access_token";
    private volatile String authorizePath = "authorize";
    private final Reference baseRef;
    private final String clientId;
    private final String clientSecret;
    private volatile String owner = null;
    private volatile List<Role> roles;

    public OAuthParameters(String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.baseRef = new Reference("http://localhost:8080/oauth/");
    }

    public OAuthParameters(String clientId, String clientSecret, String baseRef) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.baseRef = new Reference(baseRef);
    }

    public OAuthParameters(String clientId, String clientSecret, String baseRef, List<Role> roles) {
        this(clientId, clientSecret, baseRef);
        this.roles = roles;
    }

    public String getAccessTokenPath() {
        return this.accessTokenPath;
    }

    public String getAuthorizePath() {
        return this.authorizePath;
    }

    public Reference getBaseRef() {
        return this.baseRef;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getOwner() {
        return this.owner;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    public void setAccessTokenPath(String accessTokenPath) {
        this.accessTokenPath = accessTokenPath;
    }

    public void setAuthorizePath(String authorizePath) {
        this.authorizePath = authorizePath;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setRoles(List<Role> roles) {
        this.roles = roles;
    }
}

