/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentMap;
import org.restlet.Context;
import org.restlet.data.CacheDirective;
import org.restlet.ext.oauth.AuthenticatedUser;
import org.restlet.ext.oauth.Client;
import org.restlet.ext.oauth.ClientStore;
import org.restlet.ext.oauth.ClientStoreFactory;
import org.restlet.ext.oauth.internal.AuthSession;
import org.restlet.ext.oauth.internal.Token;
import org.restlet.ext.oauth.internal.TokenGenerator;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;

public abstract class OAuthServerResource
extends ServerResource {
    public static final String ACCESS_TOKEN = "access_token";
    public static final String ASSERTION = "assertion";
    public static final String ASSERTION_TYPE = "assertion_type";
    public static final String AUTONOMOUS_USER = "__autonomous";
    public static final String CLIENT_ID = "client_id";
    public static final String CLIENT_SECRET = "client_secret";
    public static final String ClientCookieID = "_cid";
    public static final String CODE = "code";
    public static final String ERROR = "error";
    public static final String ERROR_DESC = "error_description";
    public static final String ERROR_URI = "error_uri";
    public static final String EXPIRES_IN = "expires_in";
    public static final String GRANT_TYPE = "grant_type";
    protected static final List<CacheDirective> noCache;
    protected static final List<CacheDirective> noStore;
    public static final String OAUTH_TOKEN = "oauth_token";
    public static final String PASSWORD = "password";
    public static final String REDIR_URI = "redirect_uri";
    public static final String REFRESH_TOKEN = "refresh_token";
    public static final String RESPONSE_TYPE = "response_type";
    public static final String SCOPE = "scope";
    public static final String STATE = "state";
    public static final String TOKEN_SERVER_MAX_TIME_SEC = "_token_server_max_time_sec";
    public static final String TOKEN_SERVER_TIME_SEC = "_token_server_time_sec";
    public static final String USERNAME = "username";
    protected volatile ClientStore<?> clients;
    protected volatile TokenGenerator generator;
    protected volatile long tokenMaxTimeSec = 0L;
    protected volatile long tokenTimeSec = 0L;

    private void appendState(StringBuilder location) {
        ConcurrentMap attribs;
        AuthSession session;
        String state;
        String sessionId = (String)this.getRequest().getAttributes().get(ClientCookieID);
        if (sessionId == null) {
            sessionId = this.getCookies().getFirstValue(ClientCookieID);
        }
        if ((state = (session = (AuthSession)(attribs = this.getContext().getAttributes()).get(sessionId)).getState()) != null && state.length() > 0) {
            location.append("&state=");
            location.append(state);
        }
        session.reset();
    }

    protected void doInit() throws ResourceException {
        super.doInit();
        Context ctx = this.getContext();
        ConcurrentMap attribs = ctx.getAttributes();
        this.clients = ClientStoreFactory.getInstance();
        this.getLogger().fine("Found client store = " + this.clients);
        this.generator = this.clients.getTokenGenerator();
        this.getLogger().fine("Found token generator = " + this.generator);
        if (attribs.containsKey(TOKEN_SERVER_TIME_SEC)) {
            this.tokenTimeSec = (Long)attribs.get(TOKEN_SERVER_TIME_SEC);
        }
        if (attribs.containsKey(TOKEN_SERVER_MAX_TIME_SEC)) {
            this.tokenMaxTimeSec = (Long)attribs.get(TOKEN_SERVER_MAX_TIME_SEC);
        }
        this.generator.setMaxTokenTime(this.tokenMaxTimeSec);
    }

    protected String generateAgentToken(String userId, Client client, String redirURL) {
        AuthenticatedUser user = null;
        user = client.containsUser(userId) ? client.findUser(userId) : client.createUser(userId);
        Token token = this.generator.generateToken(user, this.tokenTimeSec);
        StringBuilder location = new StringBuilder(redirURL);
        location.append("#access_token=").append(token.getToken());
        this.appendState(location);
        this.getResponse().setCacheDirectives(noStore);
        this.getLogger().fine("Redirecting to -> " + location.toString());
        return location.toString();
    }

    protected String generateCode(String userId, Client client, String redirURL) {
        AuthenticatedUser user = null;
        user = client.containsUser(userId) ? client.findUser(userId) : client.createUser(userId);
        String code = this.generator.generateCode(user);
        StringBuilder location = new StringBuilder(redirURL);
        String c = location.indexOf("?") == -1 ? "?code=" : "&code=";
        location.append(c).append(code);
        this.appendState(location);
        this.getResponse().setCacheDirectives(noStore);
        this.getLogger().fine("Redirecting to -> " + location.toString());
        return location.toString();
    }

    protected String getParameter(String parameter, String defaultValue) {
        String val = (String)this.getContext().getAttributes().get(parameter);
        return val != null ? val : defaultValue;
    }

    protected String[] parseScope(String scopes) {
        if (scopes != null && scopes.length() > 0) {
            StringTokenizer st = new StringTokenizer(scopes, " ");
            String[] scope = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                scope[i] = st.nextToken();
                ++i;
            }
            return scope;
        }
        return new String[0];
    }

    static {
        noStore = new ArrayList<CacheDirective>();
        noStore.add(CacheDirective.noStore());
        noCache = new ArrayList<CacheDirective>();
        noCache.add(CacheDirective.noCache());
    }
}

