/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.CacheDirective;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.ext.oauth.OAuthError;
import org.restlet.ext.oauth.OAuthParameters;
import org.restlet.ext.oauth.OAuthUser;
import org.restlet.ext.oauth.internal.Scopes;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.ClientResource;
import org.restlet.routing.Filter;
import org.restlet.security.User;

@Deprecated
public class OauthProxyV2
extends Filter {
    public static final String VERSION = "DRAFT-2";
    List<CacheDirective> no = new ArrayList<CacheDirective>();
    private final OAuthParameters params;
    private String redirectUri;
    private String accessToken = null;

    public OauthProxyV2(OAuthParameters params, Context ctx) {
        this.setContext(ctx);
        this.params = params;
        this.no.add(CacheDirective.noStore());
    }

    protected int beforeHandle(Request request, Response response) {
        Boolean auth = false;
        request.setCacheDirectives(this.no);
        response.setCacheDirectives(this.no);
        this.redirectUri = request.getResourceRef().toUrl().toString();
        Form query = new Form(request.getOriginalRef().getQuery());
        if (this.handleError(query, response)) {
            return 2;
        }
        String code = query.getFirstValue("code");
        this.getLogger().fine("Incomming request query = " + query);
        if (code == null) {
            Form form = new Form();
            form.add("type", "web_server");
            form.add("client_id", this.params.getClientId());
            form.add("redirect_uri", this.redirectUri);
            form.add("scope", Scopes.toScope(this.params.getRoles()));
            try {
                form.encode();
            }
            catch (IOException ioe) {
                this.getLogger().warning(ioe.getMessage());
            }
            String q = form.getQueryString();
            this.getLogger().fine("TEST query = " + q);
            Reference redirRef = new Reference(this.params.getBaseRef(), this.params.getAuthorizePath(), q, null);
            this.getLogger().fine("Redirecting to : " + redirRef.toUri());
            response.redirectSeeOther(redirRef);
            this.getLogger().fine("After Redirecting to : " + redirRef.toUri());
        } else {
            this.getLogger().fine("Came back after SNS code = " + code);
            ClientResource graphResource = new ClientResource(this.params.getBaseRef());
            ClientResource tokenResource = graphResource.getChild(this.params.getAccessTokenPath());
            Form form = new Form();
            form.add("type", "web_server");
            form.add("client_id", this.params.getClientId());
            String redir = request.getResourceRef().getHostIdentifier() + request.getResourceRef().getPath();
            form.add("redirect_uri", redir);
            form.add("client_secret", this.params.getClientSecret());
            form.add("code", code);
            Representation body = tokenResource.post(form.getWebRepresentation());
            if (tokenResource.getStatus().isSuccess()) {
                Form answer = new Form(body);
                this.getLogger().fine("Got answer on AccessToken = " + answer.toString());
                this.accessToken = answer.getFirstValue("access_token");
                this.getLogger().fine("AccessToken in changed OldOauthProxy = " + this.accessToken);
                request.getClientInfo().setUser((User)new OAuthUser(request.getClientInfo().getUser(), this.accessToken));
                request.getClientInfo().setAuthenticated(true);
                auth = true;
            }
            this.getLogger().fine("Before graph release");
            body.release();
            tokenResource.release();
            graphResource.release();
        }
        if (auth.booleanValue()) {
            return 0;
        }
        if (response.getStatus().isSuccess() || response.getStatus().isServerError()) {
            response.setStatus(Status.CLIENT_ERROR_FORBIDDEN);
        }
        return 2;
    }

    private boolean handleError(Form query, Response response) {
        String error = query.getFirstValue("error");
        if (error != null && error.length() > 0) {
            EmptyRepresentation repr = new EmptyRepresentation();
            String desc = query.getFirstValue("error_description");
            String uri = query.getFirstValue("error_uri");
            if (desc != null || uri != null) {
                StringBuilder sb = new StringBuilder();
                sb.append("<html><body><pre>");
                sb.append("OAuth2 error detected.\n");
                if (desc != null) {
                    sb.append("Error description : ").append(desc);
                }
                if (uri != null) {
                    sb.append("<a href=\"");
                    sb.append(uri);
                    sb.append("\">Error Description</a>");
                }
                sb.append("</pre></body></html>");
                repr = new StringRepresentation((CharSequence)sb.toString(), MediaType.TEXT_HTML);
            }
            OAuthError ec = OAuthError.valueOf(error);
            switch (ec) {
                case invalid_request: {
                    response.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, error);
                    response.setEntity((Representation)repr);
                    break;
                }
                case invalid_client: {
                    response.setStatus(Status.CLIENT_ERROR_NOT_FOUND, error);
                    response.setEntity((Representation)repr);
                    break;
                }
                case unauthorized_client: {
                    response.setStatus(Status.CLIENT_ERROR_FORBIDDEN, error);
                    response.setEntity((Representation)repr);
                    break;
                }
                case redirect_uri_mismatch: {
                    response.setStatus(Status.CLIENT_ERROR_FORBIDDEN, error);
                    response.setEntity((Representation)repr);
                    break;
                }
                case access_denied: {
                    response.setStatus(Status.CLIENT_ERROR_FORBIDDEN, error);
                    response.setEntity((Representation)repr);
                    break;
                }
                case unsupported_response_type: {
                    response.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, error);
                    response.setEntity((Representation)repr);
                    break;
                }
                case invalid_scope: {
                    response.setStatus(Status.CLIENT_ERROR_FORBIDDEN, error);
                    response.setEntity((Representation)repr);
                    break;
                }
                default: {
                    this.getLogger().warning("Unhandled error response type. " + ec.name());
                }
            }
            return true;
        }
        return false;
    }
}

