/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth.internal;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.restlet.ext.oauth.AuthenticatedUser;
import org.restlet.ext.oauth.internal.ExpireToken;
import org.restlet.ext.oauth.internal.Token;
import org.restlet.ext.oauth.internal.UnlimitedToken;

public abstract class TokenGenerator {
    private volatile SecureRandom random;
    protected volatile long maxTokenTimeSec;
    private static final int tokens = 1000;
    private volatile int count = 0;

    public TokenGenerator() {
        try {
            this.random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public String generateCode(AuthenticatedUser user) {
        StringBuilder raw = new StringBuilder(this.generate(20));
        raw.append('|').append(System.currentTimeMillis());
        String code = raw.toString();
        user.setCode(code);
        return code;
    }

    public Token generateToken(AuthenticatedUser user, long expire) {
        long individualExp = user.getTokenExpire();
        if (individualExp > 0L) {
            expire = individualExp;
        }
        expire = expire <= this.maxTokenTimeSec ? expire : this.maxTokenTimeSec;
        StringBuilder raw = new StringBuilder(this.generate(40));
        String token = raw.toString();
        Token t = null;
        t = expire != 0L ? new ExpireToken(token, expire, this.generate(20), user) : new UnlimitedToken(token, user);
        return t;
    }

    public long expiresInSec(Token token) {
        ExpireToken et;
        ScheduledFuture<?> sf;
        if (token instanceof ExpireToken && (sf = (et = (ExpireToken)token).getFuture()) != null) {
            return sf.getDelay(TimeUnit.SECONDS);
        }
        return Long.MAX_VALUE;
    }

    public void setMaxTokenTime(long maxTokenTimeSec) {
        this.maxTokenTimeSec = maxTokenTimeSec;
    }

    public void refreshToken(ExpireToken token) {
        this.revokeToken(token);
        token.expireToken();
        String newToken = this.generate(20);
        token.setToken(newToken);
    }

    public abstract Token exchangeForToken(String var1, long var2) throws IllegalArgumentException;

    public abstract void revokeToken(Token var1);

    public abstract void revokeExpireToken(ExpireToken var1);

    public abstract Token findToken(String var1);

    protected String generate(int len) {
        if (this.count++ > 1000) {
            this.count = 0;
            this.random.setSeed(this.random.generateSeed(20));
        }
        byte[] token = new byte[len];
        this.random.nextBytes(token);
        return this.toHex(token);
    }

    protected String toHex(byte[] input) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < input.length; ++i) {
            String d = Integer.toHexString(new Byte(input[i]).intValue() & 0xFF);
            if (d.length() == 1) {
                sb.append('0');
            }
            sb.append(d);
        }
        return sb.toString();
    }
}

