/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth;

import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Form;
import org.restlet.ext.oauth.Client;
import org.restlet.ext.oauth.ClientStore;
import org.restlet.ext.oauth.ClientStoreFactory;
import org.restlet.ext.oauth.OAuthError;
import org.restlet.ext.oauth.OAuthException;
import org.restlet.ext.oauth.OAuthServerResource;
import org.restlet.security.SecretVerifier;
import org.restlet.security.User;
import org.restlet.security.Verifier;

public class ClientVerifier
implements Verifier {
    private ClientStore<?> clients = ClientStoreFactory.getInstance();
    private boolean acceptBodyMethod = false;

    public int verify(Request request, Response response) {
        char[] clientSecret;
        String clientId;
        ChallengeResponse cr = request.getChallengeResponse();
        if (cr == null) {
            if (!this.isAcceptBodyMethod()) {
                return 0;
            }
            Form params = new Form(request.getEntity());
            clientId = params.getFirstValue("client_id");
            if (clientId == null || clientId.isEmpty()) {
                return 0;
            }
            String s = params.getFirstValue("client_secret");
            clientSecret = s == null || s.isEmpty() ? new char[]{} : s.toCharArray();
            request.setEntity(params.getWebRepresentation());
        } else {
            if (!cr.getScheme().equals((Object)ChallengeScheme.HTTP_BASIC)) {
                return 3;
            }
            clientId = cr.getIdentifier();
            clientSecret = cr.getSecret();
        }
        int result = this.verify(clientId, clientSecret);
        if (result == 4) {
            request.getClientInfo().setUser(new User(clientId));
        } else {
            response.setEntity(OAuthServerResource.responseErrorRepresentation(new OAuthException(OAuthError.invalid_client, "Invalid client", null)));
        }
        return result;
    }

    private int verify(String clientId, char[] clientSecret) {
        Client client = this.clients.findById(clientId);
        if (client == null) {
            return 5;
        }
        char[] s = client.getClientSecret().toCharArray();
        if (!SecretVerifier.compare((char[])s, (char[])clientSecret)) {
            return -1;
        }
        return 4;
    }

    public boolean isAcceptBodyMethod() {
        return this.acceptBodyMethod;
    }

    public void setAcceptBodyMethod(boolean acceptBodyMethod) {
        this.acceptBodyMethod = acceptBodyMethod;
    }
}

