/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth;

import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.Response;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Preference;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.ext.oauth.OAuthException;
import org.restlet.ext.oauth.OAuthParameters;
import org.restlet.ext.oauth.OAuthResourceDefs;
import org.restlet.ext.oauth.internal.Scopes;
import org.restlet.ext.oauth.internal.Token;
import org.restlet.representation.Representation;
import org.restlet.resource.ClientResource;

public class AccessTokenClientResource
extends ClientResource
implements OAuthResourceDefs {
    private String clientId;
    private String clientSecret;
    private ChallengeScheme authenticationScheme = ChallengeScheme.HTTP_BASIC;

    public AccessTokenClientResource(Reference tokenURI) {
        super(tokenURI);
    }

    public void doError(Status errorStatus) {
        Representation representation = this.getResponse().getEntity();
        if (representation.getMediaType().equals((Object)MediaType.APPLICATION_JSON)) {
            this.getLogger().fine("OAuth response is found.");
            return;
        }
        super.doError(errorStatus);
    }

    public Representation handleInbound(Response response) {
        Representation result = null;
        if (response.getRequest().isSynchronous()) {
            if (response.getStatus().isError()) {
                this.doError(response.getStatus());
            }
            result = response == null ? null : response.getEntity();
        }
        return result;
    }

    public void setClientCredentials(String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public void setAuthenticationMethod(ChallengeScheme scheme) {
        this.authenticationScheme = scheme;
    }

    protected void setupBodyClientCredentials(OAuthParameters parameters) {
        parameters.add("client_id", this.clientId);
        if (this.clientSecret != null) {
            parameters.add("client_secret", this.clientSecret);
        }
    }

    public Token requestToken(OAuthParameters parameters) throws OAuthException, IOException, JSONException {
        if (this.authenticationScheme == null) {
            this.setupBodyClientCredentials(parameters);
        } else {
            this.setChallengeResponse(this.authenticationScheme, this.clientId, this.clientSecret);
        }
        Representation input = parameters.toRepresentation();
        this.getClientInfo().getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.APPLICATION_JSON));
        JSONObject result = new JsonRepresentation(this.post(input)).getJsonObject();
        if (result.has("error")) {
            throw OAuthException.toOAuthException(result);
        }
        TokenResponse token = TokenResponse.parseResponse(result);
        if (token.scope == null) {
            TokenResponse.access$002(token, Scopes.parseScope(parameters.toForm().getFirstValue("scope")));
        }
        return token;
    }

    private static class TokenResponse
    implements Token {
        private String accessToken;
        private String tokenType;
        private Integer expirePeriod;
        private String refreshToken;
        private String[] scope;

        private TokenResponse() {
        }

        public static TokenResponse parseResponse(JSONObject result) throws JSONException {
            TokenResponse token = new TokenResponse();
            token.accessToken = result.getString("access_token");
            token.tokenType = result.getString("token_type");
            if (result.has("expires_in")) {
                token.expirePeriod = result.getInt("expires_in");
            }
            if (result.has("refresh_token")) {
                token.refreshToken = result.getString("refresh_token");
            }
            if (result.has("scope")) {
                token.scope = Scopes.parseScope(result.getString("scope"));
            }
            return token;
        }

        @Override
        public String getAccessToken() {
            return this.accessToken;
        }

        @Override
        public String getTokenType() {
            return this.tokenType;
        }

        public boolean isExpirePeriodAvailable() {
            return this.expirePeriod != null;
        }

        @Override
        public int getExpirePeriod() {
            if (this.expirePeriod == null) {
                throw new IllegalStateException("expires_in not included.");
            }
            return this.expirePeriod;
        }

        @Override
        public String getRefreshToken() {
            return this.refreshToken;
        }

        @Override
        public String[] getScope() {
            return this.scope;
        }

        static /* synthetic */ String[] access$002(TokenResponse x0, String[] x1) {
            x0.scope = x1;
            return x1;
        }
    }
}

