/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth;

import org.restlet.data.Form;
import org.restlet.data.Reference;
import org.restlet.ext.oauth.AccessTokenClientResource;
import org.restlet.ext.oauth.OAuthException;
import org.restlet.ext.oauth.OAuthParameters;
import org.restlet.ext.oauth.internal.Token;
import org.restlet.representation.Representation;

public class FacebookAccessTokenClientResource
extends AccessTokenClientResource {
    public FacebookAccessTokenClientResource(Reference tokenURI) {
        super(tokenURI);
    }

    @Override
    public Token requestToken(OAuthParameters parameters) throws OAuthException {
        this.setupBodyClientCredentials(parameters);
        Representation input = parameters.toRepresentation();
        Form result = new Form(this.post(input));
        if (result.getFirstValue("error") != null) {
            throw OAuthException.toOAuthException(result);
        }
        return FacebookTokenResponse.parseResponse(result);
    }

    private static class FacebookTokenResponse
    implements Token {
        private String accessToken;
        private Integer expirePeriod;

        private FacebookTokenResponse() {
        }

        public static FacebookTokenResponse parseResponse(Form result) {
            FacebookTokenResponse token = new FacebookTokenResponse();
            token.accessToken = result.getFirstValue("access_token");
            token.expirePeriod = Integer.parseInt(result.getFirstValue("expires"));
            return token;
        }

        @Override
        public String getAccessToken() {
            return this.accessToken;
        }

        @Override
        public String getTokenType() {
            return "Bearer";
        }

        @Override
        public int getExpirePeriod() {
            return this.expirePeriod;
        }

        @Override
        public String getRefreshToken() {
            return null;
        }

        @Override
        public String[] getScope() {
            return null;
        }
    }
}

