/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.oauth.internal.memory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.restlet.ext.oauth.OAuthError;
import org.restlet.ext.oauth.OAuthException;
import org.restlet.ext.oauth.internal.AbstractTokenManager;
import org.restlet.ext.oauth.internal.AuthSession;
import org.restlet.ext.oauth.internal.Client;
import org.restlet.ext.oauth.internal.Token;
import org.restlet.ext.oauth.internal.memory.MemoryToken;

public class MemoryTokenManager
extends AbstractTokenManager {
    private final Map<String, MemoryToken> tokens = new ConcurrentHashMap<String, MemoryToken>();
    private final Map<String, AuthSession> sessions = new ConcurrentHashMap<String, AuthSession>();

    @Override
    public Token generateToken(Client client, String username, String[] scope) throws OAuthException {
        this.revokeToken(client, username);
        MemoryToken token = new MemoryToken();
        token.setClientId(client.getClientId());
        token.setUsername(username);
        token.setScope(scope);
        token.setExpirePeriod(this.getExpirePeriod());
        token.setTokenType("Bearer");
        token.setAccessToken(this.generateRawToken());
        token.setRefreshToken(this.generateRawToken());
        this.tokens.put(token.getAccessToken(), token);
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token refreshToken(Client client, String refreshToken, String[] scope) throws OAuthException {
        String[] newScope;
        MemoryToken token = this.findTokenByRefreshToken(refreshToken);
        if (token == null) {
            throw new OAuthException(OAuthError.invalid_grant, "Invalid refresh token.", null);
        }
        if (!token.getClientId().equals(client.getClientId())) {
            throw new OAuthException(OAuthError.invalid_grant, "The refresh token was not issued to the client.", null);
        }
        if (scope == null || scope.length == 0) {
            newScope = token.getScope();
        } else {
            String[] previousScope = token.getScope();
            if (!Arrays.asList(previousScope).containsAll(Arrays.asList(scope))) {
                throw new OAuthException(OAuthError.invalid_scope, "The requested scope is exceeds the scope granted by the resource owner.", null);
            }
            newScope = scope;
        }
        MemoryToken newToken = new MemoryToken();
        newToken.setClientId(client.getClientId());
        newToken.setUsername(token.getUsername());
        newToken.setScope(newScope);
        newToken.setExpirePeriod(token.getExpirePeriod());
        newToken.setTokenType("Bearer");
        newToken.setAccessToken(this.generateRawToken());
        if (this.isUpdateRefreshToken()) {
            newToken.setRefreshToken(this.generateRawToken());
        } else {
            newToken.setRefreshToken(token.getRefreshToken());
        }
        MemoryTokenManager memoryTokenManager = this;
        synchronized (memoryTokenManager) {
            if (this.tokens.remove(token.getAccessToken()) != null) {
                this.tokens.put(newToken.getAccessToken(), newToken);
                return newToken;
            }
        }
        return null;
    }

    @Override
    public String storeSession(AuthSession session) throws OAuthException {
        String code = this.generateRawCode();
        this.sessions.put(code, session);
        return code;
    }

    @Override
    public AuthSession restoreSession(String code) throws OAuthException {
        AuthSession session = this.sessions.remove(code);
        if (session == null) {
            throw new OAuthException(OAuthError.invalid_grant, "Invalid code.", null);
        }
        return session;
    }

    @Override
    public Token validateToken(String accessToken) throws OAuthException {
        MemoryToken token = this.tokens.get(accessToken);
        if (token == null) {
            throw new OAuthException(OAuthError.invalid_token, "The access token revoked.", null);
        }
        if (token.isExpired()) {
            throw new OAuthException(OAuthError.invalid_token, "The access token expired.", null);
        }
        return token;
    }

    @Override
    public Token findToken(Client client, String username) {
        for (MemoryToken token : this.tokens.values()) {
            if (!token.getClientId().equals(client.getClientId()) || (username != null || token.getUsername() != null) && (username == null || !username.equals(token.getUsername()))) continue;
            return token;
        }
        return null;
    }

    protected MemoryToken findTokenByRefreshToken(String refreshToken) {
        for (MemoryToken token : this.tokens.values()) {
            if (!token.getRefreshToken().equals(refreshToken)) continue;
            return token;
        }
        return null;
    }

    @Override
    public Token[] findTokens(String username) {
        ArrayList<MemoryToken> list = new ArrayList<MemoryToken>();
        for (MemoryToken token : this.tokens.values()) {
            if (token.getUsername() == null || !token.getUsername().equals(username)) continue;
            list.add(token);
        }
        return list.toArray(new Token[list.size()]);
    }

    @Override
    public Token[] findTokens(Client client) {
        ArrayList<MemoryToken> list = new ArrayList<MemoryToken>();
        for (MemoryToken token : this.tokens.values()) {
            if (!token.getClientId().equals(client.getClientId())) continue;
            list.add(token);
        }
        return list.toArray(new Token[list.size()]);
    }

    @Override
    public void revokeToken(Client client, String username) {
        Token token = this.findToken(client, username);
        if (token != null) {
            this.tokens.remove(token.getAccessToken());
        }
    }

    @Override
    public void revokeAllTokens(String username) {
        for (Token token : this.findTokens(username)) {
            this.tokens.remove(token.getAccessToken());
        }
    }

    @Override
    public void revokeAllTokens(Client client) {
        for (Token token : this.findTokens(client)) {
            this.tokens.remove(token.getAccessToken());
        }
    }
}

