/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.rome;

import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.SyndFeedOutput;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.representation.WriterRepresentation;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyndFeedRepresentation
extends WriterRepresentation {
    private volatile SyndFeed feed;

    public static MediaType getMediaType(String feedType) {
        MediaType result = null;
        if (feedType != null) {
            result = feedType.startsWith("atom") ? MediaType.APPLICATION_ATOM : MediaType.APPLICATION_RSS;
        }
        return result;
    }

    public SyndFeedRepresentation() {
        this("rss_2.0");
    }

    public SyndFeedRepresentation(Representation feedRepresentation) throws IOException {
        super(null);
        InputSource source = new InputSource(feedRepresentation.getStream());
        try {
            this.feed = new SyndFeedInput().build(source);
        }
        catch (IllegalArgumentException e) {
            IOException ioe = new IOException("Couldn't read the feed representation. " + e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        catch (FeedException e) {
            IOException ioe = new IOException("Couldn't read the feed representation. " + e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        this.setMediaType(SyndFeedRepresentation.getMediaType(this.feed.getFeedType()));
    }

    public SyndFeedRepresentation(String feedType) {
        this(feedType, CharacterSet.UTF_8);
    }

    public SyndFeedRepresentation(String feedType, CharacterSet characterSet) {
        this(feedType, new ArrayList(), characterSet);
    }

    public SyndFeedRepresentation(String feedType, List<?> entries, CharacterSet characterSet) {
        super(SyndFeedRepresentation.getMediaType(feedType));
        this.setCharacterSet(characterSet);
        this.feed = new SyndFeedImpl();
        this.feed.setFeedType(feedType);
        this.feed.setEntries(entries);
    }

    public SyndFeedRepresentation(SyndFeed feed) {
        super(SyndFeedRepresentation.getMediaType(feed.getFeedType()));
        this.feed = feed;
    }

    public SyndFeed getFeed() {
        return this.feed;
    }

    public void write(Writer writer) throws IOException {
        try {
            SyndFeedOutput output = new SyndFeedOutput();
            if (this.feed.getFeedType() == null) {
                this.feed.setFeedType("atom_1.0");
            }
            output.output(this.feed, writer);
        }
        catch (FeedException e) {
            IOException ioe = new IOException("Feed exception");
            ioe.initCause(e);
            throw ioe;
        }
    }
}

