/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.simple.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.restlet.Response;
import org.restlet.Server;
import org.restlet.data.Parameter;
import org.restlet.engine.http.ServerCall;
import org.restlet.util.Series;
import org.simpleframework.http.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCall
extends ServerCall {
    private final Request request;
    private final org.simpleframework.http.Response response;
    private volatile boolean requestHeadersAdded;
    private final String version;

    SimpleCall(Server server, Request request, org.simpleframework.http.Response response, boolean confidential) {
        super(server);
        this.version = request.getMajor() + "." + request.getMinor();
        this.request = request;
        this.response = response;
        this.setConfidential(confidential);
        this.requestHeadersAdded = false;
    }

    protected boolean isClientKeepAlive() {
        return this.request.isKeepAlive();
    }

    protected long getContentLength() {
        return this.request.getContentLength();
    }

    public void complete() {
        try {
            this.response.commit();
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, "Unable to commit the response", ex);
        }
    }

    public String getHostDomain() {
        return super.getHostDomain();
    }

    public String getClientAddress() {
        return this.request.getClientAddress().getAddress().getHostAddress();
    }

    public int getClientPort() {
        SocketChannel socket = this.getSocket();
        return socket != null ? socket.socket().getPort() : -1;
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public ReadableByteChannel getRequestEntityChannel(long size) {
        return null;
    }

    public InputStream getRequestEntityStream(long size) {
        try {
            return this.request.getInputStream();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public ReadableByteChannel getRequestHeadChannel() {
        return null;
    }

    public Series<Parameter> getRequestHeaders() {
        Series result = super.getRequestHeaders();
        if (!this.requestHeadersAdded) {
            List names = this.request.getNames();
            for (String name : names) {
                for (String value : this.request.getValues(name)) {
                    result.add((Object)new Parameter(name, value));
                }
            }
            this.requestHeadersAdded = true;
        }
        return result;
    }

    public InputStream getRequestHeadStream() {
        return null;
    }

    public String getRequestUri() {
        return this.request.getTarget();
    }

    public WritableByteChannel getResponseEntityChannel() {
        try {
            return this.response.getByteChannel();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public OutputStream getResponseEntityStream() {
        try {
            return this.response.getOutputStream();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private SocketChannel getSocket() {
        return (SocketChannel)this.request.getAttribute((Object)"org.restlet.ext.simple.socket");
    }

    private SSLEngine getSslEngine() {
        return (SSLEngine)this.request.getAttribute((Object)"org.restlet.ext.simple.engine");
    }

    public String getSslCipherSuite() {
        SSLSession sslSession;
        SSLEngine sslEngine = this.getSslEngine();
        if (sslEngine != null && (sslSession = sslEngine.getSession()) != null) {
            return sslSession.getCipherSuite();
        }
        return null;
    }

    public List<Certificate> getSslClientCertificates() {
        SSLSession sslSession;
        SSLEngine sslEngine = this.getSslEngine();
        if (sslEngine != null && (sslSession = sslEngine.getSession()) != null) {
            try {
                List<Certificate> clientCertificates = Arrays.asList(sslSession.getPeerCertificates());
                return clientCertificates;
            }
            catch (SSLPeerUnverifiedException e) {
                this.getLogger().log(Level.FINE, "Can't get the client certificates.", e);
            }
        }
        return null;
    }

    public String getVersion() {
        return this.version;
    }

    public void writeResponseHead(Response restletResponse) throws IOException {
        for (Parameter header : this.getResponseHeaders()) {
            this.response.add(header.getName(), header.getValue());
        }
        this.response.setCode(this.getStatusCode());
        this.response.setText(this.getReasonPhrase());
        if (restletResponse.getEntity() == null) {
            this.response.setContentLength(0);
        }
    }
}

