/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.sip.internal;

import java.util.ArrayList;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Server;
import org.restlet.data.Protocol;
import org.restlet.data.RecipientInfo;
import org.restlet.engine.connector.Connection;
import org.restlet.engine.connector.OutboundWay;
import org.restlet.engine.connector.ServerConnectionHelper;
import org.restlet.engine.connector.ServerInboundWay;
import org.restlet.ext.sip.internal.SipInboundRequest;
import org.restlet.ext.sip.internal.SipServerInboundWay;
import org.restlet.ext.sip.internal.SipServerOutboundWay;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipServerHelper
extends ServerConnectionHelper {
    public SipServerHelper(Server server) {
        super(server);
        this.getProtocols().add(Protocol.SIP);
    }

    protected boolean canHandle(Connection<Server> connection, Response response) {
        return connection.getOutboundWay().getMessage() == null;
    }

    public ServerInboundWay createInboundWay(Connection<Server> connection, int bufferSize) {
        return new SipServerInboundWay(connection, bufferSize);
    }

    public OutboundWay createOutboundWay(Connection<Server> connection, int bufferSize) {
        return new SipServerOutboundWay(connection, bufferSize);
    }

    protected Request createRequest(Connection<Server> connection, String methodName, String resourceUri, String protocol) {
        SipInboundRequest request = new SipInboundRequest(this.getContext(), connection, methodName, resourceUri, protocol);
        request.setRecipientsInfo(new ArrayList<RecipientInfo>());
        return request;
    }

    public boolean isPipeliningConnections() {
        return true;
    }
}

