/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.spring;

import org.restlet.ext.spring.SpringFinder;
import org.restlet.resource.Resource;
import org.restlet.resource.ServerResource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringBeanFinder
extends SpringFinder
implements BeanFactoryAware,
ApplicationContextAware {
    private volatile ApplicationContext applicationContext;
    private volatile BeanFactory beanFactory;
    private volatile String beanName;

    public SpringBeanFinder() {
    }

    public SpringBeanFinder(BeanFactory beanFactory, String beanName) {
        this.setBeanFactory(beanFactory);
        this.setBeanName(beanName);
    }

    public ServerResource create() {
        Object resource = this.findBean();
        if (!(resource instanceof ServerResource)) {
            throw new ClassCastException(this.getBeanName() + " does not resolve to an instance of " + ServerResource.class.getName());
        }
        return (ServerResource)resource;
    }

    public Resource createResource() {
        Object resource = this.findBean();
        if (!(resource instanceof Resource)) {
            throw new ClassCastException(this.getBeanName() + " does not resolve to an instance of " + Resource.class.getName());
        }
        return (Resource)resource;
    }

    private Object findBean() {
        if (this.getApplicationContext() != null && this.getApplicationContext().containsBean(this.getBeanName())) {
            return this.getApplicationContext().getBean(this.getBeanName());
        }
        if (this.getBeanFactory() != null && this.getBeanFactory().containsBean(this.getBeanName())) {
            return this.getBeanFactory().getBean(this.getBeanName());
        }
        throw new IllegalStateException("Either a beanFactory or an applicationContext is required for SpringBeanFinder.");
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }
}

