/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.wadl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.engine.resource.AnnotationInfo;
import org.restlet.engine.resource.AnnotationUtils;
import org.restlet.ext.wadl.DocumentationInfo;
import org.restlet.ext.wadl.MethodInfo;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.ParameterStyle;
import org.restlet.ext.wadl.RequestInfo;
import org.restlet.ext.wadl.ResourceInfo;
import org.restlet.ext.wadl.ResponseInfo;
import org.restlet.ext.wadl.WadlRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;
import org.restlet.service.MetadataService;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WadlServerResource
extends ServerResource {
    private volatile boolean autoDescribed = true;
    private volatile String title;

    protected Representation describe() {
        return this.describe(this.getPreferredWadlVariant());
    }

    private void describe(ResourceInfo info) {
        this.describe(this.getResourcePath(), info);
    }

    public void describe(String path, ResourceInfo info) {
        info.setPath(path);
        ArrayList methodsList = new ArrayList();
        methodsList.addAll(this.getAllowedMethods());
        Collections.sort(methodsList, new Comparator<Method>(){

            @Override
            public int compare(Method m1, Method m2) {
                return m1.getName().compareTo(m2.getName());
            }
        });
        List<MethodInfo> methods = info.getMethods();
        for (Method method : methodsList) {
            if (!this.isDescribable(method)) continue;
            MethodInfo methodInfo = new MethodInfo();
            this.describeMethod(method, methodInfo);
            methods.add(methodInfo);
        }
        info.setParameters(this.getParametersInfo());
    }

    protected Representation describe(Variant variant) {
        WadlRepresentation result = null;
        if (variant != null) {
            ResourceInfo resourceInfo = new ResourceInfo();
            this.describe(resourceInfo);
            if (this.getTitle() != null && !"".equals(this.getTitle())) {
                DocumentationInfo doc = null;
                if (resourceInfo.getDocumentations().isEmpty()) {
                    doc = new DocumentationInfo();
                    resourceInfo.getDocumentations().add(doc);
                } else {
                    doc = resourceInfo.getDocumentations().get(0);
                }
                doc.setTitle(this.getTitle());
            }
            if (MediaType.APPLICATION_WADL.equals((Object)variant.getMediaType())) {
                result = new WadlRepresentation(resourceInfo);
            } else if (MediaType.TEXT_HTML.equals((Object)variant.getMediaType())) {
                result = new WadlRepresentation(resourceInfo).getHtmlRepresentation();
            }
        }
        return result;
    }

    protected void describeDelete(MethodInfo info) {
        this.discoverAnnotations(info);
    }

    protected void describeGet(MethodInfo info) {
        if (this.getVariants() != null) {
            for (Variant variant : this.getVariants()) {
                info.addResponseRepresentation(variant);
            }
        }
    }

    protected MethodInfo describeMethod() {
        MethodInfo result = new MethodInfo();
        this.describeMethod(this.getMethod(), result);
        return result;
    }

    protected void describeMethod(Method method, MethodInfo info) {
        info.setName(method);
        info.setRequest(new RequestInfo());
        if (Method.GET.equals((Object)method)) {
            this.describeGet(info);
        } else if (Method.POST.equals((Object)method)) {
            this.describePost(info);
        } else if (Method.PUT.equals((Object)method)) {
            this.describePut(info);
        } else if (Method.DELETE.equals((Object)method)) {
            this.describeDelete(info);
        } else if (Method.OPTIONS.equals((Object)method)) {
            this.describeOptions(info);
        }
    }

    protected void describeOptions(MethodInfo info) {
        for (Variant variant : this.getWadlVariants()) {
            info.addResponseRepresentation(variant);
        }
    }

    protected void describePost(MethodInfo info) {
        this.discoverAnnotations(info);
    }

    protected void describePut(MethodInfo info) {
        this.discoverAnnotations(info);
    }

    private void discoverAnnotations(MethodInfo info) {
        ResponseInfo response = info.getResponse();
        MetadataService metadataService = this.getMetadataService();
        List<AnnotationInfo> annotations = this.getAnnotations();
        if (annotations != null && metadataService != null) {
            for (AnnotationInfo annotationInfo : annotations) {
                List variants;
                if (!info.getName().equals((Object)annotationInfo.getRestletMethod())) continue;
                Class[] classes = annotationInfo.getJavaInputTypes();
                if (classes != null && classes.length == 1 && (variants = this.getApplication().getConverterService().getVariants(classes[0], null)) != null) {
                    for (Variant variant : variants) {
                        if (info.getRequest().getRepresentations().contains(variant)) continue;
                        info.addRequestRepresentation(variant);
                    }
                }
                if (annotationInfo.getJavaOutputType() == null || (variants = this.getApplication().getConverterService().getVariants(annotationInfo.getJavaOutputType(), null)) == null) continue;
                for (Variant variant : variants) {
                    if (response.getRepresentations().contains(variant)) continue;
                    info.addResponseRepresentation(variant);
                }
            }
        }
    }

    protected void doInit() throws ResourceException {
        super.doInit();
        this.autoDescribed = true;
    }

    private List<AnnotationInfo> getAnnotations() {
        return this.isAnnotated() ? AnnotationUtils.getAnnotations(((Object)((Object)this)).getClass()) : null;
    }

    private Form getHeader() {
        return (Form)this.getRequestAttributes().get("org.restlet.http.headers");
    }

    protected Parameter getParameter(String name) {
        Parameter result = null;
        Series<Parameter> set = this.getParameters(name);
        if (set != null) {
            result = set.getFirst(name);
        }
        return result;
    }

    private Series<Parameter> getParameters(ParameterInfo parameterInfo) {
        Form result = null;
        if (parameterInfo.getFixed() != null) {
            result = new Form();
            result.add(parameterInfo.getName(), parameterInfo.getFixed());
        } else if (ParameterStyle.HEADER.equals((Object)parameterInfo.getStyle())) {
            result = this.getHeader().subList(parameterInfo.getName());
        } else if (ParameterStyle.TEMPLATE.equals((Object)parameterInfo.getStyle())) {
            Object parameter = this.getRequest().getAttributes().get(parameterInfo.getName());
            if (parameter != null) {
                result = new Form();
                result.add(parameterInfo.getName(), Reference.decode((String)((String)parameter)));
            }
        } else if (ParameterStyle.MATRIX.equals((Object)parameterInfo.getStyle())) {
            result = this.getMatrix().subList(parameterInfo.getName());
        } else if (ParameterStyle.QUERY.equals((Object)parameterInfo.getStyle())) {
            result = this.getQuery().subList(parameterInfo.getName());
        } else if (ParameterStyle.PLAIN.equals((Object)parameterInfo.getStyle())) {
            // empty if block
        }
        if (result == null && parameterInfo.getDefaultValue() != null) {
            result = new Form();
            result.add(parameterInfo.getName(), parameterInfo.getDefaultValue());
        }
        return result;
    }

    protected Series<Parameter> getParameters(String name) {
        Series<Parameter> result = null;
        if (this.getParametersInfo() != null) {
            for (ParameterInfo parameter : this.getParametersInfo()) {
                if (!name.equals(parameter.getName())) continue;
                result = this.getParameters(parameter);
            }
        }
        return result;
    }

    protected List<ParameterInfo> getParametersInfo() {
        return null;
    }

    protected Variant getPreferredWadlVariant() {
        Variant result = null;
        result = this.getRequest().getClientInfo().getPreferredVariant(this.getWadlVariants(), this.getApplication() == null ? null : this.getApplication().getMetadataService());
        return result;
    }

    protected String getResourcePath() {
        Reference ref = new Reference(this.getRequest().getRootRef(), this.getRequest().getResourceRef());
        return ref.getRemainingPart();
    }

    protected Reference getResourcesBase() {
        return this.getRequest().getRootRef();
    }

    public String getTitle() {
        return this.title;
    }

    protected List<Variant> getWadlVariants() {
        ArrayList<Variant> result = new ArrayList<Variant>();
        result.add(new Variant(MediaType.APPLICATION_WADL));
        result.add(new Variant(MediaType.TEXT_HTML));
        return result;
    }

    public boolean isAutoDescribed() {
        return this.autoDescribed;
    }

    public boolean isDescribable(Method method) {
        return !Method.HEAD.equals((Object)method) && !Method.OPTIONS.equals((Object)method);
    }

    public Representation options() {
        if (this.isAutoDescribed()) {
            return this.describe();
        }
        return null;
    }

    public void setAutoDescribed(boolean autoDescribed) {
        this.autoDescribed = autoDescribed;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

