/*
 * Decompiled with CFR 0.152.
 */
package com.db4o;

import com.db4o.P1Collection;
import com.db4o.P1HashElement;
import com.db4o.P1ListElement;
import com.db4o.P2HashMapIterator;
import com.db4o.P2HashMapKeySet;
import com.db4o.TransactionListener;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.NotImplementedException;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.Transaction;
import com.db4o.types.Db4oMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class P2HashMap
extends P1Collection
implements Db4oMap,
TransactionListener {
    private static final float FILL = 0.6f;
    private transient int i_changes;
    private transient boolean i_dontStoreOnDeactivate;
    public P1HashElement[] i_entries;
    public int i_mask;
    public int i_maximumSize;
    public int i_size;
    public int i_type;
    transient P1HashElement[] i_table;
    public int i_tableSize;

    P2HashMap() {
    }

    P2HashMap(int a_size) {
        a_size = (int)((float)a_size / 0.6f);
        this.i_tableSize = 1;
        while (this.i_tableSize < a_size) {
            this.i_tableSize <<= 1;
        }
        this.i_mask = this.i_tableSize - 1;
        this.i_maximumSize = (int)((float)this.i_tableSize * 0.6f);
        this.i_table = new P1HashElement[this.i_tableSize];
    }

    public void checkActive() {
        super.checkActive();
        if (this.i_table == null) {
            this.i_table = new P1HashElement[this.i_tableSize];
            if (this.i_entries != null) {
                for (int i = 0; i < this.i_entries.length; ++i) {
                    if (this.i_entries[i] == null) continue;
                    this.i_entries[i].checkActive();
                    this.i_table[this.i_entries[i].i_position] = this.i_entries[i];
                }
            }
            this.i_changes = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.streamLock();
        synchronized (object) {
            this.checkActive();
            if (this.i_size != 0) {
                int i;
                for (i = 0; i < this.i_table.length; ++i) {
                    this.deleteAllElements(this.i_table[i]);
                    this.i_table[i] = null;
                }
                if (this.i_entries != null) {
                    for (i = 0; i < this.i_entries.length; ++i) {
                        this.i_entries[i] = null;
                    }
                }
                this.i_size = 0;
                this.modified();
            }
        }
    }

    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    public Object createDefault(Transaction a_trans) {
        this.checkActive();
        P2HashMap m4 = new P2HashMap(this.i_size);
        m4.i_type = this.i_type;
        m4.setTrans(a_trans);
        P2HashMapIterator i = new P2HashMapIterator(this);
        while (i.hasNext()) {
            Object key = i.next();
            if (key == null) continue;
            m4.put4(key, this.get4(key));
        }
        return m4;
    }

    private void deleteAllElements(P1HashElement a_entry) {
        if (a_entry != null) {
            a_entry.checkActive();
            this.deleteAllElements((P1HashElement)a_entry.i_next);
            a_entry.delete(this.i_deleteRemoved);
        }
    }

    public Set entrySet() {
        HashSet<MapEntry> out = new HashSet<MapEntry>(this.size());
        for (Object key : this.keySet()) {
            Object value = this.get(key);
            MapEntry entry = new MapEntry(key);
            entry.setValue(value);
            out.add(entry);
        }
        return out;
    }

    private boolean equals(P1HashElement phe, int hashCode, Object key) {
        return phe.i_hashCode == hashCode && phe.activatedKey(this.elementActivationDepth()).equals(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        Object object = this.streamLock();
        synchronized (object) {
            this.checkActive();
            return this.get4(key);
        }
    }

    Object get4(Object key) {
        if (key == null) {
            return null;
        }
        int hash = this.hashOf(key);
        P1HashElement phe = this.i_table[hash & this.i_mask];
        while (phe != null) {
            phe.checkActive();
            if (this.equals(phe, hash, key)) {
                return phe.activatedObject(this.elementActivationDepth());
            }
            phe = (P1HashElement)phe.i_next;
        }
        return null;
    }

    private int hashOf(Object key) {
        if (this.i_type == 1) {
            int id = (int)this.getIDOf(key);
            if (id == 0) {
                this.store(key);
            }
            if ((id = (int)this.getIDOf(key)) == 0) {
                Exceptions4.throwRuntimeException(62);
            }
            return id;
        }
        return key.hashCode();
    }

    private void increaseSize() {
        this.i_tableSize <<= 1;
        this.i_maximumSize = (int)((float)this.i_tableSize * 0.6f);
        this.i_mask = this.i_tableSize - 1;
        P1HashElement[] temp = this.i_table;
        this.i_table = new P1HashElement[this.i_tableSize];
        for (int i = 0; i < temp.length; ++i) {
            this.reposition(temp[i]);
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new P2HashMapKeySet(this);
    }

    void modified() {
        if (this.getTrans() != null) {
            if (this.i_changes == 0) {
                this.getTrans().addTransactionListener(this);
            }
            ++this.i_changes;
        }
    }

    public void postRollback() {
        this.i_dontStoreOnDeactivate = true;
        this.deactivate();
        this.i_dontStoreOnDeactivate = false;
    }

    public void preCommit() {
        if (this.i_changes > 0) {
            int i;
            Collection4 col = new Collection4();
            for (i = 0; i < this.i_table.length; ++i) {
                if (this.i_table[i] == null) continue;
                this.i_table[i].checkActive();
                if (this.i_table[i].i_position != i) {
                    this.i_table[i].i_position = i;
                    this.i_table[i].update();
                }
                col.add(this.i_table[i]);
            }
            if (this.i_entries == null || this.i_entries.length != col.size()) {
                this.i_entries = new P1HashElement[col.size()];
            }
            i = 0;
            Iterator4 it = col.iterator();
            while (it.moveNext()) {
                this.i_entries[i++] = (P1HashElement)it.current();
            }
            this.store(2);
        }
        this.i_changes = 0;
    }

    public void preDeactivate() {
        if (!this.i_dontStoreOnDeactivate) {
            this.preCommit();
        }
        this.i_table = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        Object object = this.streamLock();
        synchronized (object) {
            this.checkActive();
            return this.put4(key, value);
        }
    }

    private Object put4(Object key, Object value) {
        int hash = this.hashOf(key);
        P1HashElement entry = new P1HashElement(this.getTrans(), null, key, hash, value);
        ++this.i_size;
        if (this.i_size > this.i_maximumSize) {
            this.increaseSize();
        }
        this.modified();
        int index = entry.i_hashCode & this.i_mask;
        P1HashElement phe = this.i_table[index];
        P1HashElement last = null;
        while (phe != null) {
            phe.checkActive();
            if (this.equals(phe, entry.i_hashCode, key)) {
                --this.i_size;
                Object ret = phe.activatedObject(this.elementActivationDepth());
                entry.i_next = phe.i_next;
                this.store(entry);
                if (last != null) {
                    last.i_next = entry;
                    last.update();
                } else {
                    this.i_table[index] = entry;
                }
                phe.delete(this.i_deleteRemoved);
                return ret;
            }
            last = phe;
            phe = (P1HashElement)phe.i_next;
        }
        entry.i_next = this.i_table[index];
        this.i_table[index] = entry;
        this.store(entry);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map t) {
        Object object = this.streamLock();
        synchronized (object) {
            this.checkActive();
            for (Object key : t.keySet()) {
                if (key == null) continue;
                this.put4(key, t.get(key));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        Object object = this.streamLock();
        synchronized (object) {
            this.checkActive();
            return this.remove4(key);
        }
    }

    Object remove4(Object key) {
        int hash = this.hashOf(key);
        P1HashElement phe = this.i_table[hash & this.i_mask];
        P1HashElement last = null;
        while (phe != null) {
            phe.checkActive();
            if (this.equals(phe, hash, key)) {
                if (last != null) {
                    last.i_next = phe.i_next;
                    last.update();
                } else {
                    this.i_table[hash & this.i_mask] = (P1HashElement)phe.i_next;
                }
                this.modified();
                --this.i_size;
                Object obj = phe.activatedObject(this.elementActivationDepth());
                phe.delete(this.i_deleteRemoved);
                return obj;
            }
            last = phe;
            phe = (P1HashElement)phe.i_next;
        }
        return null;
    }

    private void reposition(P1HashElement a_entry) {
        if (a_entry != null) {
            this.reposition((P1HashElement)a_entry.i_next);
            a_entry.checkActive();
            P1ListElement oldNext = a_entry.i_next;
            a_entry.i_next = this.i_table[a_entry.i_hashCode & this.i_mask];
            if (a_entry.i_next != oldNext) {
                a_entry.update();
            }
            this.i_table[a_entry.i_hashCode & this.i_mask] = a_entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.streamLock();
        synchronized (object) {
            this.checkActive();
            return this.i_size;
        }
    }

    public Object storedTo(Transaction a_trans) {
        if (this.getTrans() == null) {
            this.setTrans(a_trans);
            this.modified();
        } else if (a_trans != this.getTrans()) {
            throw new NotImplementedException();
        }
        return this;
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    private class MapEntry
    implements Map.Entry {
        private Object key;
        private Object value;

        public MapEntry(Object key_) {
            this.key = key_;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value_) {
            Object result = this.value;
            this.value = value_;
            return result;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MapEntry)) {
                return false;
            }
            MapEntry other = (MapEntry)obj;
            return this.key.equals(other.key) && this.value.equals(other.value);
        }

        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }
    }
}

