/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.defragment;

import com.db4o.defragment.AbstractContextIDMapping;
import com.db4o.defragment.DefragmentServicesImpl;
import com.db4o.foundation.Iterator4;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.Transaction;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.btree.BTreePointer;
import com.db4o.internal.btree.BTreeRange;
import com.db4o.internal.mapping.MappedIDPair;
import com.db4o.internal.mapping.MappedIDPairHandler;

public class BTreeIDMapping
extends AbstractContextIDMapping {
    private String _fileName;
    private LocalObjectContainer _mappingDb;
    private BTree _idTree;
    private MappedIDPair _cache = new MappedIDPair(0, 0);
    private BTreeSpec _treeSpec = null;
    private int _commitFrequency = 0;
    private int _insertCount = 0;

    public BTreeIDMapping(String fileName) {
        this(fileName, null, 0);
    }

    public BTreeIDMapping(String fileName, int nodeSize, int commitFrequency) {
        this(fileName, new BTreeSpec(nodeSize), commitFrequency);
    }

    private BTreeIDMapping(String fileName, BTreeSpec treeSpec, int commitFrequency) {
        this._fileName = fileName;
        this._treeSpec = treeSpec;
        this._commitFrequency = commitFrequency;
    }

    public int mappedID(int oldID, boolean lenient) {
        if (this._cache.orig() == oldID) {
            return this._cache.mapped();
        }
        int classID = this.mappedClassID(oldID);
        if (classID != 0) {
            return classID;
        }
        BTreeRange range = this._idTree.search(this.trans(), new MappedIDPair(oldID, 0));
        Iterator4 pointers = range.pointers();
        if (pointers.moveNext()) {
            BTreePointer pointer = (BTreePointer)pointers.current();
            this._cache = (MappedIDPair)pointer.key();
            return this._cache.mapped();
        }
        if (lenient) {
            return this.mapLenient(oldID, range);
        }
        return 0;
    }

    private int mapLenient(int oldID, BTreeRange range) {
        BTreePointer pointer = (range = range.smaller()).lastPointer();
        if (pointer == null) {
            return 0;
        }
        MappedIDPair mappedIDs = (MappedIDPair)pointer.key();
        return mappedIDs.mapped() + (oldID - mappedIDs.orig());
    }

    protected void mapNonClassIDs(int origID, int mappedID) {
        this._cache = new MappedIDPair(origID, mappedID);
        this._idTree.add(this.trans(), this._cache);
        if (this._commitFrequency > 0) {
            ++this._insertCount;
            if (this._commitFrequency == this._insertCount) {
                this._idTree.commit(this.trans());
                this._insertCount = 0;
            }
        }
    }

    public void open() {
        this._mappingDb = DefragmentServicesImpl.freshYapFile(this._fileName, 1);
        MappedIDPairHandler handler = new MappedIDPairHandler();
        this._idTree = this._treeSpec == null ? new BTree(this.trans(), 0, handler) : new BTree(this.trans(), 0, handler, this._treeSpec.nodeSize());
    }

    public void close() {
        this._mappingDb.close();
    }

    private Transaction trans() {
        return this._mappingDb.systemTransaction();
    }

    private static class BTreeSpec {
        private int _nodeSize;

        public BTreeSpec(int nodeSize) {
            this._nodeSize = nodeSize;
        }

        public int nodeSize() {
            return this._nodeSize;
        }
    }
}

