/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation;

import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.ArrayIterator4;
import com.db4o.foundation.Iterator4;

public class CompositeIterator4
implements Iterator4 {
    protected final Iterator4 _iterators;
    protected Iterator4 _currentIterator;

    public CompositeIterator4(Iterator4[] iterators) {
        this(new ArrayIterator4(iterators));
    }

    public CompositeIterator4(Iterator4 iterators) {
        if (null == iterators) {
            throw new ArgumentNullException();
        }
        this._iterators = iterators;
    }

    public boolean moveNext() {
        if (null == this._currentIterator) {
            if (!this._iterators.moveNext()) {
                return false;
            }
            this._currentIterator = this.nextIterator(this._iterators.current());
        }
        if (!this._currentIterator.moveNext()) {
            this._currentIterator = null;
            return this.moveNext();
        }
        return true;
    }

    public void reset() {
        this.resetIterators();
        this._currentIterator = null;
        this._iterators.reset();
    }

    private void resetIterators() {
        this._iterators.reset();
        while (this._iterators.moveNext()) {
            this.nextIterator(this._iterators.current()).reset();
        }
    }

    public Iterator4 currentIterator() {
        return this._currentIterator;
    }

    public Object current() {
        return this._currentIterator.current();
    }

    protected Iterator4 nextIterator(Object current) {
        return (Iterator4)current;
    }
}

