/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.BlobStatus;
import com.db4o.BlobTransport;
import com.db4o.foundation.io.File4;
import com.db4o.internal.Db4oTypeImpl;
import com.db4o.internal.Messages;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.Transaction;
import com.db4o.internal.activation.FixedActivationDepth;
import com.db4o.types.Blob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class BlobImpl
implements Blob,
Cloneable,
Db4oTypeImpl {
    public static final int COPYBUFFER_LENGTH = 4096;
    public String fileName;
    public String i_ext;
    private transient File i_file;
    private transient BlobStatus i_getStatusFrom;
    public int i_length;
    private transient double i_status = -1.0;
    private transient ObjectContainerBase i_stream;
    private transient Transaction i_trans;

    public int adjustReadDepth(int depth) {
        return 1;
    }

    public boolean canBind() {
        return true;
    }

    private String checkExt(File file) {
        String name = file.getName();
        int pos = name.lastIndexOf(".");
        if (pos > 0) {
            this.i_ext = name.substring(pos);
            return name.substring(0, pos);
        }
        this.i_ext = "";
        return name;
    }

    private static void copy(File from, File to) throws IOException {
        File4.copyFile(from, to);
    }

    public Object createDefault(Transaction a_trans) {
        BlobImpl bi = null;
        try {
            bi = (BlobImpl)this.clone();
            bi.setTrans(a_trans);
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        return bi;
    }

    public FileInputStream getClientInputStream() throws Exception {
        return new FileInputStream(this.i_file);
    }

    public FileOutputStream getClientOutputStream() throws Exception {
        return new FileOutputStream(this.i_file);
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLength() {
        return this.i_length;
    }

    public double getStatus() {
        if (this.i_status == -5.0 && this.i_getStatusFrom != null) {
            return this.i_getStatusFrom.getStatus();
        }
        if (this.i_status == -1.0 && this.i_length > 0) {
            this.i_status = -2.0;
        }
        return this.i_status;
    }

    public void getStatusFrom(BlobStatus from) {
        this.i_getStatusFrom = from;
    }

    public boolean hasClassIndex() {
        return false;
    }

    public void readFrom(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException(Messages.get(41, file.getAbsolutePath()));
        }
        this.i_length = (int)file.length();
        this.checkExt(file);
        if (this.i_stream.isClient()) {
            this.i_file = file;
            ((BlobTransport)((Object)this.i_stream)).readBlobFrom(this.i_trans, this, file);
        } else {
            this.readLocal(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readLocal(File file) throws IOException {
        File newFile;
        boolean copied = false;
        if (this.fileName == null && !(newFile = new File(this.serverPath(), file.getName())).exists()) {
            BlobImpl.copy(file, newFile);
            copied = true;
            this.fileName = newFile.getName();
        }
        if (!copied) {
            BlobImpl.copy(file, this.serverFile(this.checkExt(file), true));
        }
        Object object = this.i_stream._lock;
        synchronized (object) {
            this.i_stream.storeInternal(this.i_trans, this, false);
        }
        this.i_status = -4.0;
    }

    public void preDeactivate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File serverFile(String promptName, boolean writeToServer) throws IOException {
        Object object = this.i_stream._lock;
        synchronized (object) {
            this.i_stream.activate(this.i_trans, this, new FixedActivationDepth(2));
        }
        String path = this.serverPath();
        this.i_stream.configImpl().ensureDirExists(path);
        if (writeToServer) {
            if (this.fileName == null) {
                this.fileName = promptName != null ? promptName : "b_" + System.currentTimeMillis();
                String tryPath = this.fileName + this.i_ext;
                int i = 0;
                while (new File(path, tryPath).exists()) {
                    tryPath = this.fileName + "_" + i++ + this.i_ext;
                    if (i != 99) continue;
                    this.i_status = -99.0;
                    throw new IOException(Messages.get(40));
                }
                this.fileName = tryPath;
                Object object2 = this.i_stream._lock;
                synchronized (object2) {
                    this.i_stream.storeInternal(this.i_trans, this, false);
                }
            }
        } else if (this.fileName == null) {
            throw new IOException(Messages.get(38));
        }
        String lastTryPath = path + File.separator + this.fileName;
        if (!writeToServer && !new File(lastTryPath).exists()) {
            throw new IOException(Messages.get(39));
        }
        return new File(lastTryPath);
    }

    private String serverPath() throws IOException {
        String path = this.i_stream.configImpl().blobPath();
        if (path == null) {
            path = "blobs";
        }
        this.i_stream.configImpl().ensureDirExists(path);
        return path;
    }

    public void setStatus(double status) {
        this.i_status = status;
    }

    public void setTrans(Transaction a_trans) {
        this.i_trans = a_trans;
        this.i_stream = a_trans.container();
    }

    public void writeLocal(File file) throws IOException {
        BlobImpl.copy(this.serverFile(null, false), file);
        this.i_status = -4.0;
    }

    public void writeTo(File file) throws IOException {
        if (this.getStatus() == -1.0) {
            throw new IOException(Messages.get(43));
        }
        if (this.i_stream.isClient()) {
            this.i_file = file;
            this.i_status = -3.0;
            ((BlobTransport)((Object)this.i_stream)).writeBlobTo(this.i_trans, this, file);
        } else {
            this.writeLocal(file);
        }
    }

    public Object storedTo(Transaction a_trans) {
        return this;
    }

    public void setObjectReference(ObjectReference a_yapObject) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFile() throws IOException {
        if (this.getStatus() == -1.0) {
            throw new IOException(Messages.get(43));
        }
        if (this.i_stream.isClient()) {
            ((BlobTransport)((Object)this.i_stream)).deleteBlobFile(this.i_trans, this);
        } else {
            this.serverFile(null, false).delete();
        }
        this.fileName = null;
        this.i_ext = null;
        this.i_length = 0;
        this.setStatus(-1.0);
        Object object = this.i_stream._lock;
        synchronized (object) {
            this.i_stream.storeInternal(this.i_trans, this, false);
        }
    }
}

