/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.ObjectContainer;
import com.db4o.defragment.DefragmentServices;
import com.db4o.foundation.BitMap4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.DefragmentContext;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.Handlers4;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ReadWriteBuffer;
import com.db4o.internal.SlotCopyHandler;
import com.db4o.internal.Transaction;
import com.db4o.internal.encoding.LatinStringIO;
import com.db4o.internal.mapping.IDMapping;
import com.db4o.internal.mapping.MappingNotFoundException;
import com.db4o.internal.marshall.ObjectHeader;
import com.db4o.internal.marshall.SlotFormat;
import com.db4o.internal.slots.Slot;
import com.db4o.marshall.ReadBuffer;
import com.db4o.typehandlers.TypeHandler4;
import java.io.IOException;

public final class DefragmentContextImpl
implements ReadWriteBuffer,
DefragmentContext {
    private ByteArrayBuffer _source;
    private ByteArrayBuffer _target;
    private DefragmentServices _services;
    private final ObjectHeader _objectHeader;
    private int _aspectCount;

    public DefragmentContextImpl(ByteArrayBuffer source, DefragmentContextImpl context) {
        this(source, context._services, context._objectHeader);
    }

    public DefragmentContextImpl(ByteArrayBuffer source, DefragmentServices services) {
        this(source, services, null);
    }

    public DefragmentContextImpl(ByteArrayBuffer source, DefragmentServices services, ObjectHeader header) {
        this._source = source;
        this._services = services;
        this._target = new ByteArrayBuffer(this.length());
        this._source.copyTo(this._target, 0, 0, this.length());
        this._objectHeader = header;
    }

    public DefragmentContextImpl(DefragmentContextImpl parentContext, ObjectHeader header) {
        this._source = parentContext._source;
        this._target = parentContext._target;
        this._services = parentContext._services;
        this._objectHeader = header;
    }

    public int offset() {
        return this._source.offset();
    }

    public void seek(int offset) {
        this._source.seek(offset);
        this._target.seek(offset);
    }

    public void incrementOffset(int numBytes) {
        this._source.incrementOffset(numBytes);
        this._target.incrementOffset(numBytes);
    }

    public void incrementIntSize() {
        this.incrementOffset(4);
    }

    public int copySlotlessID() {
        return this.copyUnindexedId(false);
    }

    public int copyUnindexedID() {
        return this.copyUnindexedId(true);
    }

    private int copyUnindexedId(boolean doRegister) {
        int mapped;
        block3: {
            int orig = this._source.readInt();
            if (orig == 0) {
                this._target.writeInt(0);
                return 0;
            }
            mapped = -1;
            try {
                mapped = this._services.mappedID(orig);
            }
            catch (MappingNotFoundException exc) {
                mapped = this._services.allocateTargetSlot(8).address();
                this._services.mapIDs(orig, mapped, false);
                if (!doRegister) break block3;
                this._services.registerUnindexed(orig);
            }
        }
        this._target.writeInt(mapped);
        return mapped;
    }

    public int copyID() {
        int id = this._source.readInt();
        return this.writeMappedID(id);
    }

    public int copyID(boolean flipNegative, boolean lenient) {
        int id = this._source.readInt();
        return this.internalCopyID(flipNegative, lenient, id);
    }

    public int copyIDReturnOriginalID() {
        int id = this._source.readInt();
        this.internalCopyID(false, false, id);
        return id;
    }

    private int internalCopyID(boolean flipNegative, boolean lenient, int id) {
        if (flipNegative && id < 0) {
            id = -id;
        }
        int mapped = this._services.mappedID(id, lenient);
        if (flipNegative && id < 0) {
            mapped = -mapped;
        }
        this._target.writeInt(mapped);
        return mapped;
    }

    public void readBegin(byte identifier) {
        this._source.readBegin(identifier);
        this._target.readBegin(identifier);
    }

    public byte readByte() {
        byte value = this._source.readByte();
        this._target.incrementOffset(1);
        return value;
    }

    public void readBytes(byte[] bytes) {
        this._source.readBytes(bytes);
        this._target.incrementOffset(bytes.length);
    }

    public int readInt() {
        int value = this._source.readInt();
        this._target.incrementOffset(4);
        return value;
    }

    public void writeInt(int value) {
        this._source.incrementOffset(4);
        this._target.writeInt(value);
    }

    public void write(LocalObjectContainer file, int address) {
        file.writeBytes(this._target, address, 0);
    }

    public void incrementStringOffset(LatinStringIO sio) {
        this.incrementStringOffset(sio, this._source);
        this.incrementStringOffset(sio, this._target);
    }

    private void incrementStringOffset(LatinStringIO sio, ByteArrayBuffer buffer) {
        sio.readLengthAndString(buffer);
    }

    public ByteArrayBuffer sourceBuffer() {
        return this._source;
    }

    public ByteArrayBuffer targetBuffer() {
        return this._target;
    }

    public IDMapping mapping() {
        return this._services;
    }

    public Transaction systemTrans() {
        return this.transaction();
    }

    public DefragmentServices services() {
        return this._services;
    }

    public static void processCopy(DefragmentServices services, int sourceID, SlotCopyHandler command) {
        DefragmentContextImpl.processCopy(services, sourceID, command, false);
    }

    public static void processCopy(DefragmentServices context, int sourceID, SlotCopyHandler command, boolean registerAddressMapping) {
        ByteArrayBuffer sourceReader = context.sourceBufferByID(sourceID);
        DefragmentContextImpl.processCopy(context, sourceID, command, registerAddressMapping, sourceReader);
    }

    public static void processCopy(DefragmentServices services, int sourceID, SlotCopyHandler command, boolean registerAddressMapping, ByteArrayBuffer sourceReader) {
        int targetID = services.mappedID(sourceID);
        Slot targetSlot = services.allocateTargetSlot(sourceReader.length());
        if (registerAddressMapping) {
            int sourceAddress = services.sourceAddressByID(sourceID);
            services.mapIDs(sourceAddress, targetSlot.address(), false);
        }
        ByteArrayBuffer targetPointerReader = new ByteArrayBuffer(8);
        targetPointerReader.writeInt(targetSlot.address());
        targetPointerReader.writeInt(targetSlot.length());
        services.targetWriteBytes(targetPointerReader, targetID);
        DefragmentContextImpl context = new DefragmentContextImpl(sourceReader, services);
        command.processCopy(context);
        services.targetWriteBytes(context, targetSlot.address());
    }

    public void writeByte(byte value) {
        this._source.incrementOffset(1);
        this._target.writeByte(value);
    }

    public long readLong() {
        long value = this._source.readLong();
        this._target.incrementOffset(8);
        return value;
    }

    public void writeLong(long value) {
        this._source.incrementOffset(8);
        this._target.writeLong(value);
    }

    public BitMap4 readBitMap(int bitCount) {
        BitMap4 value = this._source.readBitMap(bitCount);
        this._target.incrementOffset(value.marshalledLength());
        return value;
    }

    public void readEnd() {
        this._source.readEnd();
        this._target.readEnd();
    }

    public int writeMappedID(int originalID) {
        int mapped = this._services.mappedID(originalID, false);
        this._target.writeInt(mapped);
        return mapped;
    }

    public int length() {
        return this._source.length();
    }

    public Transaction transaction() {
        return this.services().systemTrans();
    }

    private ObjectContainerBase container() {
        return this.transaction().container();
    }

    public TypeHandler4 typeHandlerForId(int id) {
        return this.container().typeHandlerForId(id);
    }

    public int handlerVersion() {
        return this._objectHeader.handlerVersion();
    }

    public boolean isLegacyHandlerVersion() {
        return this.handlerVersion() == 0;
    }

    public int mappedID(int origID) {
        return this.mapping().mappedID(origID);
    }

    public ObjectContainer objectContainer() {
        return this.container();
    }

    public Slot allocateTargetSlot(int length) {
        return this._services.allocateTargetSlot(length);
    }

    public Slot allocateMappedTargetSlot(int sourceAddress, int length) {
        Slot slot = this.allocateTargetSlot(length);
        this._services.mapIDs(sourceAddress, slot.address(), false);
        return slot;
    }

    public int copySlotToNewMapped(int sourceAddress, int length) throws IOException {
        Slot slot = this.allocateMappedTargetSlot(sourceAddress, length);
        ByteArrayBuffer sourceBuffer = this.sourceBufferByAddress(sourceAddress, length);
        this.targetWriteBytes(slot.address(), sourceBuffer);
        return slot.address();
    }

    public void targetWriteBytes(int address, ByteArrayBuffer buffer) {
        this._services.targetWriteBytes(buffer, address);
    }

    public ByteArrayBuffer sourceBufferByAddress(int sourceAddress, int length) throws IOException {
        ByteArrayBuffer sourceBuffer = this._services.sourceBufferByAddress(sourceAddress, length);
        return sourceBuffer;
    }

    public ByteArrayBuffer sourceBufferById(int sourceId) throws IOException {
        ByteArrayBuffer sourceBuffer = this._services.sourceBufferByID(sourceId);
        return sourceBuffer;
    }

    public void writeToTarget(int address) {
        this._services.targetWriteBytes(this, address);
    }

    public void writeBytes(byte[] bytes) {
        this._target.writeBytes(bytes);
        this._source.incrementOffset(bytes.length);
    }

    public void seekCurrentInt() {
        this.seek(this.readInt());
    }

    public ReadBuffer buffer() {
        return this._source;
    }

    public void defragment(TypeHandler4 handler) {
        TypeHandler4 typeHandler = Handlers4.correctHandlerVersion(this, handler);
        if (FieldMetadata.useDedicatedSlot(this, typeHandler)) {
            if (this.hasClassIndex(typeHandler)) {
                this.copyID();
            } else {
                this.copyUnindexedID();
            }
            return;
        }
        typeHandler.defragment(this);
    }

    private boolean hasClassIndex(TypeHandler4 typeHandler) {
        if (typeHandler instanceof ClassMetadata) {
            return ((ClassMetadata)typeHandler).hasClassIndex();
        }
        return false;
    }

    public void beginSlot() {
    }

    public ClassMetadata classMetadata() {
        return this._objectHeader.classMetadata();
    }

    public boolean isNull(int fieldIndex) {
        return this._objectHeader._headerAttributes.isNull(fieldIndex);
    }

    public int aspectCount() {
        return this._aspectCount;
    }

    public void aspectCount(int count) {
        this._aspectCount = count;
    }

    public SlotFormat slotFormat() {
        return SlotFormat.forHandlerVersion(this.handlerVersion());
    }
}

