/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.CorruptionException;
import com.db4o.config.ObjectTranslator;
import com.db4o.ext.Db4oIOException;
import com.db4o.ext.StoredField;
import com.db4o.foundation.Closure4;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.No4;
import com.db4o.foundation.NotImplementedException;
import com.db4o.foundation.PreparedComparison;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ClassAspect;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Config4Class;
import com.db4o.internal.Config4Field;
import com.db4o.internal.Db4oTypeImpl;
import com.db4o.internal.DefragmentContext;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.FieldIndexException;
import com.db4o.internal.FieldMetadataState;
import com.db4o.internal.HandlerRegistry;
import com.db4o.internal.Handlers4;
import com.db4o.internal.Indexable4;
import com.db4o.internal.IndexableTypeHandler;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.PersistentBase;
import com.db4o.internal.Platform4;
import com.db4o.internal.ReadWriteBuffer;
import com.db4o.internal.ReflectException;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.UntypedFieldHandler;
import com.db4o.internal.activation.ActivationContext4;
import com.db4o.internal.activation.ActivationDepth;
import com.db4o.internal.activation.LegacyActivationDepth;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.btree.BTreeNodeSearchResult;
import com.db4o.internal.btree.BTreeRange;
import com.db4o.internal.btree.FieldIndexKey;
import com.db4o.internal.btree.FieldIndexKeyHandler;
import com.db4o.internal.btree.SearchTarget;
import com.db4o.internal.delete.DeleteContextImpl;
import com.db4o.internal.handlers.PrimitiveHandler;
import com.db4o.internal.handlers.VariableLengthTypeHandler;
import com.db4o.internal.handlers.array.ArrayHandler;
import com.db4o.internal.handlers.array.MultidimensionalArrayHandler;
import com.db4o.internal.marshall.AspectType;
import com.db4o.internal.marshall.AspectVersionContext;
import com.db4o.internal.marshall.CollectIdContext;
import com.db4o.internal.marshall.InternalReadContext;
import com.db4o.internal.marshall.MarshallingContext;
import com.db4o.internal.marshall.ObjectHeader;
import com.db4o.internal.marshall.ObjectIdContext;
import com.db4o.internal.marshall.ObjectIdContextImpl;
import com.db4o.internal.marshall.QueryingReadContext;
import com.db4o.internal.marshall.SlotFormat;
import com.db4o.internal.marshall.UnmarshallingContext;
import com.db4o.internal.query.processor.QConObject;
import com.db4o.internal.query.processor.QField;
import com.db4o.internal.slots.Slot;
import com.db4o.marshall.Context;
import com.db4o.marshall.ReadBuffer;
import com.db4o.reflect.ReflectArray;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectField;
import com.db4o.reflect.generic.GenericField;
import com.db4o.reflect.generic.GenericReflector;
import com.db4o.typehandlers.EmbeddedTypeHandler;
import com.db4o.typehandlers.FirstClassHandler;
import com.db4o.typehandlers.TypeHandler4;

public class FieldMetadata
extends ClassAspect
implements StoredField {
    private ClassMetadata _containingClass;
    private String _name;
    private boolean _isArray;
    private boolean _isNArray;
    private boolean _isPrimitive;
    private ReflectField _reflectField;
    TypeHandler4 _handler;
    protected int _handlerID;
    private FieldMetadataState _state = FieldMetadataState.NOT_LOADED;
    private Config4Field _config;
    private Db4oTypeImpl _db4oType;
    private int _linkLength;
    private BTree _index;
    static final FieldMetadata[] EMPTY_ARRAY = new FieldMetadata[0];
    private boolean _initialized = false;

    public FieldMetadata(ClassMetadata classMetadata) {
        this._containingClass = classMetadata;
    }

    FieldMetadata(ClassMetadata containingClass, ObjectTranslator translator) {
        this(containingClass);
        this.init(containingClass, translator.getClass().getName());
        this._state = FieldMetadataState.AVAILABLE;
        ObjectContainerBase stream = this.container();
        ReflectClass claxx = stream.reflector().forClass(this.translatorStoredClass(translator));
        this._handler = this.fieldHandlerForClass(stream, claxx);
    }

    protected final Class translatorStoredClass(ObjectTranslator translator) {
        try {
            return translator.storedClass();
        }
        catch (RuntimeException e) {
            throw new ReflectException(e);
        }
    }

    FieldMetadata(ClassMetadata containingClass, ReflectField field, TypeHandler4 handler, int handlerID) {
        this(containingClass);
        this.init(containingClass, field.getName());
        this._reflectField = field;
        this._handler = handler;
        this._handlerID = handlerID;
        boolean isPrimitive = false;
        if (field instanceof GenericField) {
            isPrimitive = ((GenericField)field).isPrimitive();
        }
        this.configure(field.getFieldType(), isPrimitive);
        this.checkDb4oType();
        this._state = FieldMetadataState.AVAILABLE;
    }

    protected FieldMetadata(int handlerID, TypeHandler4 handler) {
        this._handlerID = handlerID;
        this._handler = handler;
    }

    public void addFieldIndex(ObjectIdContextImpl context, Slot oldSlot) throws FieldIndexException {
        if (!this.hasIndex()) {
            this.incrementOffset(context);
            return;
        }
        try {
            this.addIndexEntry(context.transaction(), context.id(), this.readIndexEntry(context));
        }
        catch (CorruptionException exc) {
            throw new FieldIndexException(exc, this);
        }
    }

    protected final void addIndexEntry(StatefulBuffer a_bytes, Object indexEntry) {
        this.addIndexEntry(a_bytes.transaction(), a_bytes.getID(), indexEntry);
    }

    public final void addIndexEntry(Transaction trans, int parentID, Object indexEntry) {
        if (!this.hasIndex()) {
            return;
        }
        BTree index = this.getIndex(trans);
        if (index == null) {
            return;
        }
        index.add(trans, this.createFieldIndexKey(parentID, indexEntry));
    }

    private FieldIndexKey createFieldIndexKey(int parentID, Object indexEntry) {
        Object convertedIndexEntry = this.indexEntryFor(indexEntry);
        return new FieldIndexKey(parentID, convertedIndexEntry);
    }

    protected Object indexEntryFor(Object indexEntry) {
        return this._reflectField.indexEntry(indexEntry);
    }

    public boolean canUseNullBitmap() {
        return true;
    }

    public final Object readIndexEntry(ObjectIdContext context) throws CorruptionException, Db4oIOException {
        IndexableTypeHandler indexableTypeHandler = (IndexableTypeHandler)Handlers4.correctHandlerVersion(context, this._handler);
        return indexableTypeHandler.readIndexEntry(context);
    }

    public void removeIndexEntry(Transaction trans, int parentID, Object indexEntry) {
        if (!this.hasIndex()) {
            return;
        }
        if (this._index == null) {
            return;
        }
        this._index.remove(trans, this.createFieldIndexKey(parentID, indexEntry));
    }

    public boolean alive() {
        if (this._state == FieldMetadataState.AVAILABLE) {
            return true;
        }
        if (this._state == FieldMetadataState.NOT_LOADED) {
            if (this._handler == null) {
                this._handler = this.detectHandlerForField();
                this.checkHandlerID();
            }
            this.checkCorrectHandlerForField();
            this._handler = this.wrapHandlerToArrays(this._handler);
            if (this._handler == null || this._reflectField == null) {
                this._state = FieldMetadataState.UNAVAILABLE;
                this._reflectField = null;
            } else if (!this.updating()) {
                this._state = FieldMetadataState.AVAILABLE;
                this.checkDb4oType();
            }
        }
        return this._state == FieldMetadataState.AVAILABLE;
    }

    public boolean updating() {
        return this._state == FieldMetadataState.UPDATING;
    }

    private void checkHandlerID() {
        if (!(this._handler instanceof ClassMetadata)) {
            return;
        }
        ClassMetadata classMetadata = (ClassMetadata)this._handler;
        int id = classMetadata.getID();
        if (this._handlerID == 0) {
            this._handlerID = id;
            return;
        }
        if (id > 0 && id != this._handlerID) {
            this._handler = null;
        }
    }

    boolean canAddToQuery(String fieldName) {
        if (!this.alive()) {
            return false;
        }
        return fieldName.equals(this.getName()) && this.containingClass() != null && !this.containingClass().isInternal();
    }

    public boolean canHold(ReflectClass claxx) {
        if (claxx == null) {
            return !this._isPrimitive;
        }
        return Handlers4.handlerCanHold(this._handler, this.reflector(), claxx);
    }

    private GenericReflector reflector() {
        ObjectContainerBase container = this.container();
        if (container == null) {
            return null;
        }
        return container.reflector();
    }

    public Object coerce(ReflectClass claxx, Object obj) {
        if (claxx == null || obj == null) {
            return this._isPrimitive ? No4.INSTANCE : obj;
        }
        if (this._handler instanceof PrimitiveHandler) {
            return ((PrimitiveHandler)this._handler).coerce(this.reflector(), claxx, obj);
        }
        if (!this.canHold(claxx)) {
            return No4.INSTANCE;
        }
        return obj;
    }

    public final boolean canLoadByIndex() {
        ClassMetadata yc;
        return !(this._handler instanceof ClassMetadata) || !(yc = (ClassMetadata)this._handler).isArray();
    }

    public final void cascadeActivation(Transaction trans, Object onObject, ActivationDepth depth) {
        if (!this.alive()) {
            return;
        }
        if (!(this._handler instanceof FirstClassHandler)) {
            return;
        }
        Object cascadeTo = this.cascadingTarget(trans, depth, onObject);
        if (cascadeTo == null) {
            return;
        }
        this.ensureObjectIsActive(trans, cascadeTo, depth);
        FirstClassHandler cascadingHandler = (FirstClassHandler)this._handler;
        ActivationContext4 context = new ActivationContext4(trans, cascadeTo, depth);
        cascadingHandler.cascadeActivation(context);
    }

    private void ensureObjectIsActive(Transaction trans, Object cascadeTo, ActivationDepth depth) {
        if (!depth.mode().isActivate()) {
            return;
        }
        if (this._handler instanceof EmbeddedTypeHandler) {
            return;
        }
        ObjectContainerBase container = trans.container();
        ClassMetadata classMetadata = container.classMetadataForObject(cascadeTo);
        if (classMetadata == null || classMetadata.isPrimitive()) {
            return;
        }
        if (container.isActive(cascadeTo)) {
            return;
        }
        container.stillToActivate(trans, cascadeTo, depth.descend(classMetadata));
    }

    protected Object cascadingTarget(Transaction trans, ActivationDepth depth, Object onObject) {
        if (depth.mode().isDeactivate()) {
            if (null == this._reflectField) {
                return null;
            }
            return this._reflectField.get(onObject);
        }
        return this.getOrCreate(trans, onObject);
    }

    private void checkDb4oType() {
        if (this._reflectField != null && this.container()._handlers.ICLASS_DB4OTYPE.isAssignableFrom(this._reflectField.getFieldType())) {
            this._db4oType = HandlerRegistry.getDb4oType(this._reflectField.getFieldType());
        }
    }

    void collectConstraints(Transaction trans, QConObject a_parent, Object a_template, Visitor4 a_visitor) {
        Object obj = this.getOn(trans, a_template);
        if (obj != null) {
            Collection4 objs = Platform4.flattenCollection(trans.container(), obj);
            Iterator4 j = objs.iterator();
            while (j.moveNext()) {
                Object nullValue;
                obj = j.current();
                if (obj == null) continue;
                if (this._isPrimitive && this._handler instanceof PrimitiveHandler && obj.equals(nullValue = this._reflectField.getFieldType().nullValue())) {
                    return;
                }
                if (Platform4.ignoreAsConstraint(obj)) {
                    return;
                }
                if (a_parent.hasObjectInParentPath(obj)) continue;
                QConObject constraint = new QConObject(trans, a_parent, this.qField(trans), obj);
                constraint.byExample();
                a_visitor.visit(constraint);
            }
        }
    }

    public final void collectIDs(CollectIdContext context) throws FieldIndexException {
        if (!this.alive()) {
            this.incrementOffset(context.buffer());
            return;
        }
        final TypeHandler4 handler = Handlers4.correctHandlerVersion(context, this._handler);
        if (!(handler instanceof FirstClassHandler)) {
            this.incrementOffset(context.buffer());
            return;
        }
        if (handler instanceof ClassMetadata) {
            context.addId();
            return;
        }
        LocalObjectContainer container = (LocalObjectContainer)context.container();
        SlotFormat slotFormat = context.slotFormat();
        if (slotFormat.handleAsObject(handler)) {
            int collectionID = context.readInt();
            ByteArrayBuffer collectionBuffer = container.readReaderByID(context.transaction(), collectionID);
            ObjectHeader objectHeader = new ObjectHeader(container, (ReadWriteBuffer)collectionBuffer);
            QueryingReadContext subContext = new QueryingReadContext(context.transaction(), context.handlerVersion(), collectionBuffer, collectionID, context.collector());
            objectHeader.classMetadata().collectIDs(subContext);
            return;
        }
        final QueryingReadContext queryingReadContext = new QueryingReadContext(context.transaction(), context.handlerVersion(), context.buffer(), 0, context.collector());
        slotFormat.doWithSlotIndirection(queryingReadContext, handler, new Closure4(){

            public Object run() {
                ((FirstClassHandler)handler).collectIDs(queryingReadContext);
                return null;
            }
        });
    }

    void configure(ReflectClass clazz, boolean isPrimitive) {
        this._isArray = clazz.isArray();
        if (this._isArray) {
            ReflectArray reflectArray = this.reflector().array();
            this._isNArray = reflectArray.isNDimensional(clazz);
            this._isPrimitive = reflectArray.getComponentType(clazz).isPrimitive();
            this._handler = this.wrapHandlerToArrays(this._handler);
        } else {
            this._isPrimitive = isPrimitive | clazz.isPrimitive();
        }
    }

    private final TypeHandler4 wrapHandlerToArrays(TypeHandler4 handler) {
        if (handler == null) {
            return null;
        }
        if (this._isNArray) {
            return new MultidimensionalArrayHandler(handler, this.arraysUsePrimitiveClassReflector());
        }
        if (this._isArray) {
            return new ArrayHandler(handler, this.arraysUsePrimitiveClassReflector());
        }
        return handler;
    }

    private boolean arraysUsePrimitiveClassReflector() {
        return this._isPrimitive;
    }

    public void deactivate(Transaction a_trans, Object a_onObject, ActivationDepth a_depth) {
        if (!this.alive()) {
            return;
        }
        boolean isEnumClass = this._containingClass.isEnum();
        if (this._isPrimitive && !this._isArray) {
            if (!isEnumClass) {
                Object nullValue = this._reflectField.getFieldType().nullValue();
                this._reflectField.set(a_onObject, nullValue);
            }
            return;
        }
        if (a_depth.requiresActivation()) {
            this.cascadeActivation(a_trans, a_onObject, a_depth);
        }
        if (!isEnumClass) {
            this._reflectField.set(a_onObject, null);
        }
    }

    public void delete(DeleteContextImpl context, boolean isUpdate) throws FieldIndexException {
        if (!this.checkAlive(context)) {
            return;
        }
        try {
            this.removeIndexEntry(context);
            StatefulBuffer buffer = (StatefulBuffer)context.buffer();
            final DeleteContextImpl childContext = new DeleteContextImpl(context, this.getStoredType(), this._config);
            context.slotFormat().doWithSlotIndirection(buffer, this._handler, new Closure4(){

                public Object run() {
                    childContext.delete(FieldMetadata.this._handler);
                    return null;
                }
            });
        }
        catch (CorruptionException exc) {
            throw new FieldIndexException(exc, this);
        }
    }

    private final void removeIndexEntry(DeleteContextImpl context) throws CorruptionException, Db4oIOException {
        if (!this.hasIndex()) {
            return;
        }
        int offset = context.offset();
        Object obj = this.readIndexEntry(context);
        this.removeIndexEntry(context.transaction(), context.id(), obj);
        context.seek(offset);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FieldMetadata)) {
            return false;
        }
        FieldMetadata other = (FieldMetadata)obj;
        other.alive();
        this.alive();
        return other._isPrimitive == this._isPrimitive && (this._handler == null && other._handler == null || other._handler.equals(this._handler)) && other._name.equals(this._name);
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public final Object get(Object onObject) {
        return this.get(null, onObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object get(Transaction trans, Object onObject) {
        if (this._containingClass == null) {
            return null;
        }
        ObjectContainerBase container = this.container();
        if (container == null) {
            return null;
        }
        Object object = container._lock;
        synchronized (object) {
            if (trans == null) {
                trans = container.transaction();
            }
            container.checkClosed();
            ObjectReference ref = trans.referenceForObject(onObject);
            if (ref == null) {
                return null;
            }
            int id = ref.getID();
            if (id <= 0) {
                return null;
            }
            UnmarshallingContext context = new UnmarshallingContext(trans, ref, 1, false);
            context.activationDepth(new LegacyActivationDepth(1));
            return context.readFieldValue(this);
        }
    }

    public String getName() {
        return this._name;
    }

    public final ClassMetadata handlerClassMetadata(ObjectContainerBase container) {
        TypeHandler4 handler = this.baseTypeHandler();
        if (Handlers4.handlesSimple(handler)) {
            return container._handlers.classMetadataForId(this.handlerID());
        }
        if (handler instanceof ClassMetadata) {
            return (ClassMetadata)handler;
        }
        return container.classMetadataForReflectClass(this._reflectField.getFieldType());
    }

    private TypeHandler4 baseTypeHandler() {
        return Handlers4.baseTypeHandler(this._handler);
    }

    public TypeHandler4 getHandler() {
        return this._handler;
    }

    public int handlerID() {
        return this._handlerID;
    }

    public Object getOn(Transaction trans, Object onObject) {
        if (this.alive()) {
            return this._reflectField.get(onObject);
        }
        return null;
    }

    public Object getOrCreate(Transaction trans, Object onObject) {
        if (!this.alive()) {
            return null;
        }
        Object obj = this._reflectField.get(onObject);
        if (this._db4oType != null && obj == null) {
            obj = this._db4oType.createDefault(trans);
            this._reflectField.set(onObject, obj);
        }
        return obj;
    }

    public final ClassMetadata containingClass() {
        return this._containingClass;
    }

    public ReflectClass getStoredType() {
        if (this._reflectField == null) {
            return null;
        }
        return Handlers4.baseType(this._reflectField.getFieldType());
    }

    public ObjectContainerBase container() {
        if (this._containingClass == null) {
            return null;
        }
        return this._containingClass.container();
    }

    public boolean hasConfig() {
        return this._config != null;
    }

    public boolean hasIndex() {
        return this._index != null;
    }

    public final void init(ClassMetadata containingClass, String name) {
        this._containingClass = containingClass;
        this._name = name;
        this.initIndex(containingClass, name);
    }

    final void initIndex(ClassMetadata containingClass, String name) {
        if (containingClass.config() == null) {
            return;
        }
        this._config = containingClass.config().configField(name);
    }

    public void init(int handlerID, boolean isPrimitive, boolean isArray, boolean isNArray) {
        this._handlerID = handlerID;
        this._isPrimitive = isPrimitive;
        this._isArray = isArray;
        this._isNArray = isNArray;
    }

    final void initConfigOnUp(Transaction trans) {
        if (this._config != null && !this._initialized) {
            this._initialized = true;
            this._config.initOnUp(trans, this);
        }
    }

    public void instantiate(UnmarshallingContext context) {
        if (!this.checkAlive(context)) {
            return;
        }
        Object toSet = this.read(context);
        this.informAboutTransaction(toSet, context.transaction());
        this.set(context.persistentObject(), toSet);
    }

    public void attemptUpdate(UnmarshallingContext context) {
        if (!this.updating()) {
            this.incrementOffset(context);
            return;
        }
        int savedOffset = context.offset();
        try {
            Object toSet = context.read(this._handler);
            if (toSet != null) {
                this.set(context.persistentObject(), toSet);
            }
        }
        catch (Exception ex) {
            context.buffer().seek(savedOffset);
            this.incrementOffset(context);
        }
    }

    private boolean checkAlive(AspectVersionContext context) {
        if (!this.checkEnabled(context)) {
            return false;
        }
        boolean alive = this.alive();
        if (!alive) {
            this.incrementOffset((ReadBuffer)((Object)context));
        }
        return alive;
    }

    private void informAboutTransaction(Object obj, Transaction trans) {
        if (this._db4oType != null && obj != null) {
            ((Db4oTypeImpl)obj).setTrans(trans);
        }
    }

    public boolean isArray() {
        return this._isArray;
    }

    public int linkLength() {
        this.alive();
        if (this._linkLength == 0) {
            this._linkLength = this.calculateLinkLength();
        }
        return this._linkLength;
    }

    private int calculateLinkLength() {
        if (this._handler == null) {
            return 4;
        }
        if (this._handler instanceof PersistentBase) {
            return ((PersistentBase)((Object)this._handler)).linkLength();
        }
        if (this._handler instanceof PrimitiveHandler) {
            return ((PrimitiveHandler)this._handler).linkLength();
        }
        if (this._handler instanceof VariableLengthTypeHandler) {
            if (this._handler instanceof EmbeddedTypeHandler) {
                return 8;
            }
            return 4;
        }
        throw new NotImplementedException();
    }

    public void loadHandlerById(ObjectContainerBase container) {
        this._handler = (TypeHandler4)container.fieldHandlerForId(this._handlerID);
    }

    private TypeHandler4 detectHandlerForField() {
        ReflectClass claxx = this._containingClass.classReflector();
        if (claxx == null) {
            return null;
        }
        this._reflectField = claxx.getDeclaredField(this._name);
        if (this._reflectField == null) {
            return null;
        }
        return this.fieldHandlerForClass(this.container(), this._reflectField.getFieldType());
    }

    private TypeHandler4 fieldHandlerForClass(ObjectContainerBase container, ReflectClass fieldType) {
        container.showInternalClasses(true);
        TypeHandler4 handlerForClass = (TypeHandler4)container.fieldHandlerForClass(Handlers4.baseType(fieldType));
        container.showInternalClasses(false);
        return handlerForClass;
    }

    private void checkCorrectHandlerForField() {
        TypeHandler4 handler = this.detectHandlerForField();
        if (handler == null) {
            this._reflectField = null;
            this._state = FieldMetadataState.UNAVAILABLE;
            return;
        }
        if (!handler.equals(this._handler)) {
            this._state = FieldMetadataState.UPDATING;
        }
    }

    private int adjustUpdateDepthForCascade(Object obj, int updateDepth) {
        int minimumUpdateDepth = 1;
        if (this._containingClass.isCollection(obj)) {
            GenericReflector reflector = this.reflector();
            minimumUpdateDepth = reflector.collectionUpdateDepth(reflector.forObject(obj));
        }
        if (updateDepth < minimumUpdateDepth) {
            return minimumUpdateDepth;
        }
        return updateDepth;
    }

    private boolean cascadeOnUpdate(Config4Class parentClassConfiguration) {
        return parentClassConfiguration != null && parentClassConfiguration.cascadeOnUpdate().definiteYes() || this._config != null && this._config.cascadeOnUpdate().definiteYes();
    }

    public void marshall(MarshallingContext context, Object obj) {
        int updateDepth = context.updateDepth();
        if (obj != null && this.cascadeOnUpdate(context.classConfiguration())) {
            context.updateDepth(this.adjustUpdateDepthForCascade(obj, updateDepth));
        }
        if (FieldMetadata.useDedicatedSlot(context, this._handler)) {
            context.writeObject(this._handler, obj);
        } else {
            context.createIndirectionWithinSlot(this._handler);
            this._handler.write(context, obj);
        }
        context.updateDepth(updateDepth);
        if (this.hasIndex()) {
            context.addIndexEntry(this, obj);
        }
    }

    public static boolean useDedicatedSlot(Context context, TypeHandler4 handler) {
        if (handler instanceof EmbeddedTypeHandler) {
            return false;
        }
        if (handler instanceof UntypedFieldHandler) {
            return false;
        }
        if (handler instanceof ClassMetadata) {
            return FieldMetadata.useDedicatedSlot(context, ((ClassMetadata)handler).delegateTypeHandler());
        }
        return true;
    }

    public boolean needsArrayAndPrimitiveInfo() {
        return true;
    }

    public boolean needsHandlerId() {
        return true;
    }

    public PreparedComparison prepareComparison(Context context, Object obj) {
        if (!this.alive()) {
            return null;
        }
        return this._handler.prepareComparison(context, obj);
    }

    public QField qField(Transaction a_trans) {
        int yapClassID = 0;
        if (this._containingClass != null) {
            yapClassID = this._containingClass.getID();
        }
        return new QField(a_trans, this._name, this, yapClassID, this._handle);
    }

    public Object read(InternalReadContext context) {
        if (!this.canReadFromSlot((AspectVersionContext)((Object)context))) {
            this.incrementOffset(context);
            return null;
        }
        return context.read(this._handler);
    }

    private boolean canReadFromSlot(AspectVersionContext context) {
        if (!this.enabled(context)) {
            return false;
        }
        if (this.alive()) {
            return true;
        }
        return this._state != FieldMetadataState.NOT_LOADED;
    }

    public void refreshActivated() {
        this._state = FieldMetadataState.AVAILABLE;
        this.refresh();
    }

    void refresh() {
        TypeHandler4 handler = this.detectHandlerForField();
        if (handler != null && (handler = this.wrapHandlerToArrays(handler)).equals(this._handler)) {
            return;
        }
        this._reflectField = null;
        this._state = FieldMetadataState.UNAVAILABLE;
    }

    public void rename(String newName) {
        ObjectContainerBase container = this.container();
        if (!container.isClient()) {
            this._name = newName;
            this._containingClass.setStateDirty();
            this._containingClass.write(container.systemTransaction());
        } else {
            Exceptions4.throwRuntimeException(58);
        }
    }

    public void set(Object onObject, Object obj) {
        if (null == this._reflectField) {
            return;
        }
        this._reflectField.set(onObject, obj);
    }

    void setName(String a_name) {
        this._name = a_name;
    }

    boolean supportsIndex() {
        return this.alive() && this._handler instanceof Indexable4 && !(this._handler instanceof UntypedFieldHandler);
    }

    public final void traverseValues(Visitor4 userVisitor) {
        if (!this.alive()) {
            return;
        }
        this.traverseValues(this.container().transaction(), userVisitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void traverseValues(Transaction transaction, final Visitor4 userVisitor) {
        if (!this.alive()) {
            return;
        }
        this.assertHasIndex();
        ObjectContainerBase stream = transaction.container();
        if (stream.isClient()) {
            Exceptions4.throwRuntimeException(67);
        }
        Object object = stream.lock();
        synchronized (object) {
            final Context context = transaction.context();
            this._index.traverseKeys(transaction, new Visitor4(){

                public void visit(Object obj) {
                    FieldIndexKey key = (FieldIndexKey)obj;
                    userVisitor.visit(((IndexableTypeHandler)FieldMetadata.this._handler).indexEntryToObject(context, key.value()));
                }
            });
        }
    }

    private void assertHasIndex() {
        if (!this.hasIndex()) {
            Exceptions4.throwRuntimeException(66);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this._containingClass != null) {
            sb.append(this._containingClass.getName());
            sb.append(".");
            sb.append(this.getName());
        }
        return sb.toString();
    }

    private void initIndex(Transaction systemTrans) {
        this.initIndex(systemTrans, 0);
    }

    public void initIndex(Transaction systemTrans, int id) {
        if (this._index != null) {
            throw new IllegalStateException();
        }
        if (systemTrans.container().isClient()) {
            return;
        }
        this._index = this.newBTree(systemTrans, id);
    }

    protected final BTree newBTree(Transaction systemTrans, int id) {
        ObjectContainerBase stream = systemTrans.container();
        Indexable4 indexHandler = this.indexHandler(stream);
        if (indexHandler == null) {
            return null;
        }
        return new BTree(systemTrans, id, new FieldIndexKeyHandler(indexHandler));
    }

    protected Indexable4 indexHandler(ObjectContainerBase stream) {
        if (this._reflectField == null) {
            return null;
        }
        ReflectClass indexType = this._reflectField.indexType();
        TypeHandler4 classHandler = this.fieldHandlerForClass(stream, indexType);
        if (!(classHandler instanceof Indexable4)) {
            return null;
        }
        return (Indexable4)((Object)classHandler);
    }

    public BTree getIndex(Transaction trans) {
        return this._index;
    }

    public boolean isVirtual() {
        return false;
    }

    public boolean isPrimitive() {
        return this._isPrimitive;
    }

    public BTreeRange search(Transaction transaction, Object value) {
        this.assertHasIndex();
        Object transActionalValue = this.wrapWithTransactionContext(transaction, value);
        BTreeNodeSearchResult lowerBound = this.searchLowerBound(transaction, transActionalValue);
        BTreeNodeSearchResult upperBound = this.searchUpperBound(transaction, transActionalValue);
        return lowerBound.createIncludingRange(upperBound);
    }

    private Object wrapWithTransactionContext(Transaction transaction, Object value) {
        if (this._handler instanceof ClassMetadata) {
            value = ((ClassMetadata)this._handler).wrapWithTransactionContext(transaction, value);
        }
        return value;
    }

    private BTreeNodeSearchResult searchUpperBound(Transaction transaction, Object value) {
        return this.searchBound(transaction, Integer.MAX_VALUE, value);
    }

    private BTreeNodeSearchResult searchLowerBound(Transaction transaction, Object value) {
        return this.searchBound(transaction, 0, value);
    }

    private BTreeNodeSearchResult searchBound(Transaction transaction, int parentID, Object keyPart) {
        return this.getIndex(transaction).searchLeaf(transaction, this.createFieldIndexKey(parentID, keyPart), SearchTarget.LOWEST);
    }

    public boolean rebuildIndexForClass(LocalObjectContainer stream, ClassMetadata yapClass) {
        long[] ids = yapClass.getIDs();
        for (int i = 0; i < ids.length; ++i) {
            this.rebuildIndexForObject(stream, yapClass, (int)ids[i]);
        }
        return ids.length > 0;
    }

    protected void rebuildIndexForObject(LocalObjectContainer stream, ClassMetadata classMetadata, int objectId) throws FieldIndexException {
        StatefulBuffer writer = stream.readWriterByID(stream.systemTransaction(), objectId);
        if (writer != null) {
            this.rebuildIndexForWriter(stream, writer, objectId);
        }
    }

    protected void rebuildIndexForWriter(LocalObjectContainer stream, StatefulBuffer writer, int objectId) {
        ObjectHeader oh = new ObjectHeader(stream, (ReadWriteBuffer)writer);
        Object obj = this.readIndexEntryForRebuild(writer, oh);
        this.addIndexEntry(stream.systemTransaction(), objectId, obj);
    }

    private final Object readIndexEntryForRebuild(StatefulBuffer writer, ObjectHeader oh) {
        ClassMetadata classMetadata = oh.classMetadata();
        if (classMetadata == null) {
            return null;
        }
        ObjectIdContextImpl context = new ObjectIdContextImpl(writer.transaction(), writer, oh, writer.getID());
        if (!classMetadata.seekToField(context, this)) {
            return null;
        }
        try {
            return this.readIndexEntry(context);
        }
        catch (CorruptionException exc) {
            throw new FieldIndexException(exc, this);
        }
    }

    public void dropIndex(Transaction systemTrans) {
        if (this._index == null) {
            return;
        }
        ObjectContainerBase stream = systemTrans.container();
        if (stream.configImpl().messageLevel() > 0) {
            stream.message("dropping index " + this.toString());
        }
        this._index.free(systemTrans);
        stream.setDirtyInSystemTransaction(this.containingClass());
        this._index = null;
    }

    public void defragAspect(final DefragmentContext context) {
        final TypeHandler4 typeHandler = Handlers4.correctHandlerVersion(context, this._handler);
        context.slotFormat().doWithSlotIndirection(context, typeHandler, new Closure4(){

            public Object run() {
                context.defragment(typeHandler);
                return null;
            }
        });
    }

    public void createIndex() {
        if (this.hasIndex()) {
            return;
        }
        LocalObjectContainer container = (LocalObjectContainer)this.container();
        if (container.configImpl().messageLevel() > 0) {
            container.message("creating index " + this.toString());
        }
        this.initIndex(container.systemTransaction());
        container.setDirtyInSystemTransaction(this.containingClass());
        this.reindex(container);
    }

    private void reindex(LocalObjectContainer container) {
        ClassMetadata clazz = this.containingClass();
        if (this.rebuildIndexForClass(container, clazz)) {
            container.systemTransaction().commit();
        }
    }

    public AspectType aspectType() {
        return AspectType.FIELD;
    }

    public boolean canBeDisabled() {
        return true;
    }
}

