/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.foundation.Hashtable4;
import com.db4o.internal.HandlerRegistry;
import com.db4o.internal.TypeHandlerCloneContext;
import com.db4o.internal.VersionedTypeHandler;
import com.db4o.internal.fieldhandlers.FieldHandler;
import com.db4o.typehandlers.TypeHandler4;

public class HandlerVersionRegistry {
    private final HandlerRegistry _registry;
    private final Hashtable4 _versions = new Hashtable4();

    public HandlerVersionRegistry(HandlerRegistry registry) {
        this._registry = registry;
    }

    public void put(FieldHandler handler, int version, TypeHandler4 replacement) {
        this._versions.put(new HandlerVersionKey(handler, version), (Object)replacement);
    }

    public TypeHandler4 correctHandlerVersion(TypeHandler4 originalHandler, int version) {
        if (version >= 4) {
            return originalHandler;
        }
        if (originalHandler == null) {
            return null;
        }
        TypeHandler4 replacement = (TypeHandler4)this._versions.get(new HandlerVersionKey(this.genericTemplate(originalHandler), version));
        if (replacement == null) {
            return this.correctHandlerVersion(originalHandler, version + 1);
        }
        if (replacement instanceof VersionedTypeHandler) {
            return (TypeHandler4)((VersionedTypeHandler)replacement).deepClone(new TypeHandlerCloneContext(this._registry, originalHandler, version));
        }
        return replacement;
    }

    private TypeHandler4 genericTemplate(TypeHandler4 handler) {
        if (handler instanceof VersionedTypeHandler) {
            return ((VersionedTypeHandler)handler).unversionedTemplate();
        }
        return handler;
    }

    private class HandlerVersionKey {
        private final FieldHandler _handler;
        private final int _version;

        public HandlerVersionKey(FieldHandler handler, int version) {
            this._handler = handler;
            this._version = version;
        }

        public int hashCode() {
            return this._handler.hashCode() + this._version * 4271;
        }

        public boolean equals(Object obj) {
            HandlerVersionKey other = (HandlerVersionKey)obj;
            return this._handler.equals(other._handler) && this._version == other._version;
        }
    }
}

