/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.DTrace;
import com.db4o.TransactionListener;
import com.db4o.activation.ActivationPurpose;
import com.db4o.activation.Activator;
import com.db4o.ext.Db4oUUID;
import com.db4o.ext.ObjectInfo;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Db4oTypeImpl;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.NullTransactionListener;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.PersistentBase;
import com.db4o.internal.Platform4;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.VirtualAttributes;
import com.db4o.internal.activation.ActivationDepth;
import com.db4o.internal.activation.ActivationMode;
import com.db4o.internal.activation.DescendingActivationDepth;
import com.db4o.internal.activation.TransparentActivationDepthProvider;
import com.db4o.internal.marshall.MarshallingContext;
import com.db4o.internal.marshall.UnmarshallingContext;
import com.db4o.internal.slots.Pointer4;
import com.db4o.reflect.ReflectClass;
import com.db4o.ta.TransparentPersistenceSupport;

public class ObjectReference
extends PersistentBase
implements ObjectInfo,
Activator {
    private ClassMetadata _class;
    private Object _object;
    private VirtualAttributes _virtualAttributes;
    private ObjectReference _idPreceding;
    private ObjectReference _idSubsequent;
    private int _idSize;
    private ObjectReference _hcPreceding;
    private ObjectReference _hcSubsequent;
    private int _hcSize;
    public int _hcHashcode;
    private int _lastTopLevelCallId;
    private transient TransactionListener _updateListener;

    public ObjectReference() {
    }

    public ObjectReference(int id) {
        this._id = id;
        if (DTrace.enabled) {
            DTrace.OBJECT_REFERENCE_CREATED.log(id);
        }
    }

    public ObjectReference(ClassMetadata classMetadata, int id) {
        this(id);
        this._class = classMetadata;
    }

    public void activate(ActivationPurpose purpose) {
        this.activateOn(this.container().transaction(), purpose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateOn(Transaction transaction, ActivationPurpose purpose) {
        Object object;
        ObjectContainerBase container = transaction.container();
        if (ActivationPurpose.WRITE == purpose) {
            object = container.lock();
            synchronized (object) {
                this.enlistForUpdate(transaction);
            }
        }
        if (this.isActive()) {
            return;
        }
        object = container.lock();
        synchronized (object) {
            TransparentActivationDepthProvider provider = (TransparentActivationDepthProvider)container.activationDepthProvider();
            this.activate(transaction, this.getObject(), new DescendingActivationDepth(provider, ActivationMode.ACTIVATE));
        }
    }

    private void enlistForUpdate(final Transaction transaction) {
        if (null != this._updateListener) {
            return;
        }
        final TransparentPersistenceSupport transparentPersistence = this.configuredTransparentPersistence();
        if (null == transparentPersistence) {
            this._updateListener = NullTransactionListener.INSTANCE;
            return;
        }
        this._updateListener = new TransactionListener(){

            public void postRollback() {
                ObjectReference.this.resetListener();
                transparentPersistence.rollback(transaction.objectContainer(), ObjectReference.this.getObject());
            }

            public void preCommit() {
                ObjectReference.this.resetListener();
                ObjectReference.this.container().store(transaction, ObjectReference.this.getObject());
            }
        };
        transaction.addTransactionListener(this._updateListener);
    }

    private void resetListener() {
        this._updateListener = null;
    }

    private TransparentPersistenceSupport configuredTransparentPersistence() {
        Iterator4 iterator = this.container().config().configurationItemsIterator();
        while (iterator.moveNext()) {
            if (!(iterator.current() instanceof TransparentPersistenceSupport)) continue;
            return (TransparentPersistenceSupport)iterator.current();
        }
        return null;
    }

    public void activate(Transaction ta, Object obj, ActivationDepth depth) {
        this.activateInternal(ta, obj, depth);
        ta.container().activatePending(ta);
    }

    void activateInternal(Transaction ta, Object obj, ActivationDepth depth) {
        if (!depth.requiresActivation()) {
            return;
        }
        ObjectContainerBase container = ta.container();
        if (depth.mode().isRefresh()) {
            this.logActivation(container, "refresh");
        } else {
            if (this.isActive() && obj != null) {
                this._class.activateFields(ta, obj, depth);
                return;
            }
            this.logActivation(container, "activate");
        }
        this.readForActivation(ta, obj, depth);
    }

    private void readForActivation(Transaction ta, Object obj, ActivationDepth depth) {
        this.read(ta, null, obj, depth, 0, false);
    }

    private void logActivation(ObjectContainerBase container, String event) {
        this.logEvent(container, event, 2);
    }

    private void logEvent(ObjectContainerBase container, String event, int level) {
        if (container.configImpl().messageLevel() > level) {
            container.message("" + this.getID() + " " + event + " " + this._class.getName());
        }
    }

    boolean continueSet(Transaction trans, int updateDepth) {
        if (!this.bitIsTrue(4)) {
            return true;
        }
        if (!this._class.stateOKAndAncestors()) {
            return false;
        }
        if (DTrace.enabled) {
            DTrace.CONTINUESET.log(this.getID());
        }
        this.bitFalse(4);
        MarshallingContext context = new MarshallingContext(trans, this, updateDepth, true);
        this.classMetadata().write(context, this.getObject());
        Pointer4 pointer = context.allocateSlot();
        ByteArrayBuffer buffer = context.ToWriteBuffer(pointer);
        ObjectContainerBase container = trans.container();
        container.writeNew(trans, pointer, this._class, buffer);
        Object obj = this._object;
        this.objectOnNew(trans, obj);
        if (!this._class.isPrimitive()) {
            this._object = container._references.createYapRef(this, obj);
        }
        this.setStateClean();
        this.endProcessing();
        return true;
    }

    private void objectOnNew(Transaction transaction, Object obj) {
        ObjectContainerBase container = transaction.container();
        container.callbacks().objectOnNew(transaction, obj);
        this._class.dispatchEvent(transaction, obj, 4);
    }

    public void deactivate(Transaction trans, ActivationDepth depth) {
        if (!depth.requiresActivation()) {
            return;
        }
        Object obj = this.getObject();
        if (obj == null) {
            return;
        }
        if (obj instanceof Db4oTypeImpl) {
            ((Db4oTypeImpl)obj).preDeactivate();
        }
        ObjectContainerBase container = trans.container();
        this.logActivation(container, "deactivate");
        this.setStateDeactivated();
        this._class.deactivate(trans, obj, depth);
    }

    public byte getIdentifier() {
        return 79;
    }

    public long getInternalID() {
        return this.getID();
    }

    public Object getObject() {
        if (Platform4.hasWeakReferences()) {
            return Platform4.getYapRefObject(this._object);
        }
        return this._object;
    }

    public Object getObjectReference() {
        return this._object;
    }

    public ObjectContainerBase container() {
        if (this._class == null) {
            throw new IllegalStateException();
        }
        return this._class.container();
    }

    public Transaction transaction() {
        return this.container().transaction();
    }

    public Db4oUUID getUUID() {
        VirtualAttributes va = this.virtualAttributes(this.transaction());
        if (va != null && va.i_database != null) {
            return new Db4oUUID(va.i_uuid, va.i_database.i_signature);
        }
        return null;
    }

    public long getVersion() {
        VirtualAttributes va = this.virtualAttributes(this.transaction());
        if (va == null) {
            return 0L;
        }
        return va.i_version;
    }

    public final ClassMetadata classMetadata() {
        return this._class;
    }

    public void classMetadata(ClassMetadata classMetadata) {
        this._class = classMetadata;
    }

    public int ownLength() {
        throw Exceptions4.shouldNeverBeCalled();
    }

    public VirtualAttributes produceVirtualAttributes() {
        if (this._virtualAttributes == null) {
            this._virtualAttributes = new VirtualAttributes();
        }
        return this._virtualAttributes;
    }

    final Object peekPersisted(Transaction trans, ActivationDepth depth) {
        return this.read(trans, depth, -1, false);
    }

    final Object read(Transaction trans, ActivationDepth instantiationDepth, int addToIDTree, boolean checkIDTree) {
        return this.read(trans, null, null, instantiationDepth, addToIDTree, checkIDTree);
    }

    public final Object read(Transaction trans, StatefulBuffer buffer, Object obj, ActivationDepth instantiationDepth, int addToIDTree, boolean checkIDTree) {
        UnmarshallingContext context = new UnmarshallingContext(trans, buffer, this, addToIDTree, checkIDTree);
        context.persistentObject(obj);
        context.activationDepth(instantiationDepth);
        return context.read();
    }

    public final Object readPrefetch(Transaction trans, StatefulBuffer buffer) {
        return new UnmarshallingContext(trans, buffer, this, 1, false).readPrefetch();
    }

    public final void readThis(Transaction trans, ByteArrayBuffer buffer) {
    }

    public void setObjectWeak(ObjectContainerBase container, Object obj) {
        if (container._references._weak) {
            if (this._object != null) {
                Platform4.killYapRef(this._object);
            }
            this._object = Platform4.createActiveObjectReference(container._references._queue, this, obj);
        } else {
            this._object = obj;
        }
    }

    public void setObject(Object obj) {
        this._object = obj;
    }

    final void store(Transaction trans, ClassMetadata classMetadata, Object obj) {
        this._object = obj;
        this._class = classMetadata;
        this.writeObjectBegin();
        int id = trans.container().newUserObject();
        trans.slotFreePointerOnRollback(id);
        this.setID(id);
        this.beginProcessing();
        this.bitTrue(4);
    }

    public void flagForDelete(int callId) {
        this._lastTopLevelCallId = -callId;
    }

    public boolean isFlaggedForDelete() {
        return this._lastTopLevelCallId < 0;
    }

    public void flagAsHandled(int callId) {
        this._lastTopLevelCallId = callId;
    }

    public final boolean isFlaggedAsHandled(int callID) {
        return this._lastTopLevelCallId == callID;
    }

    public final boolean isValid() {
        return ObjectReference.isValidId(this.getID()) && this.getObject() != null;
    }

    public static final boolean isValidId(int id) {
        return id > 0;
    }

    public VirtualAttributes virtualAttributes() {
        return this._virtualAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualAttributes virtualAttributes(Transaction trans, boolean lastCommitted) {
        if (trans == null) {
            return this._virtualAttributes;
        }
        Object object = trans.container().lock();
        synchronized (object) {
            if (this._virtualAttributes == null) {
                if (this._class.hasVirtualAttributes()) {
                    this._virtualAttributes = new VirtualAttributes();
                    this._class.readVirtualAttributes(trans, this, lastCommitted);
                }
            } else if (!this._virtualAttributes.suppliesUUID() && this._class.hasVirtualAttributes()) {
                this._class.readVirtualAttributes(trans, this, lastCommitted);
            }
            return this._virtualAttributes;
        }
    }

    public VirtualAttributes virtualAttributes(Transaction trans) {
        return this.virtualAttributes(trans, true);
    }

    public void setVirtualAttributes(VirtualAttributes at) {
        this._virtualAttributes = at;
    }

    public void writeThis(Transaction trans, ByteArrayBuffer buffer) {
    }

    public void writeUpdate(Transaction transaction, int updatedepth) {
        this.continueSet(transaction, updatedepth);
        if (!this.beginProcessing()) {
            return;
        }
        Object obj = this.getObject();
        if (!(this.objectCanUpdate(transaction, obj) && this.isActive() && obj != null && this.classMetadata().isModified(obj))) {
            this.endProcessing();
            return;
        }
        ObjectContainerBase container = transaction.container();
        this.logEvent(container, "update", 1);
        this.setStateClean();
        transaction.writeUpdateDeleteMembers(this.getID(), this._class, container._handlers.arrayType(obj), 0);
        MarshallingContext context = new MarshallingContext(transaction, this, updatedepth, false);
        this._class.write(context, obj);
        Pointer4 pointer = context.allocateSlot();
        ByteArrayBuffer buffer = context.ToWriteBuffer(pointer);
        container.writeUpdate(transaction, pointer, this.classMetadata(), buffer);
        if (this.isActive()) {
            this.setStateClean();
        }
        this.endProcessing();
        container.callbacks().objectOnUpdate(transaction, obj);
        this.classMetadata().dispatchEvent(transaction, obj, 5);
    }

    private boolean objectCanUpdate(Transaction transaction, Object obj) {
        ObjectContainerBase container = transaction.container();
        return container.callbacks().objectCanUpdate(transaction, obj) && this._class.dispatchEvent(transaction, obj, 9);
    }

    public void ref_init() {
        this.hc_init();
        this.id_init();
    }

    public ObjectReference hc_add(ObjectReference newRef) {
        if (newRef.getObject() == null) {
            return this;
        }
        newRef.hc_init();
        return this.hc_add1(newRef);
    }

    private void hc_init() {
        this._hcPreceding = null;
        this._hcSubsequent = null;
        this._hcSize = 1;
        this._hcHashcode = ObjectReference.hc_getCode(this.getObject());
    }

    /*
     * Enabled aggressive block sorting
     */
    private ObjectReference hc_add1(ObjectReference newRef) {
        int cmp = this.hc_compare(newRef);
        if (cmp < 0) {
            if (this._hcPreceding == null) {
                this._hcPreceding = newRef;
                ++this._hcSize;
                return this;
            }
            this._hcPreceding = this._hcPreceding.hc_add1(newRef);
            if (this._hcSubsequent != null) return this.hc_balance();
            return this.hc_rotateRight();
        }
        if (this._hcSubsequent == null) {
            this._hcSubsequent = newRef;
            ++this._hcSize;
            return this;
        }
        this._hcSubsequent = this._hcSubsequent.hc_add1(newRef);
        if (this._hcPreceding != null) return this.hc_balance();
        return this.hc_rotateLeft();
    }

    private ObjectReference hc_balance() {
        int cmp = this._hcSubsequent._hcSize - this._hcPreceding._hcSize;
        if (cmp < -2) {
            return this.hc_rotateRight();
        }
        if (cmp > 2) {
            return this.hc_rotateLeft();
        }
        this._hcSize = this._hcPreceding._hcSize + this._hcSubsequent._hcSize + 1;
        return this;
    }

    private void hc_calculateSize() {
        this._hcSize = this._hcPreceding == null ? (this._hcSubsequent == null ? 1 : this._hcSubsequent._hcSize + 1) : (this._hcSubsequent == null ? this._hcPreceding._hcSize + 1 : this._hcPreceding._hcSize + this._hcSubsequent._hcSize + 1);
    }

    private int hc_compare(ObjectReference toRef) {
        int cmp = toRef._hcHashcode - this._hcHashcode;
        if (cmp == 0) {
            cmp = toRef._id - this._id;
        }
        return cmp;
    }

    public ObjectReference hc_find(Object obj) {
        return this.hc_find(ObjectReference.hc_getCode(obj), obj);
    }

    private ObjectReference hc_find(int id, Object obj) {
        int cmp = id - this._hcHashcode;
        if (cmp < 0) {
            if (this._hcPreceding != null) {
                return this._hcPreceding.hc_find(id, obj);
            }
        } else if (cmp > 0) {
            if (this._hcSubsequent != null) {
                return this._hcSubsequent.hc_find(id, obj);
            }
        } else {
            ObjectReference inPreceding;
            if (obj == this.getObject()) {
                return this;
            }
            if (this._hcPreceding != null && (inPreceding = this._hcPreceding.hc_find(id, obj)) != null) {
                return inPreceding;
            }
            if (this._hcSubsequent != null) {
                return this._hcSubsequent.hc_find(id, obj);
            }
        }
        return null;
    }

    public static int hc_getCode(Object obj) {
        int hcode = System.identityHashCode(obj);
        if (hcode < 0) {
            hcode ^= 0xFFFFFFFF;
        }
        return hcode;
    }

    private ObjectReference hc_rotateLeft() {
        ObjectReference tree = this._hcSubsequent;
        this._hcSubsequent = tree._hcPreceding;
        this.hc_calculateSize();
        tree._hcPreceding = this;
        tree._hcSize = tree._hcSubsequent == null ? 1 + this._hcSize : 1 + this._hcSize + tree._hcSubsequent._hcSize;
        return tree;
    }

    private ObjectReference hc_rotateRight() {
        ObjectReference tree = this._hcPreceding;
        this._hcPreceding = tree._hcSubsequent;
        this.hc_calculateSize();
        tree._hcSubsequent = this;
        tree._hcSize = tree._hcPreceding == null ? 1 + this._hcSize : 1 + this._hcSize + tree._hcPreceding._hcSize;
        return tree;
    }

    private ObjectReference hc_rotateSmallestUp() {
        if (this._hcPreceding != null) {
            this._hcPreceding = this._hcPreceding.hc_rotateSmallestUp();
            return this.hc_rotateRight();
        }
        return this;
    }

    ObjectReference hc_remove(ObjectReference findRef) {
        if (this == findRef) {
            return this.hc_remove();
        }
        int cmp = this.hc_compare(findRef);
        if (cmp <= 0 && this._hcPreceding != null) {
            this._hcPreceding = this._hcPreceding.hc_remove(findRef);
        }
        if (cmp >= 0 && this._hcSubsequent != null) {
            this._hcSubsequent = this._hcSubsequent.hc_remove(findRef);
        }
        this.hc_calculateSize();
        return this;
    }

    public void hc_traverse(Visitor4 visitor) {
        if (this._hcPreceding != null) {
            this._hcPreceding.hc_traverse(visitor);
        }
        if (this._hcSubsequent != null) {
            this._hcSubsequent.hc_traverse(visitor);
        }
        visitor.visit(this);
    }

    private ObjectReference hc_remove() {
        if (this._hcSubsequent != null && this._hcPreceding != null) {
            this._hcSubsequent = this._hcSubsequent.hc_rotateSmallestUp();
            this._hcSubsequent._hcPreceding = this._hcPreceding;
            this._hcSubsequent.hc_calculateSize();
            return this._hcSubsequent;
        }
        if (this._hcSubsequent != null) {
            return this._hcSubsequent;
        }
        return this._hcPreceding;
    }

    ObjectReference id_add(ObjectReference newRef) {
        newRef.id_init();
        return this.id_add1(newRef);
    }

    private void id_init() {
        this._idPreceding = null;
        this._idSubsequent = null;
        this._idSize = 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private ObjectReference id_add1(ObjectReference newRef) {
        int cmp = newRef._id - this._id;
        if (cmp < 0) {
            if (this._idPreceding == null) {
                this._idPreceding = newRef;
                ++this._idSize;
                return this;
            }
            this._idPreceding = this._idPreceding.id_add1(newRef);
            if (this._idSubsequent != null) return this.id_balance();
            return this.id_rotateRight();
        }
        if (cmp <= 0) return this;
        if (this._idSubsequent == null) {
            this._idSubsequent = newRef;
            ++this._idSize;
            return this;
        }
        this._idSubsequent = this._idSubsequent.id_add1(newRef);
        if (this._idPreceding != null) return this.id_balance();
        return this.id_rotateLeft();
    }

    private ObjectReference id_balance() {
        int cmp = this._idSubsequent._idSize - this._idPreceding._idSize;
        if (cmp < -2) {
            return this.id_rotateRight();
        }
        if (cmp > 2) {
            return this.id_rotateLeft();
        }
        this._idSize = this._idPreceding._idSize + this._idSubsequent._idSize + 1;
        return this;
    }

    private void id_calculateSize() {
        this._idSize = this._idPreceding == null ? (this._idSubsequent == null ? 1 : this._idSubsequent._idSize + 1) : (this._idSubsequent == null ? this._idPreceding._idSize + 1 : this._idPreceding._idSize + this._idSubsequent._idSize + 1);
    }

    ObjectReference id_find(int id) {
        int cmp = id - this._id;
        if (cmp > 0) {
            if (this._idSubsequent != null) {
                return this._idSubsequent.id_find(id);
            }
        } else if (cmp < 0) {
            if (this._idPreceding != null) {
                return this._idPreceding.id_find(id);
            }
        } else {
            return this;
        }
        return null;
    }

    private ObjectReference id_rotateLeft() {
        ObjectReference tree = this._idSubsequent;
        this._idSubsequent = tree._idPreceding;
        this.id_calculateSize();
        tree._idPreceding = this;
        tree._idSize = tree._idSubsequent == null ? this._idSize + 1 : this._idSize + 1 + tree._idSubsequent._idSize;
        return tree;
    }

    private ObjectReference id_rotateRight() {
        ObjectReference tree = this._idPreceding;
        this._idPreceding = tree._idSubsequent;
        this.id_calculateSize();
        tree._idSubsequent = this;
        tree._idSize = tree._idPreceding == null ? this._idSize + 1 : this._idSize + 1 + tree._idPreceding._idSize;
        return tree;
    }

    private ObjectReference id_rotateSmallestUp() {
        if (this._idPreceding != null) {
            this._idPreceding = this._idPreceding.id_rotateSmallestUp();
            return this.id_rotateRight();
        }
        return this;
    }

    ObjectReference id_remove(int id) {
        int cmp = id - this._id;
        if (cmp < 0) {
            if (this._idPreceding != null) {
                this._idPreceding = this._idPreceding.id_remove(id);
            }
        } else if (cmp > 0) {
            if (this._idSubsequent != null) {
                this._idSubsequent = this._idSubsequent.id_remove(id);
            }
        } else {
            return this.id_remove();
        }
        this.id_calculateSize();
        return this;
    }

    private ObjectReference id_remove() {
        if (this._idSubsequent != null && this._idPreceding != null) {
            this._idSubsequent = this._idSubsequent.id_rotateSmallestUp();
            this._idSubsequent._idPreceding = this._idPreceding;
            this._idSubsequent.id_calculateSize();
            return this._idSubsequent;
        }
        if (this._idSubsequent != null) {
            return this._idSubsequent;
        }
        return this._idPreceding;
    }

    public String toString() {
        try {
            ObjectContainerBase container;
            int id = this.getID();
            String str = "ObjectReference\nID=" + id;
            Object obj = this.getObject();
            if (this._class != null && (container = this._class.container()) != null && id > 0) {
                obj = container.peekPersisted(container.transaction(), id, container.defaultActivationDepth(this.classMetadata()), true).toString();
            }
            if (obj == null) {
                str = str + "\nfor [null]";
            } else {
                String objToString = "";
                try {
                    objToString = obj.toString();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this.classMetadata() != null) {
                    ReflectClass claxx = this.classMetadata().reflector().forObject(obj);
                    str = str + "\n" + claxx.getName();
                }
                str = str + "\n" + objToString;
            }
            return str;
        }
        catch (Exception exception) {
            return "ObjectReference " + this.getID();
        }
    }
}

