/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.DTrace;
import com.db4o.ObjectContainer;
import com.db4o.TransactionListener;
import com.db4o.foundation.Iterator4Impl;
import com.db4o.foundation.List4;
import com.db4o.foundation.Tree;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.DeleteInfo;
import com.db4o.internal.HardObjectReference;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.Platform4;
import com.db4o.internal.ReferenceSystem;
import com.db4o.internal.TransactionalReferenceSystem;
import com.db4o.internal.TreeInt;
import com.db4o.internal.slots.Pointer4;
import com.db4o.internal.slots.Slot;
import com.db4o.marshall.Context;
import com.db4o.reflect.Reflector;

public abstract class Transaction {
    protected Tree _delete;
    protected final Transaction _systemTransaction;
    private final ObjectContainerBase _container;
    private ObjectContainer _objectContainer;
    private List4 _transactionListeners;
    private final TransactionalReferenceSystem _referenceSystem;

    public Transaction(ObjectContainerBase container, Transaction systemTransaction, TransactionalReferenceSystem referenceSystem) {
        this._container = container;
        this._systemTransaction = systemTransaction;
        this._referenceSystem = referenceSystem;
    }

    public final void checkSynchronization() {
    }

    public void addTransactionListener(TransactionListener listener) {
        this._transactionListeners = new List4(this._transactionListeners, listener);
    }

    protected final void clearAll() {
        this.clear();
        this._transactionListeners = null;
    }

    protected abstract void clear();

    public void close(boolean rollbackOnClose) {
        if (this.container() != null) {
            this.checkSynchronization();
            this.container().releaseSemaphores(this);
            if (this._referenceSystem != null) {
                this.container().referenceSystemRegistry().removeReferenceSystem(this._referenceSystem);
            }
        }
        if (rollbackOnClose) {
            this.rollback();
        }
    }

    public abstract void commit();

    protected void commitTransactionListeners() {
        this.checkSynchronization();
        if (this._transactionListeners != null) {
            Iterator4Impl i = new Iterator4Impl(this._transactionListeners);
            while (i.moveNext()) {
                ((TransactionListener)i.current()).preCommit();
            }
            this._transactionListeners = null;
        }
    }

    public abstract boolean isDeleted(int var1);

    protected boolean isSystemTransaction() {
        return this._systemTransaction == null;
    }

    public boolean delete(ObjectReference ref, int id, int cascade) {
        DeleteInfo info;
        this.checkSynchronization();
        if (ref != null && !this._container.flagForDelete(ref)) {
            return false;
        }
        if (DTrace.enabled) {
            DTrace.TRANS_DELETE.log(id);
        }
        if ((info = (DeleteInfo)TreeInt.find(this._delete, id)) == null) {
            info = new DeleteInfo(id, ref, cascade);
            this._delete = Tree.add(this._delete, info);
            return true;
        }
        info._reference = ref;
        if (cascade > info._cascade) {
            info._cascade = cascade;
        }
        return true;
    }

    public void dontDelete(int a_id) {
        if (DTrace.enabled) {
            DTrace.TRANS_DONT_DELETE.log(a_id);
        }
        if (this._delete == null) {
            return;
        }
        this._delete = TreeInt.removeLike((TreeInt)this._delete, a_id);
    }

    public HardObjectReference getHardReferenceBySignature(long a_uuid, byte[] a_signature) {
        this.checkSynchronization();
        return this.container().uUIDIndex().getHardObjectReferenceBySignature(this, a_uuid, a_signature);
    }

    public abstract void processDeletes();

    public ReferenceSystem referenceSystem() {
        if (this._referenceSystem != null) {
            return this._referenceSystem;
        }
        return this.parentTransaction().referenceSystem();
    }

    public Reflector reflector() {
        return this.container().reflector();
    }

    public abstract void rollback();

    protected void rollBackTransactionListeners() {
        this.checkSynchronization();
        if (this._transactionListeners != null) {
            Iterator4Impl i = new Iterator4Impl(this._transactionListeners);
            while (i.moveNext()) {
                ((TransactionListener)i.current()).postRollback();
            }
            this._transactionListeners = null;
        }
    }

    public final void setPointer(Pointer4 pointer) {
        this.setPointer(pointer._id, pointer._slot);
    }

    public void setPointer(int id, Slot slot) {
    }

    public void slotDelete(int id, Slot slot) {
    }

    public void slotFreeOnCommit(int id, Slot slot) {
    }

    public void slotFreeOnRollback(int id, Slot slot) {
    }

    void slotFreeOnRollbackCommitSetPointer(int id, Slot slot, boolean forFreespace) {
    }

    void produceUpdateSlotChange(int id, Slot slot) {
    }

    public void slotFreePointerOnCommit(int id) {
    }

    void slotFreePointerOnCommit(int id, Slot slot) {
    }

    public void slotFreePointerOnRollback(int id) {
    }

    boolean supportsVirtualFields() {
        return true;
    }

    public Transaction systemTransaction() {
        if (this._systemTransaction != null) {
            return this._systemTransaction;
        }
        return this;
    }

    public String toString() {
        return this.container().toString();
    }

    public abstract void writeUpdateDeleteMembers(int var1, ClassMetadata var2, int var3, int var4);

    public final ObjectContainerBase container() {
        return this._container;
    }

    public Transaction parentTransaction() {
        return this._systemTransaction;
    }

    public void rollbackReferenceSystem() {
        this.referenceSystem().rollback();
    }

    public void commitReferenceSystem() {
        this.referenceSystem().commit();
    }

    public void addNewReference(ObjectReference ref) {
        this.referenceSystem().addNewReference(ref);
    }

    public final Object objectForIdFromCache(int id) {
        ObjectReference ref = this.referenceForId(id);
        if (ref == null) {
            return null;
        }
        Object candidate = ref.getObject();
        if (candidate == null) {
            this.removeReference(ref);
        }
        return candidate;
    }

    public final ObjectReference referenceForId(int id) {
        ObjectReference ref = this.referenceSystem().referenceForId(id);
        if (ref != null) {
            return ref;
        }
        if (this.parentTransaction() != null) {
            return this.parentTransaction().referenceForId(id);
        }
        return null;
    }

    public final ObjectReference referenceForObject(Object obj) {
        ObjectReference ref = this.referenceSystem().referenceForObject(obj);
        if (ref != null) {
            return ref;
        }
        if (this.parentTransaction() != null) {
            return this.parentTransaction().referenceForObject(obj);
        }
        return null;
    }

    public final void removeReference(ObjectReference ref) {
        this.referenceSystem().removeReference(ref);
        ref.setID(-1);
        Platform4.killYapRef(ref.getObjectReference());
    }

    public final void removeObjectFromReferenceSystem(Object obj) {
        ObjectReference ref = this.referenceForObject(obj);
        if (ref != null) {
            this.removeReference(ref);
        }
    }

    public void setOutSideRepresentation(ObjectContainer objectContainer) {
        this._objectContainer = objectContainer;
    }

    public ObjectContainer objectContainer() {
        if (this._objectContainer != null) {
            return this._objectContainer;
        }
        return this._container;
    }

    public Context context() {
        return new Context(){

            public ObjectContainer objectContainer() {
                return Transaction.this.objectContainer();
            }

            public Transaction transaction() {
                return Transaction.this;
            }
        };
    }
}

